/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.wwwauth;

import com.pingidentity.sdk.oauth20.AccessToken;
import com.pingidentity.sdk.oauth20.Scope;
import java.util.Collection;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.oauth20.dpop.DpopUtil;
import org.sourceid.oauth20.dpop.InvalidDpopProofException;
import org.sourceid.oauth20.dpop.UseDpopNonceException;
import org.sourceid.oauth20.wwwauth.AccessTokenUtil;
import org.sourceid.saml20.domain.BearerAccessTokenMgmtPluginInstance;
import org.sourceid.saml20.domain.mgmt.BearerAccessTokenMgmtPluginManager;
import org.sourceid.websso.profiles.idp.AsAuditLogger;
import org.sourceid.websso.servlet.HttpStatusCodeException;

public class AccessTokenSupport {
    private static final Log log = LogFactory.getLog(AccessTokenSupport.class);
    private final BearerAccessTokenMgmtPluginManager tokenManager;
    private final Scope requiredScopes;
    private final AccessTokenUtil accessTokenUtil;
    private BearerAccessTokenMgmtPluginInstance instanceUsed;

    public AccessTokenSupport(BearerAccessTokenMgmtPluginManager tokenManager, String realm, Scope requiredScopes, Scope suggestedScopes) {
        this.tokenManager = tokenManager;
        this.requiredScopes = requiredScopes;
        this.accessTokenUtil = new AccessTokenUtil(suggestedScopes, realm);
    }

    public AccessToken getAccessToken(HttpServletRequest request, Collection<BearerAccessTokenMgmtPluginInstance> allowedInstances, boolean skipDpopProofValidation) throws HttpStatusCodeException {
        Scope scope;
        String token;
        AccessTokenUtil.setErrorResponseContentType(request, "application/json");
        String bearerToken = this.accessTokenUtil.getBearerAccessToken(request, false);
        String dpopToken = DpopUtil.getAccessTokenFromAuthorizationHeader(request);
        if (bearerToken != null && dpopToken != null) {
            throw this.accessTokenUtil.statusCodeExBearerAndDpop(400, AccessTokenUtil.ErrorCode.invalid_request, "Multiple methods used to include access token");
        }
        String string = token = bearerToken != null ? bearerToken : dpopToken;
        if (token == null) {
            throw this.accessTokenUtil.statusCodeExBearerAndDpop(401, AccessTokenUtil.ErrorCode.invalid_request, "No access token sent");
        }
        AsAuditLogger.setAccessTokenTrackingId(token);
        AsAuditLogger.setInAccessTokenHash(token);
        AccessToken accessToken = null;
        for (BearerAccessTokenMgmtPluginInstance instance : allowedInstances) {
            accessToken = this.tokenManager.validateAccessToken(Collections.singletonList(instance.getId()), token).getAccessToken();
            if (accessToken == null) continue;
            this.instanceUsed = instance;
            break;
        }
        if (accessToken == null || accessToken.isExpired()) {
            if (accessToken != null && accessToken.isExpired()) {
                log.debug((Object)"Access token is expired");
            } else {
                log.debug((Object)"None of the allowed token managers for this endpoint and client were able to validate the access token");
            }
            throw this.accessTokenUtil.statusCodeEx(401, AccessTokenUtil.ErrorCode.invalid_token, null, dpopToken != null);
        }
        boolean isDpopBoundAccessToken = DpopUtil.isDpopBoundAccessToken(accessToken.getAttributes());
        if (isDpopBoundAccessToken && dpopToken == null) {
            log.debug((Object)"The access token is a DPoP token but sent as a Bearer token");
            throw this.accessTokenUtil.statusCodeEx(401, AccessTokenUtil.ErrorCode.invalid_token, "Invalid token type", false);
        }
        if (!isDpopBoundAccessToken && bearerToken == null) {
            log.debug((Object)"The access token is a Bearer token but sent as a DPoP token");
            throw this.accessTokenUtil.statusCodeEx(401, AccessTokenUtil.ErrorCode.invalid_token, "Invalid token type", true);
        }
        if (!skipDpopProofValidation && isDpopBoundAccessToken) {
            try {
                DpopUtil.validateDpopProofInHeader(request, true, token, accessToken);
            }
            catch (InvalidDpopProofException e) {
                throw this.accessTokenUtil.statusCodeEx(401, AccessTokenUtil.ErrorCode.invalid_token, e.getMessage(), true);
            }
            catch (UseDpopNonceException e) {
                throw this.accessTokenUtil.statusCodeEx(401, AccessTokenUtil.ErrorCode.use_dpop_nonce, e.getMessage(), true);
            }
        }
        if (!(scope = Scope.getScope((String)accessToken.getScope())).hasAllScopes(this.requiredScopes)) {
            log.debug((Object)"Access token is missing one of the scopes required to access this endpoint");
            throw this.accessTokenUtil.statusCodeEx(403, AccessTokenUtil.ErrorCode.insufficient_scope, null, isDpopBoundAccessToken);
        }
        return accessToken;
    }

    public BearerAccessTokenMgmtPluginInstance getInstanceUsed() {
        return this.instanceUsed;
    }
}

