/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.openid.ciba.bindings;

import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jose4j.jwa.AlgorithmConstraints;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.NumericDate;
import org.jose4j.jwt.consumer.ErrorCodeValidator;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.jwt.consumer.JwtContext;
import org.jose4j.keys.resolvers.VerificationKeyResolver;
import org.sourceid.common.dsig.SignatureStatus;
import org.sourceid.oauth20.bindings.AbstractJSONEndpointBinding;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientVerificationKeyResolver;
import org.sourceid.oauth20.domain.NbfTooLongAgoValidator;
import org.sourceid.oauth20.handlers.AccessTokenRequestException;
import org.sourceid.oauth20.handlers.BaseClientAuthnRequestHandler;
import org.sourceid.oauth20.issuer.OAuthAudienceUtils;
import org.sourceid.oauth20.issuer.OAuthIssuerUtils;
import org.sourceid.openid.ciba.bindings.CibaInMessageContext;
import org.sourceid.openid.ciba.handlers.CibaHelper;
import org.sourceid.openid.connect.domain.OpenIdConnectProviderInfo;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.websso.AuditLogger;
import org.sourceid.websso.profiles.idp.AsAuditLogger;
import org.sourceid.websso.servlet.HttpStatusCodeException;
import org.sourceid.websso.wrapper.InMessageContext;

public class CibaAuthenticationRequestBinding
extends AbstractJSONEndpointBinding {
    private final Log log = LogFactory.getLog(this.getClass());
    private final CibaHelper cibaHelper = new CibaHelper();
    private final OAuthIssuerUtils oAuthIssuerUtils;
    private final OAuthAudienceUtils oAuthAudienceUtils;
    private final int maxFutureValidityInMinutes = this.cibaHelper.getConfig().getIntValue("signed-request-maxFutureValidityInMinutes", 720);
    private final int secondsOfAllowedClockSkew = this.cibaHelper.getConfig().getIntValue("signed-request-secondsOfAllowedClockSkew", 30);
    private final ErrorCodeValidator iatReasonablenessValidator = new ErrorCodeValidator(){
        private final int iatReasonableness;
        {
            this.iatReasonableness = CibaAuthenticationRequestBinding.this.cibaHelper.getConfig().getIntValue("signed-request-iatReasonablenessInMinutes", 720) * 60;
        }

        public ErrorCodeValidator.Error validate(JwtContext jwtContext) throws MalformedClaimException {
            NumericDate iat = jwtContext.getJwtClaims().getIssuedAt();
            if (iat != null) {
                NumericDate now = NumericDate.now();
                if (Math.abs(iat.getValue() - now.getValue()) > (long)this.iatReasonableness) {
                    String msg = "iat (" + iat + ") is too far from now (" + now + ") to be reasonable (with " + this.iatReasonableness / 60 + " minutes being a reasonable venture at reasonableness).";
                    return new ErrorCodeValidator.Error(17, msg);
                }
            }
            return null;
        }
    };
    private final ErrorCodeValidator nbfTooLongAgoValidator = new NbfTooLongAgoValidator(this.cibaHelper.getConfig().getIntValue("signed-request-nbfMaxPastInMinutes", 720));
    private final AlgorithmConstraints verificationAlgorithmConstraints;

    CibaAuthenticationRequestBinding() {
        this(OAuthIssuerUtils.getInstance(), OAuthAudienceUtils.getInstance());
    }

    CibaAuthenticationRequestBinding(OAuthIssuerUtils oAuthIssuerUtils, OAuthAudienceUtils oAuthAudienceUtils) {
        this.oAuthIssuerUtils = oAuthIssuerUtils;
        this.oAuthAudienceUtils = oAuthAudienceUtils;
        List<String> verificationAlgorithmsSupported = OpenIdConnectProviderInfo.getVerificationAlgorithmsSupported();
        String[] algs = verificationAlgorithmsSupported.toArray(new String[0]);
        this.verificationAlgorithmConstraints = new AlgorithmConstraints(AlgorithmConstraints.ConstraintType.WHITELIST, algs);
    }

    @Override
    public InMessageContext receive(HttpServletRequest req, HttpServletResponse resp, Role partnerRole) throws HttpStatusCodeException {
        CibaInMessageContext ctx;
        block17: {
            AuditLogger.setEvent("CIBA");
            AuditLogger.setProtocol("OAuth20");
            AuditLogger.setRole("AS");
            this.oAuthIssuerUtils.setAuditLogVirtualServerIdIfApplicable(req);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"entering receive");
            }
            if (!StringUtils.equals((String)req.getMethod(), (String)"POST")) {
                String message = "Please use POST when making requests to the Backchannel Authentication Endpoint.";
                throw new HttpStatusCodeException(message, 405);
            }
            ctx = new CibaInMessageContext();
            ctx.setIsRequest(true);
            try {
                Client client = BaseClientAuthnRequestHandler.findValidClient(req);
                AsAuditLogger.setConnectionId(client.getClientId());
                if (client.getClientId() == null) {
                    throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_request, "client identification is required");
                }
                if (!client.isEnabled()) {
                    throw new AccessTokenRequestException(AccessTokenRequestException.Error.unauthorized_client, "The requesting client is not active.");
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("identified client " + client.getClientId()));
                }
                ctx.setClient(client);
                if (!client.getGrantTypes().contains("urn:openid:params:grant-type:ciba") || client.getCibaTokenDeliveryMode() == null) {
                    throw new AccessTokenRequestException(AccessTokenRequestException.Error.unauthorized_client, "The requesting client is not allowed to use CIBA.");
                }
                String requestJwt = req.getParameter("request");
                if (requestJwt == null) {
                    ctx.setSignatureStatus(SignatureStatus.NOT_PRESENT);
                    for (String parameterName : CibaInMessageContext.AUTHENTICATION_REQUEST_PARAMETERS) {
                        String value = req.getParameter(parameterName);
                        if (value == null) continue;
                        ctx.setParam(parameterName, value);
                    }
                    break block17;
                }
                ClientVerificationKeyResolver verificationKeyResolver = new ClientVerificationKeyResolver(client, false);
                Set<String> audienceValues = this.oAuthAudienceUtils.getAudienceValues(req);
                JwtConsumer jwtConsumer = new JwtConsumerBuilder().setExpectedIssuer(client.getClientId()).setVerificationKeyResolver((VerificationKeyResolver)verificationKeyResolver).setExpectedAudience(audienceValues.toArray(new String[0])).setRequireExpirationTime().setRequireIssuedAt().registerValidator(this.iatReasonablenessValidator).registerValidator(this.nbfTooLongAgoValidator).setRequireNotBefore().setRequireJwtId().setMaxFutureValidityInMinutes(this.maxFutureValidityInMinutes).setAllowedClockSkewInSeconds(this.secondsOfAllowedClockSkew).setJwsAlgorithmConstraints(this.getSigRequiredConstraints(client)).setSkipVerificationKeyResolutionOnNone().build();
                try {
                    JwtClaims requestClaims = jwtConsumer.processToClaims(requestJwt);
                    ctx.setSignatureStatus(SignatureStatus.VALID);
                    for (String parameterName : CibaInMessageContext.AUTHENTICATION_REQUEST_PARAMETERS) {
                        if (req.getParameter(parameterName) != null) {
                            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_request, "Authentication request parameters (such as " + parameterName + ") MUST NOT be present outside of the JWT when a signed authentication request is used.");
                        }
                        Object paramObjectValue = requestClaims.getClaimValue(parameterName);
                        if (paramObjectValue == null) continue;
                        String paramValue = paramObjectValue.toString();
                        ctx.setParam(parameterName, paramValue);
                    }
                    this.cibaHelper.processRequestHintTokenClaims("request", ctx.getHintAttributes(), requestClaims);
                    if (requestClaims.getJwtId() != null) {
                        AuditLogger.setRequestJti(requestClaims.getJwtId());
                    }
                }
                catch (InvalidJwtException e) {
                    ctx.setSignatureStatus(SignatureStatus.INVALID);
                    throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_request, e.getMessage());
                }
                catch (MalformedClaimException e) {
                    this.log.error((Object)("Unable to get jti from JWT request. Jti will not be included in the security audit log record for this transaction: " + e.getMessage()));
                    this.log.debug((Object)e);
                }
            }
            catch (AccessTokenRequestException e) {
                ctx.setDeferredException(e);
            }
        }
        ctx.setMaskedParamName("user_code");
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("processed request into inbound context params: " + ctx.getParams()));
        }
        return ctx;
    }

    @Override
    public String getUri() {
        return "ciba:authn-req";
    }

    private AlgorithmConstraints getSigRequiredConstraints(Client client) {
        if (StringUtils.isNotBlank((String)client.getCibaRequestObjectSigningAlgorithm())) {
            return new AlgorithmConstraints(AlgorithmConstraints.ConstraintType.WHITELIST, new String[]{client.getCibaRequestObjectSigningAlgorithm()});
        }
        return this.verificationAlgorithmConstraints;
    }
}

