/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.openid.ciba.domain;

import com.pingidentity.util.DateUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.lang.JoseException;
import org.sourceid.saml20.domain.AttributeMapping;

public class CibaServerPolicy {
    public static final String DEFAULT_TRANSACTION_LIFE_IN_SECONDS = "120";
    public static final String USER_HINT_KEY = "IDENTITY_HINT_SUBJECT";
    public static final String PCV_USERNAME_KEY = "USER_CODE_USER_NAME";
    public static final String USER_LOCALE_KEY = "USER_LOCALE";
    public static final String REQUESTED_SCOPE_KEY = "REQUESTED_SCOPE";
    public static final String REQUESTED_SCOPE_DESCRIPTIONS_KEY = "REQUESTED_SCOPE_DESCRIPTIONS";
    private String defaultRequestHandlingPolicyId;
    private Map<String, RequestHandlingPolicy> requestHandlingPolicies = new LinkedHashMap<String, RequestHandlingPolicy>();

    public String getDefaultRequestHandlingPolicyId() {
        return this.defaultRequestHandlingPolicyId;
    }

    public void setDefaultRequestHandlingPolicyId(String defaultRequestHandlingPolicyId) {
        this.defaultRequestHandlingPolicyId = defaultRequestHandlingPolicyId;
    }

    public Map<String, RequestHandlingPolicy> getRequestHandlingPolicies() {
        return this.requestHandlingPolicies;
    }

    public void setRequestHandlingPolicies(Map<String, RequestHandlingPolicy> requestHandlingPolicies) {
        this.requestHandlingPolicies = requestHandlingPolicies;
    }

    public void addRequestHandlingPolicy(RequestHandlingPolicy requestHandlingPolicy) {
        this.requestHandlingPolicies.put(requestHandlingPolicy.getId(), requestHandlingPolicy);
    }

    public boolean containsRequestHandlingPolicy(String id) {
        return this.requestHandlingPolicies.containsKey(id);
    }

    public RequestHandlingPolicy getRequestHandlingPolicy(String id) {
        return this.requestHandlingPolicies.get(id);
    }

    public void removeRequestHandlingPolicy(String id) {
        this.requestHandlingPolicies.remove(id);
    }

    public static class RequestHandlingPolicy {
        private String id;
        private String name;
        private String pluginId;
        private int transactionLifeInSeconds;
        private boolean allowUnsignedLoginHintToken;
        private boolean requireTokenForHint;
        private String userCodePcvId;
        private List<String> requestHintAttributeContract;
        private AttributeMapping enhanceRequestHintContractMapping;
        private AttributeMapping hintContractToOOBAuthPluginMapping;
        private Calendar lastModified;
        private List<AlternativeLoginHintTokenIssuer> alternativeLoginHintTokenIssuers = new ArrayList<AlternativeLoginHintTokenIssuer>();

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getPluginId() {
            return this.pluginId;
        }

        public void setPluginId(String pluginId) {
            this.pluginId = pluginId;
        }

        public int getTransactionLifeInSeconds() {
            return this.transactionLifeInSeconds;
        }

        public void setTransactionLifeInSeconds(int transactionLifeInSeconds) {
            this.transactionLifeInSeconds = transactionLifeInSeconds;
        }

        public boolean isAllowUnsignedLoginHintToken() {
            return this.allowUnsignedLoginHintToken;
        }

        public void setAllowUnsignedLoginHintToken(boolean allowUnsignedLoginHintToken) {
            this.allowUnsignedLoginHintToken = allowUnsignedLoginHintToken;
        }

        public boolean isRequireTokenForHint() {
            return this.requireTokenForHint;
        }

        public void setRequireTokenForHint(boolean requireTokenForHint) {
            this.requireTokenForHint = requireTokenForHint;
        }

        public String getUserCodePcvId() {
            return this.userCodePcvId;
        }

        public void setUserCodePcvId(String userCodePcvId) {
            this.userCodePcvId = userCodePcvId;
        }

        public List<String> getRequestHintAttributeContract() {
            return this.requestHintAttributeContract;
        }

        public void setRequestHintAttributeContract(List<String> requestHintAttributeContract) {
            this.requestHintAttributeContract = requestHintAttributeContract;
        }

        public AttributeMapping getEnhanceRequestHintContractMapping() {
            return this.enhanceRequestHintContractMapping;
        }

        public void setEnhanceRequestHintContractMapping(AttributeMapping enhanceRequestHintContractMapping) {
            this.enhanceRequestHintContractMapping = enhanceRequestHintContractMapping;
        }

        public AttributeMapping getHintContractToOOBAuthPluginMapping() {
            return this.hintContractToOOBAuthPluginMapping;
        }

        public void setHintContractToOOBAuthPluginMapping(AttributeMapping hintContractToOOBAuthPluginMapping) {
            this.hintContractToOOBAuthPluginMapping = hintContractToOOBAuthPluginMapping;
        }

        public List<AlternativeLoginHintTokenIssuer> getAlternativeLoginHintTokenIssuers() {
            return this.alternativeLoginHintTokenIssuers;
        }

        public void setAlternativeLoginHintTokenIssuers(List<AlternativeLoginHintTokenIssuer> alternativeLoginHintTokenIssuers) {
            this.alternativeLoginHintTokenIssuers = alternativeLoginHintTokenIssuers;
        }

        public Calendar getLastModified() {
            return DateUtil.copyCalendar(this.lastModified);
        }

        public void setLastModified(Calendar lastModified) {
            this.lastModified = DateUtil.copyCalendar(lastModified);
        }

        public static class AlternativeLoginHintTokenIssuer {
            private String issuer;
            private String jwksData;
            private boolean isJwksDataReference;
            private List<JsonWebKey> jsonWebKeys;

            public AlternativeLoginHintTokenIssuer(String issuer, String jwksData, boolean isJwksDataReference) {
                this.issuer = issuer;
                this.jwksData = jwksData;
                this.isJwksDataReference = isJwksDataReference;
            }

            public String getIssuer() {
                return this.issuer;
            }

            public String getJwksData() {
                return this.jwksData;
            }

            public boolean isJwksDataReference() {
                return this.isJwksDataReference;
            }

            public List<JsonWebKey> getJsonWebKeys() {
                if (!this.isJwksDataReference) {
                    try {
                        if (this.jsonWebKeys == null) {
                            JsonWebKeySet jsonWebKeySet = new JsonWebKeySet(this.jwksData);
                            this.jsonWebKeys = jsonWebKeySet.getJsonWebKeys();
                        }
                        return this.jsonWebKeys;
                    }
                    catch (JoseException e) {
                        throw new RuntimeException("Unable to parse JWKS data for " + this.issuer, e);
                    }
                }
                return null;
            }
        }
    }
}

