/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.openid.ciba.handlers;

import com.pingidentity.sdk.accessgrant.AccessGrantAttributesHolder;
import com.pingidentity.sdk.authorizationdetails.AuthorizationDetails;
import com.pingidentity.sdk.oauth20.Scope;
import com.pingidentity.sdk.oobauth.OOBAuthGeneralException;
import com.pingidentity.sdk.oobauth.OOBAuthPlugin;
import com.pingidentity.sdk.oobauth.OOBAuthResultContext;
import java.util.Collections;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.oauth20.consent.OAuthConsentManager;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientManager;
import org.sourceid.oauth20.handlers.AccessTokenRequestException;
import org.sourceid.oauth20.handlers.PollingIntervalRegulator;
import org.sourceid.oauth20.handlers.ServerErrorException;
import org.sourceid.oauth20.handlers.TokenManagerSelector;
import org.sourceid.oauth20.handlers.process.ClientAwareGrantProcessor;
import org.sourceid.oauth20.handlers.process.GrantContext;
import org.sourceid.oauth20.handlers.process.GrantProcessor;
import org.sourceid.oauth20.protocol.GrantParamHelper;
import org.sourceid.openid.ciba.handlers.CibaHelper;
import org.sourceid.openid.ciba.handlers.CibaState;
import org.sourceid.openid.ciba.handlers.CibaStateSupport;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.wrapper.InMessageContext;

public class CibaGrantProcessor
extends ClientAwareGrantProcessor
implements GrantProcessor {
    private final CibaStateSupport cibaStateSupport;
    private final CibaHelper cibaHelper = new CibaHelper();
    private final AuthzServerManager authzServerMgr;
    private final OAuthConsentManager oAuthConsentManager;
    private final Log log = LogFactory.getLog(this.getClass());

    public CibaGrantProcessor(ClientManager clientMgr, AuthzServerManager authzServerMgr, OAuthConsentManager oAuthConsentManager) {
        super(clientMgr);
        this.cibaStateSupport = CibaStateSupport.getInstance();
        this.authzServerMgr = authzServerMgr;
        this.oAuthConsentManager = oAuthConsentManager;
    }

    @Override
    public GrantContext processGrant(InMessageContext ctx, HttpServletRequest req, HttpServletResponse resp, Client client, String grantType) throws AccessTokenRequestException {
        OOBAuthResultContext resultContext;
        if (client.getClientId() == null) {
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_request, "client identification is required");
        }
        String authReqId = GrantParamHelper.getParam(req, "auth_req_id", true, grantType);
        CibaState state = this.cibaStateSupport.retrieve(authReqId, client);
        client = this.evalGrantClientToIdentifiedClient(client, state.getClientId(), "Client id does not match the id of the client to whom the auth_req_id was issued.");
        if (state.isGranted()) {
            AttributeMap attributes = state.getAttributes();
            if (this.cibaHelper.isAttributeMissing(attributes, "USER_KEY")) {
                throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_grant, "Missing USER_KEY attribute.");
            }
            String userKeyValue = ((AttributeValue)attributes.get((Object)"USER_KEY")).getValue();
            TokenManagerSelector selector = new TokenManagerSelector();
            String requestedAtmId = ctx.getParam("access_token_manager_id");
            String requestedAudience = ctx.getParam("aud");
            Scope requestedScope = Scope.getScope((String)state.getScope());
            Set requestedResources = ctx.getParam("resource", Set.class);
            AuthorizationDetails requestedAuthorizationDetails = state.getAuthorizationDetails();
            String tokenManagerId = selector.selectTokenManagerId(null, requestedAtmId, requestedAudience, requestedResources, requestedScope, client);
            AccessGrantAttributesHolder grantAttributesHolder = new AccessGrantAttributesHolder(attributes, null);
            GrantContext context = new GrantContext(userKeyValue, grantAttributesHolder, requestedScope, true, "ciba", tokenManagerId, requestedAuthorizationDetails);
            context.setResourcesForMapping(requestedResources);
            context.setResourcesForAccessGrant(requestedResources);
            context.setAllowIdToken(true);
            this.cibaStateSupport.remove(authReqId);
            return context;
        }
        OOBAuthPlugin plugin = this.cibaHelper.getPlugin(client);
        String pluginTransactionId = state.getPluginTransactionId();
        try {
            resultContext = plugin.check(pluginTransactionId, Collections.singletonMap("ciba.auth_req_id", authReqId));
        }
        catch (OOBAuthGeneralException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("exception caught from OOBAuthPlugin transaction check on " + pluginTransactionId), (Throwable)e);
            }
            resultContext = new OOBAuthResultContext();
            resultContext.setStatus(OOBAuthResultContext.Status.FAILURE);
            resultContext.setStatusMessage(e.getMessage());
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("OOBAuthPlugin transaction check on " + pluginTransactionId + " returned " + resultContext));
        }
        boolean reuseConsent = this.authzServerMgr.isBypassAuthorizationForApprovedConsents();
        OOBAuthResultContext.Status status = resultContext.getStatus();
        String statusMessage = resultContext.getStatusMessage();
        if (status == OOBAuthResultContext.Status.IN_PROGRESS || status == null) {
            int pollingInterval = this.cibaHelper.getPollingInterval(client);
            PollingIntervalRegulator.Situation pollingSituation = this.cibaStateSupport.checkPollingInterval(authReqId, pollingInterval);
            Object msg = statusMessage != null ? statusMessage : "Pending user authorization";
            AccessTokenRequestException.Error errorCode = AccessTokenRequestException.Error.authorization_pending;
            boolean doAuditLog = false;
            if (pollingSituation == PollingIntervalRegulator.Situation.WARN) {
                msg = (String)msg + " (WARNING: please respect the " + pollingInterval + " second polling interval)";
                errorCode = AccessTokenRequestException.Error.slow_down;
            } else if (pollingSituation == PollingIntervalRegulator.Situation.FAIL) {
                this.cibaStateSupport.done(authReqId, plugin, pluginTransactionId);
                doAuditLog = true;
                errorCode = AccessTokenRequestException.Error.invalid_request;
                msg = "The " + pollingInterval + " second polling interval, which indicates the minimum amount of time in seconds that the Client MUST wait between polling requests to the token endpoint, has not been sufficiently observed.";
            }
            throw new AccessTokenRequestException(errorCode, (String)msg, doAuditLog);
        }
        if (status == OOBAuthResultContext.Status.SUCCESS) {
            AttributeMap attributes = state.getAttributes();
            if (this.cibaHelper.isAttributeMissing(attributes, "USER_KEY")) {
                throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_grant, "Missing USER_KEY attribute.");
            }
            String userKeyValue = ((AttributeValue)attributes.get((Object)"USER_KEY")).getValue();
            TokenManagerSelector selector = new TokenManagerSelector();
            String requestedAtmId = ctx.getParam("access_token_manager_id");
            String requestedAudience = ctx.getParam("aud");
            Set requestedResources = ctx.getParam("resource", Set.class);
            Scope requestedScope = Scope.getScope((String)state.getScope());
            AuthorizationDetails requestedAuthorizationDetails = state.getAuthorizationDetails();
            Scope scope = resultContext.getApprovedScope() != null ? new Scope(resultContext.getApprovedScope()) : requestedScope;
            AuthorizationDetails authorizationDetails = resultContext.getApprovedAuthorizationDetails() != null ? resultContext.getApprovedAuthorizationDetails() : requestedAuthorizationDetails;
            String tokenManagerId = selector.selectTokenManagerId(null, requestedAtmId, requestedAudience, requestedResources, scope, client);
            AccessGrantAttributesHolder grantAttributesHolder = new AccessGrantAttributesHolder(attributes, null);
            GrantContext context = new GrantContext(userKeyValue, grantAttributesHolder, scope, true, "ciba", tokenManagerId, authorizationDetails);
            context.setResourcesForMapping(requestedResources);
            context.setResourcesForAccessGrant(requestedResources);
            context.setAllowIdToken(true);
            if (reuseConsent) {
                this.oAuthConsentManager.createOrUpdate(userKeyValue, client.getClientId(), Scope.getScope((String)state.getScope()), scope, requestedAuthorizationDetails, authorizationDetails);
            }
            this.cibaStateSupport.done(authReqId, plugin, pluginTransactionId);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("calling OOBAuthPlugin finished with " + pluginTransactionId));
            }
            return context;
        }
        if (status == OOBAuthResultContext.Status.FAILURE) {
            if (reuseConsent) {
                AttributeMap attributes = state.getAttributes();
                if (this.cibaHelper.isAttributeMissing(attributes, "USER_KEY")) {
                    throw new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_grant, "Missing USER_KEY attribute.");
                }
                String userKeyValue = ((AttributeValue)attributes.get((Object)"USER_KEY")).getValue();
                Scope requestedScope = Scope.getScope((String)state.getScope());
                AuthorizationDetails requestedAuthorizationDetails = state.getAuthorizationDetails();
                this.oAuthConsentManager.deny(userKeyValue, client.getClientId(), requestedScope, requestedAuthorizationDetails);
            }
            this.cibaStateSupport.done(authReqId, plugin, pluginTransactionId);
            throw new AccessTokenRequestException(AccessTokenRequestException.Error.access_denied, statusMessage);
        }
        throw new ServerErrorException("Unexpected status from OOBAuthPlugin " + status);
    }
}

