/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.openid.ciba.handlers;

import com.pingidentity.sdk.oobauth.OOBAuthPlugin;
import java.time.Clock;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jose4j.jwt.JwtClaims;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.handlers.ServerErrorException;
import org.sourceid.openid.ciba.domain.CibaServerPolicy;
import org.sourceid.openid.ciba.domain.CibaServerPolicyManager;
import org.sourceid.openid.ciba.handlers.CibaState;
import org.sourceid.saml20.adapter.attribute.AttrValueSupport;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.domain.AttributeContract;
import org.sourceid.saml20.domain.OOBAuthPluginInstance;
import org.sourceid.saml20.domain.PersistentGrantAttribute;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.OOBAuthPluginManager;
import org.sourceid.util.log.AttributeMap;

public class CibaHelper {
    static final Map<String, Object> EMPTY_MAP = Collections.emptyMap();
    private final CibaServerPolicyManager cibaServerPolicyManager = MgmtFactory.getCibaServerPolicyManager();
    private final OOBAuthPluginManager oobAuthPluginManager = MgmtFactory.getOOBAuthPluginManager();
    private final AuthzServerManager authzServerManager = MgmtFactory.getAuthzServerManager();
    private ConfigStore config = ConfigStoreFarm.getConfig(this.getClass());

    CibaServerPolicy.RequestHandlingPolicy getRequestHandlingPolicy(Client client) throws ServerErrorException {
        CibaServerPolicy cibaServerPolicy = this.cibaServerPolicyManager.getCibaServerPolicy();
        String policyId = client.getCibaPolicyId();
        if (StringUtils.isBlank((String)policyId) && StringUtils.isBlank((String)(policyId = cibaServerPolicy.getDefaultRequestHandlingPolicyId()))) {
            throw new ServerErrorException("The default CIBA request policy is not configured");
        }
        CibaServerPolicy.RequestHandlingPolicy requestHandlingPolicy = cibaServerPolicy.getRequestHandlingPolicy(policyId);
        if (requestHandlingPolicy == null) {
            throw new ServerErrorException("CIBA request policy (id=" + policyId + ") does not exist");
        }
        return requestHandlingPolicy;
    }

    public boolean userCodeSupportedInDefaultPolicy() {
        String defaultId;
        CibaServerPolicy cibaServerPolicy = this.cibaServerPolicyManager.getCibaServerPolicy();
        CibaServerPolicy.RequestHandlingPolicy defaultPolicy = cibaServerPolicy.getRequestHandlingPolicy(defaultId = cibaServerPolicy.getDefaultRequestHandlingPolicyId());
        return defaultPolicy != null && StringUtils.isNotBlank((String)defaultPolicy.getUserCodePcvId());
    }

    OOBAuthPlugin getPlugin(Client client) throws ServerErrorException {
        return this.getPlugin(this.getRequestHandlingPolicy(client));
    }

    OOBAuthPlugin getPlugin(CibaServerPolicy.RequestHandlingPolicy requestHandlingPolicy) throws ServerErrorException {
        String pluginId = requestHandlingPolicy.getPluginId();
        OOBAuthPlugin oobAuthPlugin = this.oobAuthPluginManager.getOOBAuthPlugin(pluginId);
        if (oobAuthPlugin == null) {
            throw new ServerErrorException("Unknown OOBAuthPlugin: " + pluginId);
        }
        return oobAuthPlugin;
    }

    Set<String> getPluginContract(CibaServerPolicy.RequestHandlingPolicy requestHandlingPolicy) throws ServerErrorException {
        String pluginId = requestHandlingPolicy.getPluginId();
        OOBAuthPluginInstance instance = (OOBAuthPluginInstance)this.oobAuthPluginManager.getInstance(pluginId);
        if (instance == null) {
            throw new ServerErrorException("Unknown OOBAuthPlugin: " + pluginId);
        }
        AttributeContract pluginContract = instance.getAttributeContract();
        return pluginContract.getAllAttributeNames();
    }

    AttributeMap pareDown(AttributeMap in, Set<String> expectedNames) {
        AttributeMap result = new AttributeMap();
        for (String name : expectedNames) {
            result.put(name, (AttributeValue)in.get((Object)name));
        }
        return result;
    }

    boolean isAttributeMissing(AttributeMap attributes, String name) {
        AttributeValue attributeValue = (AttributeValue)attributes.get((Object)name);
        return attributeValue == null || !StringUtils.isNotBlank((String)attributeValue.getValue());
    }

    boolean isExpired(CibaState cibaState) {
        return this.nowInSecondsFromEpoch() > cibaState.getExpiresAt();
    }

    long nowInSecondsFromEpoch() {
        return Clock.systemUTC().instant().getEpochSecond();
    }

    int getPollingInterval(Client client) {
        Integer interval = client.getCibaPollingInterval();
        return interval != null ? interval.intValue() : this.config.getIntValue("default-polling-interval", 5);
    }

    public ConfigStore getConfig() {
        return this.config;
    }

    AttributeMap pareDownToExtendedGrantAttributes(AttributeMap in) {
        HashSet<String> targetNames = new HashSet<String>();
        targetNames.add("USER_KEY");
        for (PersistentGrantAttribute pga : this.authzServerManager.getPersistentGrantExtendedAttributes()) {
            targetNames.add(pga.getName());
        }
        return this.pareDown(in, targetNames);
    }

    public void processRequestHintTokenClaims(String namePrefix, AttributeMap userHintAttributes, JwtClaims claims) {
        Map flattenClaimsMap = claims.flattenClaims();
        for (Map.Entry entry : flattenClaimsMap.entrySet()) {
            List values = (List)entry.getValue();
            AttributeValue attributeValue = AttrValueSupport.make((Collection)values);
            userHintAttributes.put(namePrefix + "." + (String)entry.getKey(), attributeValue);
        }
    }
}

