/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.openid.ciba.handlers;

import com.pingidentity.crypto.MacAlgorithm;
import com.pingidentity.sdk.oobauth.OOBAuthGeneralException;
import com.pingidentity.sdk.oobauth.OOBAuthPlugin;
import com.pingidentity.sdk.oobauth.OOBAuthResultContext;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.jose4j.base64url.Base64Url;
import org.jose4j.jwe.kdf.KdfUtil;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.lang.ByteUtil;
import org.sourceid.common.IDGenerator;
import org.sourceid.config.ConfigStore;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientManager;
import org.sourceid.oauth20.handlers.AccessTokenRequestException;
import org.sourceid.oauth20.handlers.PollingIntervalRegulator;
import org.sourceid.openid.ciba.CibaDeliveryMode;
import org.sourceid.openid.ciba.handlers.CibaHelper;
import org.sourceid.openid.ciba.handlers.CibaState;
import org.sourceid.openid.connect.util.HttpConnectionPoolingManager;
import org.sourceid.saml20.adapter.state.KeyValueStateSupport;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class CibaStateSupport {
    private static final String MAC_ALG = MacAlgorithm.HMACSHA256.toString();
    private static final int RANDOM_PART_LENGTH = 22;
    private static final int EXP_PART_LENGTH = 5;
    private static final int LONG_LENGTH = 8;
    private static final int TAG_LENGTH = 16;
    private static final String PLUGIN_TX_ID_PREFIX = "pf.ciba|";
    private static final String PING_SENT_POSTFIX = "|p";
    private final int minInitialDelay;
    private final Log log = LogFactory.getLog(this.getClass());
    private final KeyValueStateSupport keyValueStateSupport;
    private final CibaHelper cibaHelper;
    private final ClientManager clientManager = MgmtFactory.getClientManager();
    private final PollingIntervalRegulator pollingIntervalRegulator;
    private final ScheduledExecutorService scheduledExecutorService;
    private static final CibaStateSupport css = new CibaStateSupport();

    public static CibaStateSupport getInstance() {
        return css;
    }

    private CibaStateSupport() {
        this.cibaHelper = new CibaHelper();
        ConfigStore config = this.cibaHelper.getConfig();
        int poolSize = config.getIntValue("ScheduledExecutorService.ThreadPool.size", 8);
        this.scheduledExecutorService = Executors.newScheduledThreadPool(poolSize);
        this.keyValueStateSupport = new KeyValueStateSupport();
        this.minInitialDelay = config.getIntValue("ping-client-internal-check-min-initial-delay", 5);
        int maxEntries = config.getIntValue("polling-interval-check-entries", 500);
        int warningCount = config.getIntValue("polling-interval-check-warning-count", 2);
        int allowanceMills = config.getIntValue("polling-interval-check-allowance-mills", 50);
        this.pollingIntervalRegulator = new PollingIntervalRegulator(maxEntries, warningCount, allowanceMills);
    }

    String[] makeAuthReqIds(long exp, String clientId) {
        byte[] randomPart = IDGenerator.generateBytes(22);
        byte[] expBytes = ByteUtil.getBytes((long)exp);
        expBytes = ByteUtil.subArray((byte[])expBytes, (int)3, (int)5);
        byte[] handle = ByteUtil.concat((byte[][])new byte[][]{randomPart, expBytes});
        byte[] tag = this.macTag(handle, clientId);
        byte[] authReqIdBytes = ByteUtil.concat((byte[][])new byte[][]{handle, tag});
        String encodedHandle = Base64Url.encode((byte[])handle);
        String authnReqId = Base64Url.encode((byte[])authReqIdBytes);
        return new String[]{encodedHandle, authnReqId};
    }

    void store(String[] authReqIds, CibaState state) {
        this.keyValueStateSupport.setValue(authReqIds[0], (Object)state);
        if (state.mightMakeStateChangeCallback()) {
            this.keyValueStateSupport.setValue(PLUGIN_TX_ID_PREFIX + state.getPluginTransactionId(), (Object)authReqIds[1]);
        }
    }

    void schedule(Client client, OOBAuthPlugin plugin, String authReqId, CibaState state, int expiresIn) {
        this.schedule(1, client, plugin, authReqId, state, expiresIn);
    }

    private void schedule(int invocationCount, Client client, OOBAuthPlugin plugin, String authReqId, CibaState state, int expiresIn) {
        boolean firstInvocation = invocationCount == 1;
        int pollingInterval = this.cibaHelper.getPollingInterval(client);
        CibaDeliveryMode deliveryMode = client.getCibaTokenDeliveryMode();
        if (deliveryMode == CibaDeliveryMode.ping) {
            int delay = firstInvocation && pollingInterval < this.minInitialDelay ? this.minInitialDelay : pollingInterval;
            this.scheduledExecutorService.schedule(() -> {
                OOBAuthResultContext resultContext;
                String pluginTransactionId = state.getPluginTransactionId();
                try {
                    resultContext = plugin.check(pluginTransactionId, CibaHelper.EMPTY_MAP);
                }
                catch (OOBAuthGeneralException e) {
                    this.log.debug((Object)("Exception caught in scheduled task from plugin.check " + pluginTransactionId), (Throwable)e);
                    resultContext = new OOBAuthResultContext();
                    resultContext.setStatus(OOBAuthResultContext.Status.FAILURE);
                }
                OOBAuthResultContext.Status status = resultContext.getStatus();
                if (this.cibaHelper.isExpired(state) || status != OOBAuthResultContext.Status.IN_PROGRESS) {
                    if (!state.mightMakeStateChangeCallback() || this.keyValueStateSupport.removeValue(authReqId + PING_SENT_POSTFIX) == null) {
                        String message = String.format("(transaction status is %s after %d internal checks)", status, invocationCount);
                        this.callNotificationEndpoint(client, authReqId, state, message);
                    }
                } else {
                    this.schedule(invocationCount + 1, client, plugin, authReqId, state, expiresIn);
                }
            }, (long)delay, TimeUnit.SECONDS);
        }
    }

    private void callFinished(OOBAuthPlugin plugin, String pluginTransactionId) {
        try {
            plugin.finished(pluginTransactionId);
        }
        catch (OOBAuthGeneralException e) {
            this.log.debug((Object)("Exception caught from plugin.finished " + pluginTransactionId), (Throwable)e);
        }
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification="introduced by java 11 language level change")
    private void callNotificationEndpoint(Client client, String authReqId, CibaState state, String extraContext) {
        boolean wentOkay;
        String notificationEndpoint = client.getCibaNotificationEndpoint();
        HttpPost post = new HttpPost(notificationEndpoint);
        String notificationToken = state.getClientNotificationToken();
        String authzHeaderValue = "Bearer " + notificationToken;
        post.setHeader("Authorization", authzHeaderValue);
        String body = "{\"auth_req_id\":\"" + authReqId + "\"}";
        post.setEntity((HttpEntity)new StringEntity(body, ContentType.APPLICATION_JSON));
        StringBuilder sb = new StringBuilder();
        sb.append("CIBA ping callback ");
        if (extraContext != null) {
            sb.append(extraContext);
        }
        sb.append(" request to ").append(notificationEndpoint);
        sb.append(" with ").append(authzHeaderValue).append(" and ").append(body);
        try (CloseableHttpResponse resp = HttpConnectionPoolingManager.getInstance().doRequestWithResponse((HttpRequestBase)post);){
            StatusLine statusLine = resp.getStatusLine();
            int statusCode = statusLine.getStatusCode();
            wentOkay = statusCode == 204 || statusCode == 200;
            sb.append(" returned ").append(statusLine);
        }
        catch (IOException ioe) {
            wentOkay = false;
            sb.append(" failed due to raised ").append(ioe);
        }
        if (wentOkay) {
            this.log.debug((Object)sb);
        } else {
            this.log.warn((Object)("Problem with " + sb));
        }
    }

    CibaState retrieve(String authReqId, Client client) throws AccessTokenRequestException {
        byte[] decoded = Base64Url.decode((String)authReqId);
        if (decoded.length == 43) {
            byte[] calculatedTag;
            byte[] handle = ByteUtil.subArray((byte[])decoded, (int)0, (int)27);
            byte[] tag = ByteUtil.subArray((byte[])decoded, (int)27, (int)16);
            if (ByteUtil.secureEquals((byte[])tag, (byte[])(calculatedTag = this.macTag(handle, client.getClientId())))) {
                CibaState removedState;
                byte[] expBytes = ByteUtil.subArray((byte[])handle, (int)(handle.length - 8), (int)8);
                for (int i = 0; i < 3; ++i) {
                    expBytes[i] = 0;
                }
                ByteBuffer byteBuffer = ByteBuffer.wrap(expBytes);
                long exp = byteBuffer.getLong();
                long now = this.cibaHelper.nowInSecondsFromEpoch();
                if (now < exp) {
                    String encodedHandle = Base64Url.encode((byte[])handle);
                    CibaState state = (CibaState)this.keyValueStateSupport.getValue(encodedHandle);
                    if (state == null) {
                        throw this.invalidGrant();
                    }
                    return state;
                }
                if (now < exp + (long)this.cibaHelper.getPollingInterval(client) && (removedState = this.remove(authReqId)) != null) {
                    OOBAuthPlugin plugin = this.cibaHelper.getPlugin(client);
                    this.callFinished(plugin, removedState.getPluginTransactionId());
                }
                throw new AccessTokenRequestException(AccessTokenRequestException.Error.expired_token, "auth_req_id has expired");
            }
        }
        throw this.invalidGrant();
    }

    void done(String authReqId, OOBAuthPlugin plugin, String pluginTransactionId) {
        this.remove(authReqId);
        this.callFinished(plugin, pluginTransactionId);
    }

    private AccessTokenRequestException invalidGrant() {
        return new AccessTokenRequestException(AccessTokenRequestException.Error.invalid_grant, "unknown, previously redeemed, expired or otherwise invalid auth_req_id");
    }

    public CibaState remove(String authReqId) {
        this.pollingIntervalRegulator.done(authReqId);
        return this.retrieveInternal(authReqId, true);
    }

    PollingIntervalRegulator.Situation checkPollingInterval(String authReqId, int pollingInterval) {
        return this.pollingIntervalRegulator.regulate(authReqId, pollingInterval);
    }

    private CibaState retrieveInternal(String authReqId, boolean remove) {
        byte[] decoded = Base64Url.decode((String)authReqId);
        if (decoded.length == 43) {
            CibaState state;
            byte[] handle = ByteUtil.subArray((byte[])decoded, (int)0, (int)27);
            String encodedHandle = Base64Url.encode((byte[])handle);
            if (remove) {
                state = (CibaState)this.keyValueStateSupport.removeValue(encodedHandle);
                String pluginTransactionId = state.getPluginTransactionId();
                if (state.mightMakeStateChangeCallback()) {
                    this.keyValueStateSupport.removeValue(PLUGIN_TX_ID_PREFIX + pluginTransactionId);
                }
            } else {
                state = (CibaState)this.keyValueStateSupport.getValue(encodedHandle);
            }
            return state;
        }
        return null;
    }

    private byte[] macTag(byte[] handle, String clientId) {
        Mac mac;
        Key masterKey = ((JsonWebKey)MgmtFactory.getMasterKeySet().getJsonWebKeySet().getJsonWebKeys().get(0)).getKey();
        KdfUtil kdf = new KdfUtil();
        byte[] derivedMacKey = kdf.kdf(masterKey.getEncoded(), 256, MAC_ALG, "ciba:auth_req_id:tag", clientId);
        try {
            mac = Mac.getInstance(MAC_ALG);
            mac.init(new SecretKeySpec(derivedMacKey, MAC_ALG));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        byte[] tag = mac.doFinal(handle);
        tag = ByteUtil.subArray((byte[])tag, (int)0, (int)16);
        return tag;
    }

    public void statusChange(String transactionIdentifier) {
        try {
            Client client;
            String authReqId;
            CibaState cibaState;
            Object value = this.keyValueStateSupport.getValue(PLUGIN_TX_ID_PREFIX + transactionIdentifier);
            if (value instanceof String && (cibaState = this.retrieveInternal(authReqId = (String)value, false)) != null && (client = this.clientManager.getCachedClient(cibaState.getClientId())).getCibaTokenDeliveryMode() == CibaDeliveryMode.ping) {
                this.keyValueStateSupport.setValue(authReqId + PING_SENT_POSTFIX, (Object)"y");
                this.callNotificationEndpoint(client, authReqId, cibaState, "(on status change callback from plugin)");
            }
        }
        catch (Exception e) {
            this.log.warn((Object)"Unexpected problem in OOB Auth status change callback.", (Throwable)e);
        }
    }
}

