/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.openid.connect;

import com.pingidentity.sdk.oauth20.Scope;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jose4j.jwt.NumericDate;
import org.jose4j.lang.JoseException;
import org.sourceid.common.IDGenerator;
import org.sourceid.common.json.SimpleJsonRespWriter;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.handlers.AuthenticationClaimHolder;
import org.sourceid.oauth20.handlers.HandlerUtil;
import org.sourceid.oauth20.service.OAuthJwtTokenService;
import org.sourceid.openid.connect.IdTokenClaims;
import org.sourceid.openid.connect.OpenIdParamNames;
import org.sourceid.openid.connect.domain.ConnectProviderRuntimePolicySupport;
import org.sourceid.openid.connect.domain.OpenIdConnectProviderPolicy;
import org.sourceid.openid.connect.domain.UserInfoAttrMapping;
import org.sourceid.openid.connect.service.PairwisePseudonymService;
import org.sourceid.openid.connect.service.impl.PairwisePseudonymServiceException;
import org.sourceid.saml20.adapter.attribute.AttrValueSupport;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.domain.AttrLookupException;
import org.sourceid.saml20.domain.AuthorizationException;
import org.sourceid.saml20.domain.SourceContextType;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.metadata.local.PathUtil;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.AuditLogger;
import org.sourceid.websso.profiles.ProcessRuntimeException;

public class IdTokenSupport {
    private final Log log = LogFactory.getLog(this.getClass());
    private final ConfigStore attributeConfig = ConfigStoreFarm.getConfig("attribute-result-collection-expected");
    private final List<String> globalAttributeContractCollections = this.attributeConfig.getListValue("attribute-contract-collections", new ArrayList<String>());
    private final OAuthJwtTokenService oAuthJwtTokenService;
    private final PairwisePseudonymService pairwisePseudonymService;
    private final ConnectProviderRuntimePolicySupport policySupport;

    public IdTokenSupport() {
        this(MgmtFactory.getOAuthJwtTokenService(), MgmtFactory.getPairwisePseudonymService(), new ConnectProviderRuntimePolicySupport());
    }

    public IdTokenSupport(OAuthJwtTokenService oAuthJwtTokenService, PairwisePseudonymService pairwisePseudonymService, ConnectProviderRuntimePolicySupport policySupport) {
        this.oAuthJwtTokenService = oAuthJwtTokenService;
        this.pairwisePseudonymService = pairwisePseudonymService;
        this.policySupport = policySupport;
    }

    public String makeToken(AttributeMap accessTokenAttrs, Client client, Scope scope, HttpServletRequest request, String issuer, AuthenticationClaimHolder authenticationClaimHolder, boolean includeAllUserInfoClaims, AttributeMap accessGrantAttrs, String sri, OpenIdConnectProviderPolicy.PolicyGroup policyGroup) throws AttrLookupException, AuthorizationException {
        try {
            IdTokenClaims idTokenClaims = this.baselineClaims(accessTokenAttrs, client, scope, request, issuer, authenticationClaimHolder, includeAllUserInfoClaims, accessGrantAttrs, sri, policyGroup);
            for (Map.Entry<String, Object> e : idTokenClaims.standardClaims.entrySet()) {
                idTokenClaims.claims.putIfAbsent(e.getKey(), e.getValue());
            }
            if (idTokenClaims.claims.get("jti") instanceof String) {
                AuditLogger.setIdTokenJti((String)idTokenClaims.claims.get("jti"));
            }
            return this.toToken(idTokenClaims.claims, client, request);
        }
        catch (JoseException e) {
            throw new ProcessRuntimeException("Problem creating ID Token", e);
        }
    }

    IdTokenClaims baselineClaims(AttributeMap accessTokenAttrs, Client client, Scope scope, HttpServletRequest request, String issuer, AuthenticationClaimHolder authenticationClaimHolder, boolean includeAllUserInfoClaims, AttributeMap accessGrantAttrs, String sri, OpenIdConnectProviderPolicy.PolicyGroup policyGroup) throws AttrLookupException, AuthorizationException {
        IdTokenClaims idTokenClaims = new IdTokenClaims();
        AttributeMap contextAttrs = new AttributeMap();
        contextAttrs.put(SourceContextType.CLIENT_IP.getId(), new AttributeValue(request.getRemoteAddr()));
        contextAttrs.put(SourceContextType.REQUEST.getId(), AttrValueSupport.make((Object)request));
        contextAttrs.put(SourceContextType.REQUEST_ENDPOINT.getId(), new AttributeValue(PathUtil.getRequestPath(request)));
        contextAttrs.put(SourceContextType.OAUTH_CLIENT.getId(), new AttributeValue(client.getClientId()));
        contextAttrs.put(SourceContextType.SRI.getId(), new AttributeValue(sri));
        HandlerUtil.addExtPropertiesToAttrMap(client.getExtendedParams(), contextAttrs);
        UserInfoAttrMapping userInfoAttrMapping = policyGroup.getUserInfoAttributeMapping();
        AttributeMap openIdStandardClaims = new AttributeMap();
        AttributeMap userAttrs = userInfoAttrMapping.exMapping((Map<String, AttributeValue>)accessTokenAttrs, (Map<String, AttributeValue>)contextAttrs, scope, policyGroup, (Map<String, AttributeValue>)openIdStandardClaims, (Map<String, AttributeValue>)accessGrantAttrs);
        ArrayList<String> attributeContractCollections = new ArrayList<String>();
        if (policyGroup.getMultiValuedAttributes() != null) {
            attributeContractCollections.addAll(policyGroup.getMultiValuedAttributes());
        }
        attributeContractCollections.addAll(this.globalAttributeContractCollections);
        SimpleJsonRespWriter.prepareAttributeMap(openIdStandardClaims, idTokenClaims.standardClaims, attributeContractCollections);
        String clientId = client.getClientId();
        String jwtId = IDGenerator.rndAlphaNumeric(22);
        NumericDate date = NumericDate.now();
        long now = date.getValue();
        int idTokenLifeInMinutes = policyGroup.getIdTokenLife();
        date.addSeconds(60L * (long)idTokenLifeInMinutes);
        long expiration = date.getValue();
        AttributeValue subjectAttributeValue = (AttributeValue)userAttrs.remove((Object)"sub");
        String subjectValue = subjectAttributeValue.getValue();
        if (client.isPairwiseUserType()) {
            this.log.debug((Object)("Converting the subject [" + subjectValue + "] to a PPID."));
            String sectorIdentifier = client.getSectorIdentifier();
            try {
                subjectValue = this.pairwisePseudonymService.toPPID(subjectValue, sectorIdentifier);
            }
            catch (PairwisePseudonymServiceException e) {
                throw new IllegalStateException("Problem with generating a pairwise pseudononymous identifier for the subject[" + subjectValue + "]: " + e.getMessage());
            }
        }
        idTokenClaims.claims.put("sub", subjectValue);
        idTokenClaims.claims.put("aud", this.selectOverrideValue("aud", (Object)clientId, idTokenClaims.standardClaims));
        idTokenClaims.claims.put("jti", this.selectOverrideValue("jti", (Object)jwtId, idTokenClaims.standardClaims));
        idTokenClaims.claims.put("iss", this.selectOverrideValue("iss", (Object)issuer, idTokenClaims.standardClaims));
        idTokenClaims.claims.put("iat", this.selectOverrideValue("iat", (Object)now, idTokenClaims.standardClaims));
        idTokenClaims.claims.put("exp", this.selectOverrideValue("exp", (Object)expiration, idTokenClaims.standardClaims));
        if (policyGroup.isIncludeSriInIdToken()) {
            idTokenClaims.claims.put("pi.sri", sri);
            idTokenClaims.claims.put("sid", sri);
        }
        if (client.getBackChannelLogoutUri() != null) {
            idTokenClaims.claims.put("sid", sri);
        }
        if (idTokenClaims.standardClaims.containsKey("amr")) {
            idTokenClaims.claims.put("amr", idTokenClaims.standardClaims.get("amr"));
        }
        if (idTokenClaims.standardClaims.containsKey("azp")) {
            idTokenClaims.claims.put("azp", idTokenClaims.standardClaims.get("azp"));
        }
        if (authenticationClaimHolder != null) {
            this.selectOverrideValue("auth_time", (Object)authenticationClaimHolder.getAuthnTime(), idTokenClaims);
            this.selectOverrideValue("nonce", (Object)authenticationClaimHolder.getNonce(), idTokenClaims);
            this.selectOverrideValue("at_hash", (Object)authenticationClaimHolder.getAtHash(), idTokenClaims);
            this.selectOverrideValue("c_hash", (Object)authenticationClaimHolder.getCHash(), idTokenClaims);
            this.selectOverrideValue("s_hash", (Object)authenticationClaimHolder.getSHash(), idTokenClaims);
            this.selectOverrideValue("acr", (Object)authenticationClaimHolder.getAcr(), idTokenClaims);
        }
        if (includeAllUserInfoClaims || policyGroup.isIncludeUserInfoInIdToken()) {
            Map<String, Object> userClaims = userInfoAttrMapping.prepForSerialization(userAttrs, attributeContractCollections);
            idTokenClaims.claims.putAll(userClaims);
        }
        if (!includeAllUserInfoClaims) {
            AttributeMap overrideClaims = new AttributeMap();
            if (!policyGroup.getAttributeInclusionMappings().isEmpty()) {
                for (Map.Entry<String, OpenIdConnectProviderPolicy.AttributeInclusionInfo> entry2 : policyGroup.getAttributeInclusionMappings().entrySet()) {
                    String claim = entry2.getKey();
                    if (!entry2.getValue().isIncludeInIdToken() || !userAttrs.containsKey((Object)claim)) continue;
                    overrideClaims.put(claim, (AttributeValue)userAttrs.get((Object)claim));
                }
            }
            overrideClaims.putAll(userAttrs.entrySet().stream().filter(entry -> OpenIdParamNames.OPENID_IDTOKEN_STANDARD_CLAIMS.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
            if (!overrideClaims.isEmpty()) {
                Map<String, Object> overrideSerializedClaims = userInfoAttrMapping.prepForSerialization(overrideClaims, attributeContractCollections);
                idTokenClaims.claims.putAll(overrideSerializedClaims);
            }
        }
        return idTokenClaims;
    }

    private void selectOverrideValue(String claimName, Object claimValue, IdTokenClaims idTokenClaims) {
        if (claimValue != null || idTokenClaims.standardClaims.get(claimName) != null) {
            idTokenClaims.claims.put(claimName, this.selectOverrideValue(claimName, claimValue, idTokenClaims.standardClaims));
        }
    }

    Object selectOverrideValue(String key, Object value, Map<String, Object> openIdStandardClaims) {
        return openIdStandardClaims.get(key) != null ? openIdStandardClaims.get(key) : value;
    }

    String toToken(Map<String, Object> claims, Client client, HttpServletRequest request) throws JoseException {
        return this.oAuthJwtTokenService.issueIdToken(request, client, claims);
    }
}

