/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.openid.connect;

import com.pingidentity.common.util.Base64URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.jose4j.lang.StringUtil;
import org.sourceid.websso.profiles.ProcessRuntimeException;

public class LeftHalfHash {
    public static String leftHalfHashToBase64UrlString(String value, String jwsAlgorithm) {
        byte[] hash = LeftHalfHash.leftHalfHashToBytes(value, jwsAlgorithm);
        return Base64URL.encodeToString((byte[])hash);
    }

    public static byte[] leftHalfHashToBytes(String value, String jwsAlgorithm) {
        MessageDigest messageDigest = LeftHalfHash.choseHashAlgorithm(jwsAlgorithm);
        byte[] hash = messageDigest.digest(StringUtil.getBytesAscii((String)value));
        byte[] leftHalf = new byte[hash.length / 2];
        System.arraycopy(hash, 0, leftHalf, 0, leftHalf.length);
        return leftHalf;
    }

    static MessageDigest choseHashAlgorithm(String jwsAlg) {
        String digestAlg = "SHA-" + jwsAlg.substring(2);
        try {
            return MessageDigest.getInstance(digestAlg);
        }
        catch (NoSuchAlgorithmException e) {
            String msg = "No MessageDigest found/known for " + digestAlg + " derived from JWS algorithm: " + jwsAlg;
            throw new ProcessRuntimeException(msg, e);
        }
    }
}

