/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.openid.connect;

import com.pingidentity.crypto.jwk.JwkFacilitator;
import java.security.Key;
import java.util.Arrays;
import java.util.List;
import org.jose4j.jwe.JsonWebEncryption;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.keys.KeyPersuasion;
import org.jose4j.keys.resolvers.DecryptionKeyResolver;
import org.jose4j.keys.resolvers.JwksDecryptionKeyResolver;
import org.jose4j.lang.InvalidAlgorithmException;
import org.jose4j.lang.UnresolvableKeyException;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.openid.connect.util.EncryptionUtil;

public class MultiDecryptionKeyResolver
implements DecryptionKeyResolver {
    private byte[] secretAsUtf8Bytes;

    public MultiDecryptionKeyResolver(byte[] secretAsUtf8Bytes) {
        if (secretAsUtf8Bytes != null) {
            this.secretAsUtf8Bytes = Arrays.copyOf(secretAsUtf8Bytes, secretAsUtf8Bytes.length);
        }
    }

    public Key resolveKey(JsonWebEncryption jwe, List<JsonWebStructure> nestCtx) throws UnresolvableKeyException {
        KeyPersuasion keyPersuasion;
        try {
            keyPersuasion = jwe.getAlgorithm().getKeyPersuasion();
        }
        catch (InvalidAlgorithmException e) {
            throw new UnresolvableKeyException("Problem getting JWE key persuasion", (Throwable)e);
        }
        switch (keyPersuasion) {
            case ASYMMETRIC: {
                JwkFacilitator jwkFacilitator = GlobalRegistry.getService(JwkFacilitator.class);
                List<JsonWebKey> jsonWebKeys = jwkFacilitator.getEncryptionKeys();
                JwksDecryptionKeyResolver jwksDecryptionKeyResolver = new JwksDecryptionKeyResolver(jsonWebKeys);
                jwksDecryptionKeyResolver.setDisambiguateWithAttemptDecrypt(true);
                return jwksDecryptionKeyResolver.resolveKey(jwe, nestCtx);
            }
            case SYMMETRIC: {
                if (this.secretAsUtf8Bytes == null) {
                    throw new UnresolvableKeyException("Unable to do symmetric decryption because the client secret is not available in the clear (not configured or not stored in a reversible format).");
                }
                return EncryptionUtil.getSymmetricEncryptionKey(jwe.getAlgorithmHeaderValue(), jwe.getEncryptionMethodHeaderParameter(), this.secretAsUtf8Bytes);
            }
        }
        return null;
    }
}

