/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.openid.connect;

import java.security.Key;
import java.util.List;
import org.jose4j.jwk.HttpsJwks;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.keys.HmacKey;
import org.jose4j.keys.KeyPersuasion;
import org.jose4j.keys.resolvers.HttpsJwksVerificationKeyResolver;
import org.jose4j.keys.resolvers.VerificationKeyResolver;
import org.jose4j.lang.InvalidAlgorithmException;
import org.jose4j.lang.UnresolvableKeyException;

public class MultiSigningKeyResolver
implements VerificationKeyResolver {
    private final VerificationKeyResolver asymmetricResolver;
    private final VerificationKeyResolver symmetricResolver;

    public MultiSigningKeyResolver(byte[] secretAsUtf8Bytes, HttpsJwks httpsJwks) {
        this.symmetricResolver = (jws, list) -> {
            if (secretAsUtf8Bytes != null) {
                return new HmacKey(secretAsUtf8Bytes);
            }
            return null;
        };
        this.asymmetricResolver = new HttpsJwksVerificationKeyResolver(httpsJwks);
    }

    public MultiSigningKeyResolver(VerificationKeyResolver symmetricResolver, VerificationKeyResolver asymmetricResolver) {
        this.symmetricResolver = symmetricResolver;
        this.asymmetricResolver = asymmetricResolver;
    }

    public Key resolveKey(JsonWebSignature jws, List<JsonWebStructure> list) throws UnresolvableKeyException {
        KeyPersuasion keyPersuasion;
        try {
            keyPersuasion = jws.getAlgorithm().getKeyPersuasion();
        }
        catch (InvalidAlgorithmException e) {
            throw new UnresolvableKeyException("Problem getting JWS key persuasion", (Throwable)e);
        }
        switch (keyPersuasion) {
            case ASYMMETRIC: {
                return this.asymmetricResolver.resolveKey(jws, list);
            }
            case SYMMETRIC: {
                return this.symmetricResolver.resolveKey(jws, list);
            }
        }
        return null;
    }
}

