/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.openid.connect;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public final class OfflineAccessSupport {
    private static final Log log = LogFactory.getLog(OfflineAccessSupport.class);
    private static final String INVALID_CLIENT_ATTRIBUTE_VALUE = "OAuth Client's %s attribute value is invalid: %s";
    private final AuthzServerManager authzServerManager;

    public OfflineAccessSupport() {
        this(MgmtFactory.getAuthzServerManager());
    }

    OfflineAccessSupport(AuthzServerManager authzServerManager) {
        this.authzServerManager = authzServerManager;
    }

    public boolean isRequireOfflineAccessScopeToIssueRefreshToken(Client client) {
        switch (client.getRequireOfflineAccessScopeToIssueRefreshTokens()) {
            case "Yes": {
                return true;
            }
            case "No": {
                return false;
            }
            case "SERVER_DEFAULT": {
                return this.authzServerManager.isRequireOfflineAccessScopeToIssueRefreshTokens();
            }
        }
        log.error((Object)String.format(INVALID_CLIENT_ATTRIBUTE_VALUE, "requireOfflineAccessScopeToIssueRefreshTokens", client.getRequireOfflineAccessScopeToIssueRefreshTokens()));
        return false;
    }

    public boolean isOfflineAccessRequireConsentPromptEnabled(Client client) {
        if (!this.isRequireOfflineAccessScopeToIssueRefreshToken(client)) {
            return false;
        }
        switch (client.getOfflineAccessRequireConsentPrompt()) {
            case "Yes": {
                return true;
            }
            case "No": {
                return false;
            }
            case "SERVER_DEFAULT": {
                return this.authzServerManager.isOfflineAccessRequireConsentPrompt();
            }
        }
        log.error((Object)String.format(INVALID_CLIENT_ATTRIBUTE_VALUE, "offlineAccessRequireConsentPrompt", client.getOfflineAccessRequireConsentPrompt()));
        return false;
    }
}

