/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.openid.connect;

import java.security.Key;
import java.util.Arrays;
import java.util.List;
import org.jose4j.jwe.JsonWebEncryption;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.keys.resolvers.DecryptionKeyResolver;
import org.jose4j.lang.UnresolvableKeyException;
import org.sourceid.openid.connect.util.EncryptionUtil;

public class SymmetricDecryptionKeyResolver
implements DecryptionKeyResolver {
    private byte[] secretAsUtf8Bytes;

    public SymmetricDecryptionKeyResolver(byte[] secretAsUtf8Bytes) {
        if (secretAsUtf8Bytes != null) {
            this.secretAsUtf8Bytes = Arrays.copyOf(secretAsUtf8Bytes, secretAsUtf8Bytes.length);
        }
    }

    public Key resolveKey(JsonWebEncryption jwe, List<JsonWebStructure> nestingContext) throws UnresolvableKeyException {
        if (this.secretAsUtf8Bytes == null) {
            throw new UnresolvableKeyException("Unable to do symmetric decryption because the client secret is not available in the clear (not configured or not stored in a reversible format).");
        }
        return EncryptionUtil.getSymmetricEncryptionKey(jwe.getAlgorithmHeaderValue(), jwe.getEncryptionMethodHeaderParameter(), this.secretAsUtf8Bytes);
    }
}

