/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.openid.connect.bindings;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sourceid.common.json.SimpleJsonRespWriter;
import org.sourceid.oauth20.bindings.OauthBindingGroup;
import org.sourceid.openid.connect.profiles.sp.LogoutException;
import org.sourceid.saml20.bindings.Binding;
import org.sourceid.saml20.bindings.BindingException;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.util.VirtualIdentityUtil;
import org.sourceid.websso.servlet.HttpStatusCodeException;
import org.sourceid.websso.servlet.RedirectException;
import org.sourceid.websso.servlet.RenderPageException;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public class BackChannelLogoutBinding
implements Binding {
    private static final String BC_LOGOUT_BINDING = "oidc:bc:logout";
    private final SimpleJsonRespWriter jsonRespWriter = new SimpleJsonRespWriter();

    @Override
    public InMessageContext receive(HttpServletRequest request, HttpServletResponse response, Role partnerRole) throws IOException, BindingException, RedirectException, RenderPageException, HttpStatusCodeException {
        OauthBindingGroup.checkLicense();
        if (!"POST".equals(request.getMethod())) {
            String message = "Please use POST when making requests to the Back-Channel Logout Endpoint.";
            throw new HttpStatusCodeException(message, 405);
        }
        InMessageContext inMsgCtx = new InMessageContext(Role.SP);
        inMsgCtx.setIsRequest(true);
        String partnerEntityId = VirtualIdentityUtil.extractParam(request, "iss");
        IdpConnection idpConn = MgmtFactory.getMetadataDirectory().getIdpConnection(partnerEntityId, false);
        if (idpConn == null) {
            inMsgCtx.setDeferredException(new LogoutException(LogoutException.Error.invalid_request, "Entity ID extracted from request does not match an IdP connection"));
        } else if (idpConn.getOidcSettings() == null) {
            inMsgCtx.setDeferredException(new LogoutException(LogoutException.Error.invalid_request, "IdP connection '" + partnerEntityId + "' does not have OIDC enabled"));
        } else {
            inMsgCtx.setEntityId(partnerEntityId);
            String logoutToken = request.getParameter("logout_token");
            if (logoutToken == null) {
                inMsgCtx.setDeferredException(new LogoutException(LogoutException.Error.invalid_request, "Request is missing parameter logout_token"));
            } else {
                inMsgCtx.setParam("logout_token", logoutToken);
                inMsgCtx.setMaskedParamName("logout_token");
            }
        }
        return inMsgCtx;
    }

    @Override
    public void transportResponse(HttpServletRequest req, HttpServletResponse resp, OutMessageContext outMsgCtx) throws IOException {
        if (outMsgCtx.getParams().containsKey("error")) {
            resp.setStatus(400);
            this.jsonRespWriter.writeJson(resp, outMsgCtx.getParams());
        } else {
            resp.setStatus(200);
        }
    }

    @Override
    public String getUri() {
        return BC_LOGOUT_BINDING;
    }

    @Override
    public void handleException(HttpServletRequest req, HttpServletResponse resp, Exception e) throws ServletException, IOException, RenderPageException {
        throw new ServletException((Throwable)e);
    }

    @Override
    public InMessageContext transportRequest(HttpServletRequest req, HttpServletResponse resp, OutMessageContext msgCtx) throws IOException, BindingException, RedirectException, RenderPageException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isBackChannel() {
        return true;
    }

    @Override
    public boolean isEntityIdRequired() {
        return false;
    }
}

