/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.openid.connect.bindings;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.pingidentity.monitoring.metrics.Meters;
import com.pingidentity.monitoring.metrics.TimerScope;
import java.io.IOException;
import java.util.HashMap;
import java.util.function.Function;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.sourceid.oauth20.client.ClientAuthSupport;
import org.sourceid.openid.connect.bindings.OIDCBaseBinding;
import org.sourceid.openid.connect.domain.OIDCConnectionForBinding;
import org.sourceid.openid.connect.util.HttpConnectionPoolingManager;
import org.sourceid.openid.connect.util.OIDCUtil;
import org.sourceid.saml20.bindings.BindingException;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.OIDCSettings;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.state.State;
import org.sourceid.util.ObjectMapperFactory;
import org.sourceid.websso.servlet.HttpStatusCodeException;
import org.sourceid.websso.servlet.OIDCInfo;
import org.sourceid.websso.servlet.RedirectException;
import org.sourceid.websso.servlet.RenderPageException;
import org.sourceid.websso.wrapper.InMessageContext;

public class OIDCCodeBinding
extends OIDCBaseBinding {
    private static final ObjectMapper jsonObjectMapper = ObjectMapperFactory.buildObjectMapper();
    private static final String OIDC_CODE_BINDING = "oidc:code";
    private static final Log log = LogFactory.getLog(OIDCCodeBinding.class);
    private Function<HttpServletRequest, String> codeExtractor = request -> request.getParameter("code");
    private OIDCConnectionForBinding oidcConnectionForBinding;

    OIDCCodeBinding() {
    }

    public OIDCCodeBinding(OIDCConnectionForBinding oidcConnectionForBinding) {
        this.oidcConnectionForBinding = oidcConnectionForBinding;
    }

    public void setCodeExtractor(Function<HttpServletRequest, String> codeExtractor) {
        this.codeExtractor = codeExtractor;
    }

    @Override
    public InMessageContext receive(HttpServletRequest request, HttpServletResponse response, Role partnerRole) throws IOException, BindingException, RedirectException, RenderPageException, HttpStatusCodeException {
        if (this.oidcConnectionForBinding == null) {
            return super.receive(request, response, partnerRole);
        }
        String issuer = this.oidcConnectionForBinding.getOidcProviderConnection().getIssuer();
        String state = request.getParameter("state");
        OIDCSettings oidcSettings = this.oidcConnectionForBinding.getOIDCSettings();
        InMessageContext msgCtxIn = this.getInMessageContext(partnerRole, issuer, state);
        this.populateMessageContext(request, this.oidcConnectionForBinding.getRedirectUri(), this.oidcConnectionForBinding.getRedirectUri(), msgCtxIn, state, oidcSettings, issuer);
        return msgCtxIn;
    }

    private InMessageContext getInMessageContext(Role partnerRole, String issuer, String state) throws RenderPageException, BindingException {
        InMessageContext msgCtxIn = this.getBaseMessageContext(partnerRole);
        msgCtxIn.setRelayState(state);
        State requestState = this.oidcConnectionForBinding.getRequestState();
        if (requestState != null) {
            msgCtxIn.setOriginalRequestCtx(requestState.getOutMsgCtx());
        }
        this.verifyIssuerAndState(issuer, state, msgCtxIn);
        return msgCtxIn;
    }

    @Override
    public InMessageContext doReceive(HttpServletRequest request, String issuer, IdpConnection idpConn, InMessageContext msgCtxIn, String state) throws IOException, BindingException {
        OIDCSettings settings = idpConn.getOidcSettings();
        String ssoRedirectUri = OIDCUtil.getRuntimeRedirectUri(idpConn.getEntityId());
        String entityId = idpConn.getEntityId();
        this.populateMessageContext(request, issuer, ssoRedirectUri, msgCtxIn, state, settings, entityId);
        return msgCtxIn;
    }

    private void populateMessageContext(HttpServletRequest request, String issuer, String ssoRedirectUri, InMessageContext msgCtxIn, String state, OIDCSettings settings, String entityId) throws BindingException, IOException {
        String responseStream;
        String code = this.codeExtractor.apply(request);
        String clientId = settings.getClientId();
        log.debug((Object)("Received auth_code for client_id: " + clientId + " issuer : " + issuer + " profile: " + settings.getProfile().getName()));
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("grant_type", "authorization_code");
        params.put("code", code);
        params.put("redirect_uri", ssoRedirectUri);
        if (settings.isEnableProofKeyForCodeExchange()) {
            String originalCodeVerifier = msgCtxIn.getOriginalRequest().getSupplementalContext("code_verifier", String.class);
            params.put("code_verifier", originalCodeVerifier);
        }
        HttpPost post = new HttpPost(settings.getTokenEndpoint().getFullLocation());
        ClientAuthSupport.populateClientAuthParam(settings, clientId, params, post);
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(this.getParameters(params), Consts.UTF_8);
        post.setEntity((HttpEntity)entity);
        try (TimerScope ignored = Meters.getTimerScope("connection.token", "connection.id", issuer);){
            responseStream = HttpConnectionPoolingManager.getInstance().doRequest((HttpRequestBase)post);
        }
        catch (IOException e) {
            Meters.getCounter("connection.token.errors", "connection.id", issuer).increment();
            String message = "Error connecting to token endpoint: " + settings.getTokenEndpoint().getFullLocation() + (String)(e.getMessage() != null ? ". " + e.getMessage() : "");
            log.error((Object)message);
            throw e;
        }
        if (responseStream != null) {
            OIDCInfo oidcInfo = (OIDCInfo)jsonObjectMapper.readValue(responseStream, OIDCInfo.class);
            if (!StringUtils.isEmpty((String)oidcInfo.getIdToken())) {
                log.debug((Object)("Received ID token for issuer: " + entityId + " client_id: " + settings.getClientId()));
                msgCtxIn.setEntityId(issuer);
                msgCtxIn.setRelayState(state);
                msgCtxIn.setParam("id_token", oidcInfo.getIdToken());
                msgCtxIn.setParam("access_token", oidcInfo.getAccessToken(), true);
                msgCtxIn.setParam("expires_in", oidcInfo.getExpiresIn());
                msgCtxIn.setParam("token_type", oidcInfo.getTokenType());
            }
            if (StringUtils.isNotBlank((String)oidcInfo.getError())) {
                StringBuilder errorString = new StringBuilder(oidcInfo.getError());
                if (StringUtils.isNotEmpty((String)oidcInfo.getErrorDescription())) {
                    errorString.append(" : ").append(oidcInfo.getErrorDescription());
                }
                throw new BindingException(errorString.toString());
            }
        }
        msgCtxIn.setSignatureRequired(false);
    }

    @Override
    public String getUri() {
        return OIDC_CODE_BINDING;
    }
}

