/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.openid.connect.bindings;

import java.util.function.Function;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.openid.connect.bindings.OIDCBaseBinding;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.OIDCSettings;
import org.sourceid.websso.wrapper.InMessageContext;

public class OIDCImplicitBinding
extends OIDCBaseBinding {
    public static final String OIDC_IMPLICIT_BINDING = "oidc:implicit";
    private static final Log log = LogFactory.getLog(OIDCImplicitBinding.class);
    private Function<HttpServletRequest, String> idTokenExtractor = request -> request.getParameter("id_token");
    private Function<HttpServletRequest, String> accessTokenExtractor = request -> request.getParameter("access_token");

    public void setIdTokenExtractor(Function<HttpServletRequest, String> idTokenExtractor) {
        this.idTokenExtractor = idTokenExtractor;
    }

    public void setAccessTokenExtractor(Function<HttpServletRequest, String> accessTokenExtractor) {
        this.accessTokenExtractor = accessTokenExtractor;
    }

    @Override
    public InMessageContext doReceive(HttpServletRequest request, String issuer, IdpConnection idpConn, InMessageContext msgCtxIn, String state) {
        OIDCSettings settings = idpConn.getOidcSettings();
        String clientId = settings.getClientId();
        log.debug((Object)("Received id_token for client_id: " + clientId + " issuer : " + issuer + "with profile: " + settings.getProfile().getName()));
        String idToken = this.idTokenExtractor.apply(request);
        if (!StringUtils.isEmpty((String)idToken)) {
            log.debug((Object)("Received ID token for issuer: " + idpConn.getEntityId() + " client_id: " + settings.getClientId() + " with profile: " + settings.getProfile().getName()));
            msgCtxIn.setEntityId(issuer);
            msgCtxIn.setRelayState(state);
            msgCtxIn.setParam("id_token", idToken);
            String accessToken = this.accessTokenExtractor.apply(request);
            if (StringUtils.isNotEmpty((String)accessToken)) {
                msgCtxIn.setParam("access_token", accessToken, true);
            }
        }
        return msgCtxIn;
    }

    @Override
    public String getUri() {
        return OIDC_IMPLICIT_BINDING;
    }
}

