/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.openid.connect.bindings;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sourceid.oauth20.protocol.Parameters;
import org.sourceid.saml20.bindings.Binding;
import org.sourceid.saml20.bindings.BindingException;
import org.sourceid.saml20.bindings.RelayStateSupport;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.websso.bindings.FormPost;
import org.sourceid.websso.servlet.HttpStatusCodeException;
import org.sourceid.websso.servlet.RedirectException;
import org.sourceid.websso.servlet.RenderPageException;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public class RpInitiatedLogoutBinding
implements Binding {
    public static final String BINDING_NAME = "oidc:rp:initiated:logout";
    private static final String[] PARAM_NAMES = new String[]{"id_token_hint", "logout_hint", "post_logout_redirect_uri", "ui_locales", "state", Parameters.CLIENT_ID};
    private final RelayStateSupport relayStateSupport = new RelayStateSupport();

    @Override
    public InMessageContext transportRequest(HttpServletRequest req, HttpServletResponse resp, OutMessageContext msgCtx) throws IOException, BindingException, RedirectException, RenderPageException {
        this.relayStateSupport.associate(msgCtx, req, resp, true);
        msgCtx.setParam("state", msgCtx.getRelayState());
        FormPost.post(msgCtx.getEndpoint(), msgCtx.getParams(), req, resp);
        return null;
    }

    @Override
    public void transportResponse(HttpServletRequest request, HttpServletResponse response, OutMessageContext msgCtx) throws IOException, BindingException, RedirectException, RenderPageException {
        throw new UnsupportedOperationException();
    }

    @Override
    public InMessageContext receive(HttpServletRequest request, HttpServletResponse response, Role partnerRole) throws IOException, BindingException, RedirectException, RenderPageException, HttpStatusCodeException {
        InMessageContext inMsgCtx = new InMessageContext(partnerRole);
        inMsgCtx.setIsRequest(partnerRole == Role.SP);
        inMsgCtx.setBinding(this.getUri());
        for (String paramName : PARAM_NAMES) {
            this.setParam(request, paramName, inMsgCtx);
        }
        inMsgCtx.setMaskedParamName("id_token_hint");
        if (!inMsgCtx.isRequest()) {
            String state = inMsgCtx.getParam("state");
            if (state == null) {
                throw new BindingException("Missing 'state' parameter in post-logout response");
            }
            this.relayStateSupport.lookupAssociation(inMsgCtx, state, request, response);
            if (inMsgCtx.getOriginalRequest() == null) {
                throw new BindingException("The 'state' parameter is invalid or has expired");
            }
        }
        return inMsgCtx;
    }

    @Override
    public void handleException(HttpServletRequest req, HttpServletResponse resp, Exception e) throws ServletException, IOException, RenderPageException {
        throw new ServletException((Throwable)e);
    }

    @Override
    public boolean isBackChannel() {
        return false;
    }

    @Override
    public String getUri() {
        return BINDING_NAME;
    }

    @Override
    public boolean isEntityIdRequired() {
        return false;
    }

    private void setParam(HttpServletRequest request, String name, InMessageContext inMsgCtx) {
        String value = request.getParameter(name);
        if (value != null) {
            inMsgCtx.setParam(name, value);
        }
    }
}

