/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.openid.connect.bindings;

import com.pingidentity.sdk.oauth20.Scope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.oauth20.bindings.AccessTokenProtectedResourceBinding;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientManager;
import org.sourceid.openid.connect.domain.ConnectProviderRuntimePolicySupport;
import org.sourceid.openid.connect.domain.OpenIdConnectProviderPolicy;
import org.sourceid.saml20.domain.BearerAccessTokenMgmtPluginInstance;
import org.sourceid.saml20.domain.mgmt.BearerAccessTokenMgmtPluginManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class UserInfoEndpointBinding
extends AccessTokenProtectedResourceBinding {
    private static final Log log = LogFactory.getLog(UserInfoEndpointBinding.class);
    private ConnectProviderRuntimePolicySupport oidcPolicySupport;
    private ClientManager clientManager;

    public UserInfoEndpointBinding(ClientManager clientManager, BearerAccessTokenMgmtPluginManager tokenManager, ConnectProviderRuntimePolicySupport policySupport, String realm, Scope requiredScopes, Scope suggestedScopes) {
        super(tokenManager, realm, requiredScopes, suggestedScopes);
        this.clientManager = clientManager;
        this.oidcPolicySupport = policySupport;
    }

    public UserInfoEndpointBinding(String realm, Scope requiredScopes, Scope suggestedScopes) {
        this(MgmtFactory.getClientManager(), MgmtFactory.getBearerAccessTokenMgmtPluginMgr(), new ConnectProviderRuntimePolicySupport(), realm, requiredScopes, suggestedScopes);
    }

    @Override
    protected Collection<BearerAccessTokenMgmtPluginInstance> getAtmInstances() {
        HashSet<BearerAccessTokenMgmtPluginInstance> result = new HashSet<BearerAccessTokenMgmtPluginInstance>();
        for (OpenIdConnectProviderPolicy.PolicyGroup policyGroup : this.getPolicyGroups()) {
            BearerAccessTokenMgmtPluginInstance instance;
            if (policyGroup.getAccessTokenManagerId() == null || (instance = (BearerAccessTokenMgmtPluginInstance)this.tokenManager.getInstance(policyGroup.getAccessTokenManagerId())) == null) continue;
            result.add(instance);
        }
        return result;
    }

    @Override
    protected Collection<BearerAccessTokenMgmtPluginInstance> getAtmInstancesForClient(String clientId) {
        Client client;
        ArrayList<BearerAccessTokenMgmtPluginInstance> result = new ArrayList<BearerAccessTokenMgmtPluginInstance>();
        Client client2 = client = clientId != null ? this.clientManager.getCachedClient(clientId) : null;
        if (client != null && !client.isEnabled()) {
            client = null;
            log.debug((Object)("Client " + clientId + " is disabled"));
        }
        try {
            OpenIdConnectProviderPolicy.PolicyGroup group = this.oidcPolicySupport.getPolicyGroup(client);
            BearerAccessTokenMgmtPluginInstance instance = (BearerAccessTokenMgmtPluginInstance)this.tokenManager.getInstance(group.getAccessTokenManagerId());
            if (instance != null && instance.isClientAllowed(clientId)) {
                result.add(instance);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    protected Collection<OpenIdConnectProviderPolicy.PolicyGroup> getPolicyGroups() {
        return this.oidcPolicySupport.getConnectProviderPolicyManager().getPolicy().getPolicyGroups().values();
    }
}

