/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.openid.connect.domain;

import com.pingidentity.common.util.Obfuscator;
import org.sourceid.openid.connect.domain.OIDCProviderConnection;
import org.sourceid.saml20.bindings.BindingException;
import org.sourceid.saml20.domain.Endpoint;
import org.sourceid.saml20.domain.OIDCProfile;
import org.sourceid.saml20.domain.OIDCSettings;
import org.sourceid.saml20.state.State;

public class OIDCConnectionForBinding {
    private final OIDCProviderConnection oidcProviderConnection;
    private final String redirectUri;
    private final OIDCProfile oidcProfile;
    private final State requestState;
    private static final String DEFAULT_LIFETIME = "5";

    public OIDCConnectionForBinding(OIDCProviderConnection oidcProviderConnection, String redirectUri, OIDCProfile oidcProfile, State requestState) {
        this.oidcProviderConnection = oidcProviderConnection;
        this.oidcProfile = oidcProfile;
        this.redirectUri = redirectUri;
        this.requestState = requestState;
    }

    public OIDCProviderConnection getOidcProviderConnection() {
        return this.oidcProviderConnection;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public OIDCProfile getOidcProfile() {
        return this.oidcProfile;
    }

    public State getRequestState() {
        return this.requestState;
    }

    public OIDCSettings getOIDCSettings() throws BindingException {
        if (this.getOidcProviderConnection() == null) {
            throw new BindingException("Invalid configuration to process Auth code. Unable to load OIDC provider configuration.");
        }
        OIDCProviderConnection oidcProviderConnection = this.getOidcProviderConnection();
        boolean isBasicAuth = false;
        boolean isJwtAuth = false;
        boolean isClientSecretJwtAuth = false;
        String signingAlgorithm = "RS256";
        if (oidcProviderConnection.getClientAuthType() != null) {
            if ("client_secret_basic".equals(oidcProviderConnection.getClientAuthType())) {
                isBasicAuth = true;
            } else if ("private_key_jwt".equals(oidcProviderConnection.getClientAuthType())) {
                isJwtAuth = true;
            } else if ("client_secret_jwt".endsWith(oidcProviderConnection.getClientAuthType())) {
                isClientSecretJwtAuth = true;
                signingAlgorithm = "HS256";
            }
        }
        OIDCSettings oidcSettings = new OIDCSettings(oidcProviderConnection.getClientId(), this.getClientSecret(oidcProviderConnection), new Endpoint(null, oidcProviderConnection.getTokenEndpoint()), null, this.getOidcProfile(), "disabled", new Endpoint(null, oidcProviderConnection.getUserInfoEndpoint()), false, isBasicAuth, isJwtAuth, isClientSecretJwtAuth, oidcProviderConnection.getType(), DEFAULT_LIFETIME, oidcProviderConnection.getAudience(), true, signingAlgorithm, null, oidcProviderConnection.isEnableProofKeyForCodeExchange(), new Endpoint(null, oidcProviderConnection.getPushedAuthorizationRequestEndpoint()), new Endpoint(null, oidcProviderConnection.getEndSessionEndpoint()));
        return oidcSettings;
    }

    private String getClientSecret(OIDCProviderConnection oidcProviderConnection) {
        if (oidcProviderConnection.getClientSecret() == null) {
            return null;
        }
        return Obfuscator.obfuscate(oidcProviderConnection.getClientSecret().getStrValue());
    }
}

