/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.openid.connect.domain;

import com.pingidentity.sdk.oauth20.Scope;
import com.unboundid.util.StaticUtils;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.sourceid.common.json.SimpleJsonRespWriter;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.openid.connect.OpenIdParamNames;
import org.sourceid.openid.connect.domain.OpenIdConnectProviderPolicy;
import org.sourceid.openid.connect.domain.UserInfoClaims;
import org.sourceid.saml20.adapter.attribute.AttrValueSupport;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.domain.AttrLookupException;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.AuthorizationException;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.profiles.ProcessRuntimeException;

public class UserInfoAttrMapping
extends AttributeMapping {
    private static final String ATTRIBUTE_CONTRACT_COLLECTIONS_CONFIG_STORE_KEY = "attribute-contract-collections";
    private ConfigStore config = ConfigStoreFarm.getConfig("attribute-result-collection-expected");
    private List<String> globalAttributeContractCollections = this.config.getListValue("attribute-contract-collections", new ArrayList<String>());

    public AttributeMap exMapping(Map<String, AttributeValue> accessTokenAttrs, Map<String, AttributeValue> contextAttributes, Scope scope, OpenIdConnectProviderPolicy.PolicyGroup policyGroup, Map<String, AttributeValue> accessGrantAttrs) throws AttrLookupException, AuthorizationException {
        return this.exMapping(accessTokenAttrs, contextAttributes, scope, policyGroup, new HashMap<String, AttributeValue>(), accessGrantAttrs);
    }

    public AttributeMap exMapping(Map<String, AttributeValue> accessTokenAttrs, Map<String, AttributeValue> contextAttributes, Scope scope, OpenIdConnectProviderPolicy.PolicyGroup policyGroup, Map<String, AttributeValue> openIdStandardClaims, Map<String, AttributeValue> accessGrantAttributes) throws AttrLookupException, AuthorizationException {
        AttributeMap srcAttributes = new AttributeMap(accessTokenAttrs);
        if (accessGrantAttributes != null && !accessGrantAttributes.isEmpty()) {
            for (Map.Entry<String, AttributeValue> entry : accessGrantAttributes.entrySet()) {
                srcAttributes.put("persistentgrant." + entry.getKey(), entry.getValue());
            }
        }
        AttributeMap mappedAttributes = super.executeMapping(srcAttributes, null, new AttributeMap(contextAttributes));
        this.migrateOpenIdStandardClaims(mappedAttributes, openIdStandardClaims);
        AttributeValue subjectAttributeValue = (AttributeValue)mappedAttributes.get((Object)"sub");
        if (subjectAttributeValue == null || StringUtils.isBlank((String)subjectAttributeValue.getValue())) {
            throw new ProcessRuntimeException("No value found for required attribute/claim 'sub' in the mapped user info attributes: " + mappedAttributes);
        }
        AttributeMap filteredAttributes = new AttributeMap();
        this.migrateAttribute("sub", "openid", scope, mappedAttributes, filteredAttributes, policyGroup);
        this.migrateAttribute("email", "email", scope, mappedAttributes, filteredAttributes, policyGroup);
        this.migrateAttribute("email_verified", "email", scope, mappedAttributes, filteredAttributes, policyGroup);
        this.migrateAttribute("phone_number", "phone", scope, mappedAttributes, filteredAttributes, policyGroup);
        this.migrateAttribute("phone_number_verified", "phone", scope, mappedAttributes, filteredAttributes, policyGroup);
        for (String string : UserInfoClaims.ADDRESS_CLAIMS) {
            this.migrateAttribute(string, "address", scope, mappedAttributes, filteredAttributes, policyGroup);
        }
        for (Map.Entry entry : policyGroup.getScopeAttributeMappings().entrySet()) {
            String mappedScope = (String)entry.getKey();
            for (String attribute : (List)entry.getValue()) {
                this.migrateAttribute(attribute, mappedScope, scope, mappedAttributes, filteredAttributes, policyGroup);
            }
        }
        for (Map.Entry entry : policyGroup.getAttributeInclusionMappings().entrySet()) {
            if (!OpenIdParamNames.OPENID_IDTOKEN_STANDARD_CLAIMS.contains(entry.getKey()) || !((OpenIdConnectProviderPolicy.AttributeInclusionInfo)entry.getValue()).isIncludeInUserInfo()) continue;
            this.migrateAttribute((String)entry.getKey(), "openid", scope, mappedAttributes, filteredAttributes, policyGroup);
        }
        if (scope.hasScope("profile") && !policyGroup.getScopeAttributeMappings().containsKey("profile")) {
            mappedAttributes.remove((Object)"sub");
            mappedAttributes.remove((Object)"email");
            mappedAttributes.remove((Object)"email_verified");
            mappedAttributes.remove((Object)"phone_number");
            mappedAttributes.remove((Object)"phone_number_verified");
            for (String string : UserInfoClaims.ADDRESS_CLAIMS) {
                mappedAttributes.remove((Object)string);
            }
            filteredAttributes.putAll((Map)mappedAttributes);
        }
        this.coerceToBoolean(filteredAttributes, "email_verified");
        this.coerceToBoolean(filteredAttributes, "phone_number_verified");
        this.coerceToNumberDate(filteredAttributes, "updated_at");
        return filteredAttributes;
    }

    private void migrateOpenIdStandardClaims(AttributeMap mappedAttributes, Map<String, AttributeValue> openIdStandardClaims) {
        for (Map.Entry entry : mappedAttributes.entrySet()) {
            if (!OpenIdParamNames.OPENID_IDTOKEN_STANDARD_CLAIMS.contains(entry.getKey())) continue;
            openIdStandardClaims.put((String)entry.getKey(), (AttributeValue)entry.getValue());
        }
    }

    private void coerceToBoolean(AttributeMap filteredAttributes, String name) {
        AttributeValue attributeValue = (AttributeValue)filteredAttributes.get((Object)name);
        if (attributeValue != null) {
            Object objectValue = attributeValue.getObjectValue();
            if (objectValue == null) {
                attributeValue = AttrValueSupport.make((Object)Boolean.FALSE);
            } else if (objectValue instanceof String) {
                attributeValue = AttrValueSupport.make((Object)Boolean.parseBoolean((String)objectValue));
            }
            filteredAttributes.put(name, attributeValue);
        }
    }

    private void coerceToNumberDate(AttributeMap filteredAttributes, String name) {
        AttributeValue value = (AttributeValue)filteredAttributes.get((Object)name);
        if (value != null) {
            Long longValue = null;
            java.util.Date dateValue = null;
            Object objectValue = value.getObjectValue();
            if (objectValue instanceof String) {
                String stringValue = (String)objectValue;
                try {
                    dateValue = StaticUtils.decodeGeneralizedTime((String)stringValue);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (dateValue == null) {
                    try {
                        dateValue = Timestamp.valueOf(stringValue);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (dateValue == null) {
                    try {
                        dateValue = Date.valueOf(stringValue);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (dateValue == null) {
                    try {
                        dateValue = new java.util.Date(stringValue);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (dateValue == null) {
                    try {
                        longValue = Long.parseLong(stringValue);
                    }
                    catch (Exception exception) {}
                }
            } else if (objectValue instanceof java.util.Date) {
                dateValue = (java.util.Date)objectValue;
            } else if (objectValue instanceof Calendar) {
                dateValue = ((Calendar)objectValue).getTime();
            }
            if (dateValue != null) {
                longValue = dateValue.getTime() / 1000L;
            }
            if (longValue != null) {
                filteredAttributes.put(name, AttrValueSupport.make((Object)longValue));
            }
        }
    }

    private void migrateAttribute(String name, String requiredScope, Scope scope, AttributeMap sourceMap, AttributeMap destMap, OpenIdConnectProviderPolicy.PolicyGroup policyGroup) {
        AttributeValue value = (AttributeValue)sourceMap.get((Object)name);
        if (scope.hasAllScopes(Scope.getScope((String)requiredScope))) {
            if (policyGroup.getScopeAttributeMappings().containsKey(requiredScope)) {
                for (String customAttributeName : policyGroup.getScopeAttributeMappings().get(requiredScope)) {
                    if (sourceMap.get((Object)customAttributeName) == null) continue;
                    destMap.put(customAttributeName, (AttributeValue)sourceMap.get((Object)customAttributeName));
                }
            }
            destMap.put(name, value);
        }
    }

    public Map<String, Object> prepForSerialization(AttributeMap userInfoAttributes, List<String> attributeContractCollections) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, String> addressClaim = new HashMap<String, String>();
        for (String addressClaimName : UserInfoClaims.ADDRESS_CLAIMS) {
            String value;
            AttributeValue attrValue = (AttributeValue)userInfoAttributes.remove((Object)addressClaimName);
            if (attrValue == null || (value = attrValue.getValue()) == null) continue;
            String[] spilt = addressClaimName.split("\\.");
            addressClaim.put(spilt[1], value);
        }
        if (!addressClaim.isEmpty()) {
            map.put("address", addressClaim);
        }
        attributeContractCollections.addAll(this.globalAttributeContractCollections);
        SimpleJsonRespWriter.prepareAttributeMap(userInfoAttributes, map, attributeContractCollections);
        return map;
    }
}

