/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.openid.connect.domain.mgmt;

import com.pingidentity.configservice.AutoReloadable;
import com.pingidentity.configservice.SysDirInfo;
import com.pingidentity.configservice.XmlLoader;
import com.pingidentity.crypto.jwk.JwkFacilitator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.openid.connect.domain.OpenIdConnectProviderInfo;
import org.sourceid.openid.connect.domain.OpenIdConnectProviderPolicy;
import org.sourceid.openid.connect.domain.UserInfoAttrMapping;
import org.sourceid.openid.connect.domain.mgmt.OpenIdConnectProviderPolicyManager;
import org.sourceid.openid.connect.xmlbinding.AttributeHolderMapItemType;
import org.sourceid.openid.connect.xmlbinding.AttributeHolderType;
import org.sourceid.openid.connect.xmlbinding.ExtendedAttributeAdditionalPropertyItemType;
import org.sourceid.openid.connect.xmlbinding.ExtendedAttributeHolderType;
import org.sourceid.openid.connect.xmlbinding.MapItemType;
import org.sourceid.openid.connect.xmlbinding.OpenIdConnectProviderPolicyDocument;
import org.sourceid.openid.connect.xmlbinding.OpenIdConnectProviderPolicyType;
import org.sourceid.openid.connect.xmlbinding.ProviderPolicyGroupType;
import org.sourceid.saml20.domain.AttributeSource;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.log.AuditLoggerScope;
import org.sourceid.saml20.domain.util.InUseDetectionUtil;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.partner.ConnectionUtil;
import org.sourceid.saml20.xmlbinding.metadata.ext.v2.AttributeMappingType;

public class OpenIdConnectProviderPolicyManagerImpl
implements OpenIdConnectProviderPolicyManager,
AutoReloadable {
    static final String FILENAME = "openid-connect-provider-policy.xml";
    private XmlLoader xmlLoader;
    private String directory;
    private final ConnectionUtil connUtil = new ConnectionUtil();
    private OpenIdConnectProviderPolicy policy;
    private final OpenIdConnectProviderInfo openIdConnectProviderInfo = new OpenIdConnectProviderInfo();

    OpenIdConnectProviderPolicyManagerImpl(XmlLoader xmlLoader, String directory) {
        this.xmlLoader = xmlLoader;
        this.directory = directory;
        this.loadConfig();
    }

    public OpenIdConnectProviderPolicyManagerImpl(XmlLoader xmlLoader, SysDirInfo sysDirInfo) {
        this(xmlLoader, sysDirInfo.getDataDirectory());
    }

    @Override
    public OpenIdConnectProviderInfo getOpenIdConnectProviderInfo() {
        return this.openIdConnectProviderInfo;
    }

    @Override
    public synchronized OpenIdConnectProviderPolicy getPolicy() {
        return this.policy;
    }

    @Override
    public synchronized void deletePolicy(OpenIdConnectProviderPolicy policyToSave) {
        this.savePolicy(policyToSave, AdminAuditLogger.Event.DELETE, "");
    }

    @Override
    public synchronized void savePolicy(OpenIdConnectProviderPolicy policyToSave, boolean isCreate) {
        this.savePolicy(policyToSave, isCreate ? AdminAuditLogger.Event.CREATE : AdminAuditLogger.Event.MODIFY, "");
    }

    private synchronized void savePolicy(OpenIdConnectProviderPolicy policyToSave, AdminAuditLogger.Event event, String msg) {
        OpenIdConnectProviderPolicy.PolicyGroup defaultPolicyGroup;
        OpenIdConnectProviderPolicyDocument doc = OpenIdConnectProviderPolicyDocument.Factory.newInstance();
        OpenIdConnectProviderPolicyType topLevelPolicyType = doc.addNewOpenIdConnectProviderPolicy();
        topLevelPolicyType.setEnabled(policyToSave.isEnabled());
        if (policyToSave.getIssuer() != null) {
            topLevelPolicyType.setIssuer(policyToSave.getIssuer());
        }
        if ((defaultPolicyGroup = policyToSave.getDefaultPolicyGroup()) != null && defaultPolicyGroup.getPolicyId() != null) {
            topLevelPolicyType.setDefaultPolicyGroupId(defaultPolicyGroup.getPolicyId());
        }
        topLevelPolicyType.setTrackUserSessionsForLogout(policyToSave.isTrackUserSessionsForLogout());
        for (OpenIdConnectProviderPolicy.PolicyGroup policyGroup : policyToSave.getPolicyGroups().values()) {
            Set<String> multiValuedAttributes;
            ProviderPolicyGroupType policyGroupType = topLevelPolicyType.addNewProviderPolicyGroup();
            policyGroupType.setPolicyId(policyGroup.getPolicyId());
            policyGroupType.setIdTokenLife(policyGroup.getIdTokenLife());
            policyGroupType.setIncludeSriInIdToken(policyGroup.isIncludeSriInIdToken());
            policyGroupType.setIncludeUserInfoInIdToken(policyGroup.isIncludeUserInfoInIdToken());
            policyGroupType.setIncludeSHashInIdToken(policyGroup.isIncludeSHashInIdToken());
            policyGroupType.setIncludeX5TInIdToken(policyGroup.isIncludeX5tInIdToken());
            policyGroupType.setIdTokenTypHeaderValue(StringUtils.trim((String)policyGroup.getIdTokenTypHeaderValue()));
            policyGroupType.setReturnIdTokenOnRefreshGrant(policyGroup.isReturnIdTokenOnRefreshGrant());
            policyGroupType.setReturnIdTokenOnTokenExchangeGrant(policyGroup.isReturnIdTokenOnTokenExchangeGrant());
            policyGroupType.setReissueIdTokenHybridFlows(policyGroup.isReissueIdTokenHybridFlows());
            policyGroupType.setAllowIdTokenIntrospection(policyGroup.isAllowIdTokenIntrospection());
            policyGroupType.setPolicyName(policyGroup.getName());
            policyGroupType.setAccessTokenManagerId(policyGroup.getAccessTokenManagerId());
            if (policyGroupType.getIncludeUserInfoInIdToken()) {
                policyGroup.getAttributeInclusionMappings().clear();
            }
            if (policyGroupType.getAttributeContractInclusionMap() == null) {
                policyGroupType.setAttributeContractInclusionMap(policyGroupType.addNewAttributeContractInclusionMap());
            }
            int index1 = 0;
            AttributeHolderMapItemType[] attributeItemArray = new AttributeHolderMapItemType[policyGroup.getAttributeInclusionMappings().size()];
            for (Map.Entry<String, OpenIdConnectProviderPolicy.AttributeInclusionInfo> entry : policyGroup.getAttributeInclusionMappings().entrySet()) {
                AttributeHolderMapItemType mapItemType = policyGroupType.getAttributeContractInclusionMap().addNewItem();
                mapItemType.setKey(entry.getKey());
                AttributeHolderType value = mapItemType.addNewValue();
                value.setIncludeInIdToken(entry.getValue().isIncludeInIdToken());
                value.setIncludeInUserInfo(entry.getValue().isIncludeInUserInfo());
                mapItemType.setValue(value);
                attributeItemArray[index1++] = mapItemType;
            }
            policyGroupType.getAttributeContractInclusionMap().setItemArray(attributeItemArray);
            if (policyGroupType.getExtendedAttributesAdditionalProperties() == null) {
                policyGroupType.setExtendedAttributesAdditionalProperties(policyGroupType.addNewExtendedAttributesAdditionalProperties());
            }
            if ((multiValuedAttributes = policyGroup.getMultiValuedAttributes()) != null) {
                int index = 0;
                ExtendedAttributeAdditionalPropertyItemType[] multiValuedAttributeItemArray = new ExtendedAttributeAdditionalPropertyItemType[policyGroup.getMultiValuedAttributes().size()];
                for (String string : multiValuedAttributes) {
                    ExtendedAttributeAdditionalPropertyItemType itemType = policyGroupType.getExtendedAttributesAdditionalProperties().addNewItem();
                    itemType.setKey(string);
                    ExtendedAttributeHolderType value = itemType.addNewValue();
                    value.setMultiValued(true);
                    itemType.setValue(value);
                    multiValuedAttributeItemArray[index++] = itemType;
                }
                policyGroupType.getExtendedAttributesAdditionalProperties().setItemArray(multiValuedAttributeItemArray);
            }
            if (policyGroupType.getScopeAttributesMap() == null) {
                policyGroupType.setScopeAttributesMap(policyGroupType.addNewScopeAttributesMap());
            }
            int index = 0;
            MapItemType[] itemArray = new MapItemType[policyGroup.getScopeAttributeMappings().size()];
            for (Map.Entry entry : policyGroup.getScopeAttributeMappings().entrySet()) {
                MapItemType mapItemType = policyGroupType.getScopeAttributesMap().addNewItem();
                mapItemType.setKey((String)entry.getKey());
                mapItemType.setValue((List)entry.getValue());
                itemArray[index++] = mapItemType;
            }
            policyGroupType.getScopeAttributesMap().setItemArray(itemArray);
            if (policyGroup.getLastModified() != null) {
                policyGroupType.setLastModified(policyGroup.getLastModified());
            }
            AttributeMappingType attrMappingType = policyGroupType.addNewUserInfoMapping();
            UserInfoAttrMapping userInfoAttrMapping = policyGroup.getUserInfoAttributeMapping();
            this.connUtil.fillInAttributeMappingType(attrMappingType, userInfoAttrMapping);
        }
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            this.xmlLoader.save(this.directory, FILENAME, (XmlObject)doc);
            auditLoggerScope.log(AdminAuditLogger.Component.OAUTH_POLICY, event, msg);
        }
        this.loadConfig();
        this.reloadJwkKeys();
        MetaDataFactory.getLocalMetaData().reload();
    }

    @Override
    public synchronized void setDefaultInstance(String defaultPolicyId) {
        OpenIdConnectProviderPolicy connectProviderPolicy = this.getPolicy();
        if (!Objects.equals(connectProviderPolicy.getDefaultPolicyGroupId(), defaultPolicyId)) {
            connectProviderPolicy.setDefaultPolicyGroupId(defaultPolicyId);
            this.savePolicy(connectProviderPolicy, AdminAuditLogger.Event.MODIFY, "Default instance modified to " + defaultPolicyId);
        }
    }

    @Override
    public boolean isDataSourceInUse(String id) {
        for (OpenIdConnectProviderPolicy.PolicyGroup group : this.policy.getPolicyGroups().values()) {
            UserInfoAttrMapping mapping = group.getUserInfoAttributeMapping();
            boolean inUse = InUseDetectionUtil.getInstance().isDataSourceInUseByAttributeMapping(mapping, id);
            if (!inUse) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<OpenIdConnectProviderPolicy.PolicyGroup> getPolicyGroupsWithDSInUse(String id) {
        LinkedList<OpenIdConnectProviderPolicy.PolicyGroup> policyGroupsWithDSInUse = new LinkedList<OpenIdConnectProviderPolicy.PolicyGroup>();
        for (OpenIdConnectProviderPolicy.PolicyGroup group : this.policy.getPolicyGroups().values()) {
            UserInfoAttrMapping mapping = group.getUserInfoAttributeMapping();
            for (AttributeSource attrSource : mapping.getAttributeSources()) {
                if (attrSource == null || !id.equals(attrSource.getDataSourceId()) || policyGroupsWithDSInUse.contains(group)) continue;
                policyGroupsWithDSInUse.add(group);
            }
        }
        return policyGroupsWithDSInUse;
    }

    public synchronized void loadConfig() {
        OpenIdConnectProviderPolicyDocument doc;
        if (this.xmlLoader.xmlExists(this.directory, FILENAME)) {
            XmlObject xmlObject = this.xmlLoader.load(this.directory, FILENAME);
            doc = (OpenIdConnectProviderPolicyDocument)xmlObject;
        } else {
            doc = OpenIdConnectProviderPolicyDocument.Factory.newInstance();
            doc.addNewOpenIdConnectProviderPolicy();
        }
        OpenIdConnectProviderPolicyType topLevelPolicyType = doc.getOpenIdConnectProviderPolicy();
        OpenIdConnectProviderPolicy domainPolicy = new OpenIdConnectProviderPolicy();
        domainPolicy.setIssuer(topLevelPolicyType.getIssuer());
        domainPolicy.setDefaultPolicyGroupId(topLevelPolicyType.getDefaultPolicyGroupId());
        domainPolicy.setTrackUserSessionsForLogout(topLevelPolicyType.getTrackUserSessionsForLogout());
        for (ProviderPolicyGroupType policyGroupType : topLevelPolicyType.getProviderPolicyGroupArray()) {
            UserInfoAttrMapping domainMapping = new UserInfoAttrMapping();
            AttributeMappingType mappingType = policyGroupType.getUserInfoMapping();
            this.connUtil.fillAttrMappingFromXml(mappingType, domainMapping);
            OpenIdConnectProviderPolicy.PolicyGroup policyGroup = new OpenIdConnectProviderPolicy.PolicyGroup();
            policyGroup.setIdTokenLife(policyGroupType.getIdTokenLife());
            policyGroup.setIncludeSriInIdToken(policyGroupType.getIncludeSriInIdToken());
            policyGroup.setIncludeUserInfoInIdToken(policyGroupType.getIncludeUserInfoInIdToken());
            policyGroup.setIncludeSHashInIdToken(policyGroupType.getIncludeSHashInIdToken());
            policyGroup.setIncludeX5tInIdToken(policyGroupType.getIncludeX5TInIdToken());
            policyGroup.setIdTokenTypHeaderValue(policyGroupType.getIdTokenTypHeaderValue());
            policyGroup.setReturnIdTokenOnRefreshGrant(policyGroupType.getReturnIdTokenOnRefreshGrant());
            policyGroup.setReturnIdTokenOnTokenExchangeGrant(policyGroupType.getReturnIdTokenOnTokenExchangeGrant());
            policyGroup.setReissueIdTokenHybridFlows(policyGroupType.getReissueIdTokenHybridFlows());
            policyGroup.setAllowIdTokenIntrospection(policyGroupType.getAllowIdTokenIntrospection());
            policyGroup.setUserInfoAttributeMapping(domainMapping);
            if (policyGroupType.getScopeAttributesMap() != null) {
                for (MapItemType mapItemType : policyGroupType.getScopeAttributesMap().getItemArray()) {
                    policyGroup.getScopeAttributeMappings().put(mapItemType.getKey(), mapItemType.getValue());
                }
            }
            if (policyGroupType.getAttributeContractInclusionMap() != null) {
                for (MapItemType mapItemType : policyGroupType.getAttributeContractInclusionMap().getItemArray()) {
                    AttributeHolderType attributeHolderType = mapItemType.getValue();
                    policyGroup.getAttributeInclusionMappings().put(mapItemType.getKey(), new OpenIdConnectProviderPolicy.AttributeInclusionInfo(attributeHolderType.getIncludeInIdToken(), attributeHolderType.getIncludeInUserInfo()));
                }
            }
            if (policyGroupType.getExtendedAttributesAdditionalProperties() != null) {
                for (MapItemType mapItemType : policyGroupType.getExtendedAttributesAdditionalProperties().getItemArray()) {
                    if (!mapItemType.getValue().getMultiValued()) continue;
                    policyGroup.getMultiValuedAttributes().add(mapItemType.getKey());
                }
            }
            LinkedHashSet<String> mutableAttributeNames = new LinkedHashSet<String>(domainMapping.getAttributeMapping().keySet());
            mutableAttributeNames.removeAll(policyGroup.getUserInfoAttributeContract().getImmutableAttributeNames());
            policyGroup.getUserInfoAttributeContract().setMutableAttributeNames(mutableAttributeNames);
            policyGroup.setPolicyId(policyGroupType.getPolicyId());
            policyGroup.setName(policyGroupType.getPolicyName());
            if (policyGroupType.isSetAccessTokenManagerId()) {
                policyGroup.setAccessTokenManagerId(policyGroupType.getAccessTokenManagerId());
            } else {
                policyGroup.setAccessTokenManagerId("default");
            }
            if (policyGroupType.getLastModified() != null) {
                policyGroup.setLastModified(policyGroupType.getLastModified());
            }
            domainPolicy.addPolicyGroup(policyGroup);
        }
        this.policy = domainPolicy;
    }

    private void reloadJwkKeys() {
        JwkFacilitator jwkFacilitator = GlobalRegistry.getService(JwkFacilitator.class);
        jwkFacilitator.reload();
    }

    @Override
    public String getDefaultPolicyId() {
        OpenIdConnectProviderPolicy.PolicyGroup policyGroup = this.getPolicy().getDefaultPolicyGroup();
        if (policyGroup != null) {
            return policyGroup.getPolicyId();
        }
        return null;
    }
}

