/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.openid.connect.handlers;

import com.pingidentity.sdk.accessgrant.AccessGrant;
import com.pingidentity.sdk.accessgrant.AccessGrantAttributesHolder;
import com.pingidentity.sdk.accessgrant.AccessGrantManager;
import com.pingidentity.sdk.oauth20.Scope;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.oauth20.bindings.AccessTokenProtectedResourceBinding;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientManager;
import org.sourceid.oauth20.domain.PersistentGrantHelper;
import org.sourceid.oauth20.dpop.DpopUtil;
import org.sourceid.oauth20.handlers.AuthorizationRequestException;
import org.sourceid.oauth20.handlers.HandlerUtil;
import org.sourceid.oauth20.issuer.OAuthIssuerUtils;
import org.sourceid.oauth20.service.OAuthJwtTokenService;
import org.sourceid.oauth20.wwwauth.AccessTokenUtil;
import org.sourceid.openid.connect.OpenIdParamNames;
import org.sourceid.openid.connect.bindings.OIDCBindingGroup;
import org.sourceid.openid.connect.domain.ConnectProviderRuntimePolicySupport;
import org.sourceid.openid.connect.domain.OpenIdConnectProviderPolicy;
import org.sourceid.openid.connect.domain.UserInfoAttrMapping;
import org.sourceid.openid.connect.service.PairwisePseudonymService;
import org.sourceid.openid.connect.service.impl.PairwisePseudonymServiceException;
import org.sourceid.saml20.adapter.attribute.AttrValueSupport;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.domain.AttrLookupException;
import org.sourceid.saml20.domain.AuthorizationException;
import org.sourceid.saml20.domain.SourceContextType;
import org.sourceid.saml20.domain.SystemAttrLookupException;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.metadata.local.PathUtil;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.AuditLogger;
import org.sourceid.websso.Protocol;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.websso.profiles.RequestHandler;
import org.sourceid.websso.profiles.idp.AsAuditLogger;
import org.sourceid.websso.servlet.HttpStatusCodeException;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public class UserInfoEndpoint
implements RequestHandler {
    private static final Log log = LogFactory.getLog(UserInfoEndpoint.class);
    private final ConnectProviderRuntimePolicySupport policySupport;
    private final ClientManager clientManager;
    private final AccessTokenUtil accessTokenUtil;
    private final PairwisePseudonymService pairwisePseudonymService;
    private final AccessGrantManager accessGrantMgr;
    private final AuthzServerManager authzServerManager;
    private final OAuthIssuerUtils oAuthIssuerUtils;
    private final OAuthJwtTokenService oAuthJwtTokenService;

    public UserInfoEndpoint() {
        this(new ConnectProviderRuntimePolicySupport(), MgmtFactory.getClientManager(), new AccessTokenUtil(OIDCBindingGroup.SUGGESTED_SCOPES, "UserInfo"), MgmtFactory.getPairwisePseudonymService(), MgmtFactory.getAccessGrantManager(), MgmtFactory.getAuthzServerManager(), OAuthIssuerUtils.getInstance(), MgmtFactory.getOAuthJwtTokenService());
    }

    public UserInfoEndpoint(ConnectProviderRuntimePolicySupport policySupport, ClientManager clientManager, AccessTokenUtil accessTokenUtil, PairwisePseudonymService pairwisePseudonymService, AccessGrantManager accessGrantMgr, AuthzServerManager authzServerManager, OAuthIssuerUtils oAuthIssuerUtils, OAuthJwtTokenService oAuthJwtTokenService) {
        this.policySupport = policySupport;
        this.clientManager = clientManager;
        this.accessTokenUtil = accessTokenUtil;
        this.pairwisePseudonymService = pairwisePseudonymService;
        this.accessGrantMgr = accessGrantMgr;
        this.authzServerManager = authzServerManager;
        this.oAuthIssuerUtils = oAuthIssuerUtils;
        this.oAuthJwtTokenService = oAuthJwtTokenService;
    }

    @Override
    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"})
    public OutMessageContext process(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp) throws IOException, HttpStatusCodeException {
        AccessTokenUtil.setErrorResponseContentType(req, "application/json");
        try {
            List<String> claimsToRemove;
            AttributeMap mappedAttrs;
            OutMessageContext outMsgCtx = new OutMessageContext(Role.SP);
            String clientId = inMsgCtx.getEntityId();
            outMsgCtx.setEntityId(clientId);
            outMsgCtx.setSignaturePolicy(null);
            AsAuditLogger.setConnectionId(clientId);
            this.oAuthIssuerUtils.setAuditLogVirtualServerIdIfApplicable(req);
            Map<String, AttributeValue> accessTokenAttrs = AccessTokenProtectedResourceBinding.getAccessTokenAttributes(inMsgCtx);
            AttributeMap contextAttrs = new AttributeMap();
            contextAttrs.put(SourceContextType.CLIENT_IP.getId(), new AttributeValue(req.getRemoteAddr()));
            contextAttrs.put(SourceContextType.REQUEST.getId(), AttrValueSupport.make((Object)req));
            contextAttrs.put(SourceContextType.REQUEST_ENDPOINT.getId(), new AttributeValue(PathUtil.getRequestPath(req)));
            contextAttrs.put(SourceContextType.OAUTH_CLIENT.getId(), new AttributeValue(clientId));
            Scope scope = AccessTokenProtectedResourceBinding.getScope(inMsgCtx);
            Client client = this.clientManager.getCachedClient(clientId);
            if (client == null || !client.isEnabled()) {
                String errorDesc = "Invalid clients are not allowed on the user info endpoint.";
                throw this.accessTokenUtil.statusCodeEx(403, null, errorDesc, DpopUtil.isDpopBoundAccessToken(accessTokenAttrs));
            }
            OpenIdConnectProviderPolicy.PolicyGroup policyGroup = this.policySupport.getPolicyGroup(client);
            UserInfoAttrMapping userInfoAttrMapping = policyGroup.getUserInfoAttributeMapping();
            HandlerUtil.addExtPropertiesToAttrMap(client.getExtendedParams(), contextAttrs);
            if (userInfoAttrMapping == null) {
                throw new ProcessRuntimeException("No attribute mapping configured for the user info endpoint claims.");
            }
            try {
                AttributeMap accessGrantAttrs = this.getAccessGrantAttributeMap(inMsgCtx, client);
                mappedAttrs = userInfoAttrMapping.exMapping(accessTokenAttrs, (Map<String, AttributeValue>)contextAttrs, scope, policyGroup, (Map<String, AttributeValue>)accessGrantAttrs);
            }
            catch (SystemAttrLookupException e) {
                log.error((Object)"Unable to map attributes", (Throwable)e);
                AuditLogger.setStatus("failure");
                AsAuditLogger.setEvent("OAuth");
                AsAuditLogger.setProtocol(Protocol.OIDC.toString());
                AsAuditLogger.log("Failed to retrieve user info");
                resp.setStatus(500);
                outMsgCtx.setParam("error", (Object)AuthorizationRequestException.Error.server_error);
                if (e.getMessage() != null) {
                    outMsgCtx.setParam("error_description", e.getMessage());
                }
                return outMsgCtx;
            }
            catch (AttrLookupException | AuthorizationException | ProcessRuntimeException e) {
                log.error((Object)"Unable to map attributes", (Throwable)e);
                String errorDesc = null;
                if (e instanceof AuthorizationException) {
                    errorDesc = ((AuthorizationException)e).getErrorDetail();
                }
                throw this.accessTokenUtil.statusCodeEx(403, null, errorDesc, DpopUtil.isDpopBoundAccessToken(accessTokenAttrs));
            }
            if (policyGroup.getAttributeInclusionMappings() != null && !policyGroup.getAttributeInclusionMappings().isEmpty()) {
                claimsToRemove = policyGroup.getAttributeInclusionMappings().entrySet().stream().filter(entry -> !((OpenIdConnectProviderPolicy.AttributeInclusionInfo)entry.getValue()).isIncludeInUserInfo()).map(Map.Entry::getKey).collect(Collectors.toList());
                Predicate<String> standardIdTokenPredicate = claim -> !policyGroup.getAttributeInclusionMappings().containsKey(claim) || policyGroup.getAttributeInclusionMappings().containsKey(claim) && !policyGroup.getAttributeInclusionMappings().get(claim).isIncludeInUserInfo();
                claimsToRemove.addAll(OpenIdParamNames.OPENID_IDTOKEN_STANDARD_CLAIMS.stream().filter(standardIdTokenPredicate).collect(Collectors.toList()));
            } else {
                claimsToRemove = new ArrayList<String>(OpenIdParamNames.OPENID_IDTOKEN_STANDARD_CLAIMS);
            }
            if (!claimsToRemove.isEmpty() && !policyGroup.isIncludeUserInfoInIdToken()) {
                mappedAttrs.keySet().removeAll(claimsToRemove);
            }
            ArrayList<String> multiValueAttrs = new ArrayList<String>();
            if (policyGroup.getMultiValuedAttributes() != null) {
                multiValueAttrs.addAll(policyGroup.getMultiValuedAttributes());
            }
            Map<String, Object> outParams = userInfoAttrMapping.prepForSerialization(mappedAttrs, multiValueAttrs);
            if (client.isPairwiseUserType()) {
                String subjectValue = (String)outParams.get("sub");
                log.debug((Object)("Converting the subject [" + subjectValue + "] to a PPID."));
                String sectorIdentifier = client.getSectorIdentifier();
                try {
                    subjectValue = this.pairwisePseudonymService.toPPID(subjectValue, sectorIdentifier);
                    outParams.put("sub", subjectValue);
                }
                catch (PairwisePseudonymServiceException e) {
                    throw new ProcessRuntimeException("Problem with generating a pairwise pseudononymous identifier for the subject[" + subjectValue + "]: " + e.getMessage());
                }
            }
            if (StringUtils.isNotBlank((String)client.getUserInfoResponseSigningAlgorithm())) {
                log.debug((Object)("Client: '" + clientId + "' is configured to sign UserInfo endpoint responses. The response will be returned as a JWT."));
                outParams.put("iss", this.oAuthIssuerUtils.getIssuerValue(req));
                outParams.put("aud", client.getClientId());
                outMsgCtx.setBinding("application/jwt");
                String userInfoResponseJwt = this.oAuthJwtTokenService.issueUserInfoEndpointResponse(req, client, outParams);
                outMsgCtx.setParam("jwt", userInfoResponseJwt);
            } else {
                log.debug((Object)("Client: '" + clientId + "' is not configured to sign UserInfo endpoint responses. The response will be returned as JSON."));
                outMsgCtx.setBinding("application/json");
                outMsgCtx.setParams(outParams);
            }
            AsAuditLogger.setEvent("OAuth");
            AsAuditLogger.setProtocol(Protocol.OIDC.toString());
            AsAuditLogger.setUserName(mappedAttrs.getSingleValue("sub"));
            AsAuditLogger.log("Retrieved user info");
            return outMsgCtx;
        }
        catch (Exception e) {
            AsAuditLogger.setDescription(e.getMessage());
            AsAuditLogger.setEvent("OAuth");
            AsAuditLogger.setProtocol(Protocol.OIDC.toString());
            AsAuditLogger.setStatus("failure");
            AsAuditLogger.log("Unable to get user info");
            throw e;
        }
    }

    private AttributeMap getAccessGrantAttributeMap(InMessageContext inMsgCtx, Client client) throws AttrLookupException {
        String accessGrantGuid = AccessTokenProtectedResourceBinding.getAccessGrantGuid(inMsgCtx);
        if (StringUtils.isNotBlank((String)accessGrantGuid)) {
            AccessGrant accessGrant = this.accessGrantMgr.getByGuid(accessGrantGuid);
            if (accessGrant == null) {
                String msg = String.format("Revoked, expired or otherwise invalid/unknown access grant guid: %s", accessGrantGuid);
                log.error((Object)msg);
                throw new AttrLookupException(msg);
            }
            String userKey = accessGrant.getUniqueUserIdentifer();
            AccessGrantAttributesHolder holder = this.accessGrantMgr.getGrantAttributes(accessGrantGuid);
            return PersistentGrantHelper.getGrantAttributeMap(userKey, holder, accessGrant, client, this.authzServerManager);
        }
        return new AttributeMap();
    }
}

