/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.openid.connect.model;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.sourceid.common.SpaceDelimitedStringUtil;
import org.sourceid.oauth20.handlers.AuthorizationRequestException;

public class Prompt {
    public static final String NONE = "none";
    public static final String LOGIN = "login";
    public static final String CONSENT = "consent";
    public static final String SELECT_ACCOUNT = "select_account";
    public static final String CREATE = "create";
    public static final List<String> PROMPT_VALUES_SUPPORTED = List.of("none", "login", "consent", "create");
    Set<String> promptSet = new LinkedHashSet<String>();

    public Prompt(String rawPromptString) throws AuthorizationRequestException {
        SpaceDelimitedStringUtil.fromString((String)rawPromptString, this.promptSet);
        if (this.isSelectAccount()) {
            throw new AuthorizationRequestException(AuthorizationRequestException.Error.invalid_request, "select_account currently unsupported for prompt");
        }
        if (this.isNone() && this.promptSet.size() > 1) {
            throw new AuthorizationRequestException(AuthorizationRequestException.Error.invalid_request, "prompt with none cannot contains any other values");
        }
        if (this.isCreate() && this.promptSet.size() > 1) {
            throw new AuthorizationRequestException(AuthorizationRequestException.Error.invalid_request, "prompt with create cannot contain any other values");
        }
        if (this.promptSet.size() > 3) {
            throw new AuthorizationRequestException(AuthorizationRequestException.Error.invalid_request, "prompt is malformed");
        }
        HashSet<String> tmp = new HashSet<String>(this.promptSet);
        tmp.remove(NONE);
        tmp.remove(LOGIN);
        tmp.remove(CONSENT);
        tmp.remove(SELECT_ACCOUNT);
        tmp.remove(CREATE);
        if (!tmp.isEmpty()) {
            throw new AuthorizationRequestException(AuthorizationRequestException.Error.invalid_request, "prompt is malformed");
        }
    }

    public boolean isLogin() {
        return this.has(LOGIN);
    }

    public boolean isConsent() {
        return this.has(CONSENT);
    }

    private boolean isSelectAccount() {
        return this.has(SELECT_ACCOUNT);
    }

    public boolean isNone() {
        return this.has(NONE);
    }

    public boolean isCreate() {
        return this.has(CREATE);
    }

    private boolean has(String item) {
        return this.promptSet.contains(item);
    }
}

