/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.openid.connect.profiles.sp;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.ThreadContext;
import org.jose4j.jwa.AlgorithmConstraints;
import org.jose4j.jwk.HttpsJwks;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.keys.resolvers.DecryptionKeyResolver;
import org.jose4j.keys.resolvers.VerificationKeyResolver;
import org.sourceid.common.ExceptionUtil;
import org.sourceid.oauth20.handlers.GeneralOAuthError;
import org.sourceid.oauth20.protocol.HttpsJwksCache;
import org.sourceid.oauth20.utils.JwtProcessingUtils;
import org.sourceid.openid.connect.MultiDecryptionKeyResolver;
import org.sourceid.openid.connect.MultiSigningKeyResolver;
import org.sourceid.openid.connect.domain.OpenIdConnectProviderInfo;
import org.sourceid.openid.connect.profiles.sp.LogoutException;
import org.sourceid.saml20.adapter.GeneralAdapterException;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.Entity;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.OIDCSettings;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.profiles.HandleLogoutRequestBase;
import org.sourceid.saml20.profiles.idp.SLOSupport;
import org.sourceid.saml20.service.AuthnSessionInfo;
import org.sourceid.saml20.service.IdpHashableAuthnBean;
import org.sourceid.saml20.service.SpHashableAuthnBean;
import org.sourceid.saml20.state.IdpSessionRegistrySupport;
import org.sourceid.util.license.LicenseManager;
import org.sourceid.util.log.internal.TrackingIdSupport;
import org.sourceid.websso.AuditLogger;
import org.sourceid.websso.Protocol;
import org.sourceid.websso.profiles.RequestProcessingException;
import org.sourceid.websso.profiles.sp.SpAuditLogger;
import org.sourceid.websso.servlet.ExtendedSri;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public class BackChannelLogoutEndpoint
extends HandleLogoutRequestBase {
    private static final AlgorithmConstraints ENC_CONSTRAINTS = new AlgorithmConstraints(AlgorithmConstraints.ConstraintType.WHITELIST, OpenIdConnectProviderInfo.getEncryptionAlgorithms().toArray(new String[OpenIdConnectProviderInfo.getEncryptionAlgorithms().size()]));
    private static final AlgorithmConstraints CONTENT_ENC_CONSTRAINTS = new AlgorithmConstraints(AlgorithmConstraints.ConstraintType.WHITELIST, OpenIdConnectProviderInfo.getContentEncryptionAlgorithms().toArray(new String[OpenIdConnectProviderInfo.getContentEncryptionAlgorithms().size()]));
    private final SLOSupport idpSloSupport;
    private final HttpsJwksCache httpsJwksCache;

    public BackChannelLogoutEndpoint() {
        this.idpSloSupport = new SLOSupport(this.localMetaData);
        this.httpsJwksCache = HttpsJwksCache.getInstance();
    }

    public BackChannelLogoutEndpoint(HttpsJwksCache httpsJwksCache) {
        this.idpSloSupport = new SLOSupport(this.localMetaData);
        this.httpsJwksCache = httpsJwksCache;
    }

    @Override
    protected ConnectionBase getPartnerMetadata(InMessageContext inMsgCtx) {
        return null;
    }

    @Override
    protected String getResumePathQualifier(OutMessageContext outMsgCtx) {
        return null;
    }

    @Override
    protected void exeResume(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, OutMessageContext outMsgCtx, Map<String, Object> params) throws RequestProcessingException, IOException, GeneralAdapterException {
        this.doResume(inMsgCtx, req, resp, outMsgCtx, params);
    }

    @Override
    protected OutMessageContext getInitialOutMsgCtx(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp) {
        return new OutMessageContext(inMsgCtx.getRoleType());
    }

    @Override
    protected void handle(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, OutMessageContext outMsgCtx) throws IOException, RequestProcessingException {
        String sid;
        String subject;
        String issuer;
        String partnerEntityId = outMsgCtx.getEntityId();
        SpAuditLogger.setPartnerId(partnerEntityId);
        SpAuditLogger.setProtocol(Protocol.OIDC.name());
        SpAuditLogger.setEvent("SLO");
        ThreadContext.put((String)AuditLogger.MDC_KEY.INITIATOR.toString(), (String)"IdP");
        IdpConnection idpConnection = MgmtFactory.getMetadataDirectory().getIdpConnection(partnerEntityId, true);
        LicenseManager.checkLicenseForConnection(idpConnection);
        JwtClaims jwtClaims = this.validateLogoutToken(inMsgCtx.getParam("logout_token"), idpConnection);
        try {
            String jti;
            issuer = jwtClaims.getIssuer();
            subject = jwtClaims.getSubject();
            if (subject != null) {
                SpAuditLogger.setUserName(subject);
            }
            if ((sid = jwtClaims.getStringClaimValue("sid")) != null) {
                TrackingIdSupport.addReference(sid);
            }
            if ((jti = jwtClaims.getJwtId()) != null) {
                SpAuditLogger.setRequestJti(jti);
            }
        }
        catch (MalformedClaimException e) {
            throw new LogoutException(LogoutException.Error.invalid_request, e.getMessage(), e);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Received OIDC back-channel logout request, partner id: " + idpConnection.getEntityId() + ", client id: " + idpConnection.getOidcSettings().getClientId() + ", issuer: " + issuer + ", subject: " + subject + ", sid: " + sid));
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("success", true);
        this.setStage(params, HandleLogoutRequestBase.ProcessingStage.LOGGING_OUT_IDP_ADAPTERS);
        Set<String> extendedSris = IdpSessionRegistrySupport.retrieveAndRemoveSris(issuer, subject, sid);
        if (extendedSris.isEmpty() && this.log.isDebugEnabled()) {
            this.log.debug((Object)"No registered sessions found for issuer, subject and/or sid");
        }
        HashSet<IdpHashableAuthnBean> beans = new HashSet<IdpHashableAuthnBean>();
        HashSet<String> srisSeen = new HashSet<String>();
        HashSet<String> storedSessionGroupIds = new HashSet<String>();
        for (String extendedSriStr : extendedSris) {
            ExtendedSri extendedSri = new ExtendedSri(extendedSriStr);
            if (extendedSri.getPersistentSessionGroupId() != null) {
                storedSessionGroupIds.add(extendedSri.getPersistentSessionGroupId());
            }
            if (srisSeen.contains(extendedSri.getSri())) continue;
            srisSeen.add(extendedSri.getSri());
            AuthnSessionInfo authnSessionInfo = IdpSessionRegistrySupport.getAuthnSessionInfoForLogout(extendedSri.getSri());
            beans.addAll(authnSessionInfo.getBeans());
            IdpSessionRegistrySupport.checkLogSessionDeleted(extendedSriStr, authnSessionInfo);
            this.idpSloSupport.checkRevokeUserSession(extendedSri.getSri());
        }
        IdpSessionRegistrySupport.deleteStoredSessions(storedSessionGroupIds);
        IdpSessionRegistrySupport.setInvalidForSso(beans);
        this.addIdpBeansToParams(beans, params);
        Collection<SpHashableAuthnBean> spAuthnBeans = this.getSpAdapterBeans(beans);
        this.addSpBeansToParams(spAuthnBeans, params);
        SpAuditLogger.log("logging out ...");
        this.resume(inMsgCtx, req, resp, outMsgCtx, params);
    }

    @Override
    protected void doResume(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, OutMessageContext outMsgCtx, Map<String, Object> params) throws RequestProcessingException, IOException, GeneralAdapterException {
        boolean suspend = false;
        block4: while (!suspend) {
            switch (this.getStage(params)) {
                case LOGGING_OUT_IDP_ADAPTERS: {
                    this.logoutIdpAdapters(inMsgCtx, req, resp, outMsgCtx, params);
                    this.logoutIdpPartners(inMsgCtx, req, resp, outMsgCtx, params);
                    this.logoutSpAdapters(inMsgCtx, req, resp, outMsgCtx, params);
                    this.logoutSpPartners(inMsgCtx, req, resp, outMsgCtx, params);
                    this.setStage(params, HandleLogoutRequestBase.ProcessingStage.DONE);
                    continue block4;
                }
                case DONE: {
                    this.finishLogout(params);
                    suspend = true;
                    continue block4;
                }
            }
            throw new IllegalStateException("Unexpected processing stage");
        }
    }

    @Override
    protected void handleEx(Exception e, InMessageContext inMsgCtx, OutMessageContext outMsgCtx, Map<String, Object> stateParams, HttpServletRequest req, HttpServletResponse resp) {
        if (e instanceof GeneralOAuthError) {
            GeneralOAuthError generalOAuthError = (GeneralOAuthError)((Object)e);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Error processing logout request: " + ExceptionUtil.toStringWithCauses(e)));
            }
            outMsgCtx.setParam("error", generalOAuthError.getErrorCode());
            outMsgCtx.setParam("error_description", generalOAuthError.getDescription());
        } else {
            this.log.error((Object)"Unexpected error processing logout request", (Throwable)e);
            outMsgCtx.setParam("error", LogoutException.Error.server_error.name());
        }
    }

    @Override
    protected void handleException(HttpServletRequest req, HttpServletResponse resp, InMessageContext inMsgCtx, OutMessageContext outMsgCtx, Map<String, Object> stateParams, Exception e) throws IOException {
        this.handleEx(e, inMsgCtx, outMsgCtx, stateParams, req, resp);
    }

    @Override
    protected void validateXml(InMessageContext inMsgCtx) {
    }

    @Override
    protected void verifySignature(InMessageContext inMsgCtx) {
    }

    JwtClaims validateLogoutToken(String logoutToken, IdpConnection idpConnection) throws LogoutException {
        OIDCSettings oidcSettings = idpConnection.getOidcSettings();
        JwtConsumerBuilder jwtConsumerBuilder = new JwtConsumerBuilder().setRequireIssuedAt().setExpectedAudience(new String[]{oidcSettings.getClientId()});
        if (idpConnection.isAllowAllEntities()) {
            jwtConsumerBuilder.setExpectedIssuers(true, new String[0]);
        } else {
            Set<String> allowedIssuers = idpConnection.getAdditionalAllowedEntities().stream().map(Entity::getEntityId).collect(Collectors.toSet());
            allowedIssuers.add(idpConnection.getEntityId());
            jwtConsumerBuilder.setExpectedIssuers(true, allowedIssuers.toArray(new String[0]));
        }
        String jwksUri = oidcSettings.getJwksUri().getFullLocation();
        HttpsJwks httpsJwks = this.httpsJwksCache.getJwks(jwksUri, idpConnection.getEntityId());
        MultiSigningKeyResolver verificationKeyResolver = new MultiSigningKeyResolver(oidcSettings.getSecretAsUtf8Bytes(), httpsJwks);
        jwtConsumerBuilder.setVerificationKeyResolver((VerificationKeyResolver)verificationKeyResolver);
        jwtConsumerBuilder.setJwsAlgorithmConstraints(AlgorithmConstraints.DISALLOW_NONE);
        MultiDecryptionKeyResolver decryptionKeyResolver = new MultiDecryptionKeyResolver(oidcSettings.getSecretAsUtf8Bytes());
        jwtConsumerBuilder.setDecryptionKeyResolver((DecryptionKeyResolver)decryptionKeyResolver);
        jwtConsumerBuilder.setJweAlgorithmConstraints(ENC_CONSTRAINTS);
        jwtConsumerBuilder.setJweContentEncryptionAlgorithmConstraints(CONTENT_ENC_CONSTRAINTS);
        JwtProcessingUtils.checkApplyKeyProviderContextOverride(logoutToken, decryptionKeyResolver, jwtConsumerBuilder);
        JwtConsumer jwtConsumer = jwtConsumerBuilder.build();
        try {
            JwtClaims jwtClaims = jwtConsumer.processToClaims(logoutToken);
            if (!jwtClaims.hasClaim("sub") && !jwtClaims.hasClaim("sid")) {
                throw new LogoutException(LogoutException.Error.invalid_request, "The logout token must include either the 'sub' claim or the 'sid' claim");
            }
            if (!jwtClaims.hasClaim("events")) {
                throw new LogoutException(LogoutException.Error.invalid_request, "The logout token must include the 'events' claim");
            }
            Map eventsClaim = (Map)jwtClaims.getClaimValue("events", Map.class);
            if (!eventsClaim.containsKey("http://schemas.openid.net/event/backchannel-logout")) {
                throw new LogoutException(LogoutException.Error.invalid_request, "The logout token must include 'http://schemas.openid.net/event/backchannel-logout' in the 'events' claim");
            }
            if (jwtClaims.hasClaim("nonce")) {
                throw new LogoutException(LogoutException.Error.invalid_request, "The logout token must not include the 'nonce' claim");
            }
            return jwtClaims;
        }
        catch (MalformedClaimException | InvalidJwtException e) {
            throw new LogoutException(LogoutException.Error.invalid_request, "Invalid logout token", e);
        }
    }

    private void finishLogout(Map<String, Object> params) throws LogoutException {
        boolean success;
        Boolean successObj = (Boolean)params.get("success");
        boolean bl = success = successObj != null && successObj != false;
        if (!success) {
            throw new LogoutException(LogoutException.Error.partial_logout, "Unable to logout all local sessions");
        }
    }
}

