/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.openid.connect.profiles.sp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jose4j.base64url.Base64Url;
import org.sourceid.common.HashAlgorithm;
import org.sourceid.common.HashUtil;
import org.sourceid.common.IDGenerator;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.oauth20.protocol.Parameters;
import org.sourceid.oauth20.protocol.ResponseType;
import org.sourceid.openid.connect.profiles.sp.OIDCRequestParamHandler;
import org.sourceid.openid.connect.util.OIDCUtil;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.adapter.idp.authn.AuthnPolicy;
import org.sourceid.saml20.domain.AttrLookupException;
import org.sourceid.saml20.domain.AttrMappingValue;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.AuthorizationException;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.OIDCProfile;
import org.sourceid.saml20.domain.OIDCRequestParamSetting;
import org.sourceid.saml20.domain.OIDCSettings;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.TrackedHttpParamManager;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.local.MetadataLocal;
import org.sourceid.saml20.metadata.local.MetadataLocalHelper;
import org.sourceid.util.AuthenticationContextUtil;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.websso.profiles.sp.SSOStarter;
import org.sourceid.websso.wrapper.OutMessageContext;

public class CreateOidcAuthnRequest
implements SSOStarter {
    protected final Log log = LogFactory.getLog(this.getClass());
    private final MetadataLocal localMetaData = MetaDataFactory.getLocalMetaData();
    private final ConfigStore config = ConfigStoreFarm.getConfig("org.sourceid.openid.connect.profiles.sp.CreateOidcAuthnRequest");
    private final boolean includeJtiInSignedRequestObject = this.config.getBooleanValue("IncludeJtiInSignedRequestObject", true);

    @Override
    public OutMessageContext startSso(HttpServletRequest req, HttpServletResponse resp, OutMessageContext ctx, IdpConnection idpConn, AuthnPolicy authnPolicy) {
        if (idpConn.getOidcSettings() == null) {
            throw new ProcessRuntimeException("The IdP connection " + idpConn.getEntityId() + " does not have OIDC enabled");
        }
        CharSequence[] authnCtxClassRefs = authnPolicy.getRequestAuthnContexts().toArray(new String[authnPolicy.getRequestAuthnContexts().size()]);
        AuthenticationContextUtil.performLocalToRemoteMapping(idpConn, (String[])authnCtxClassRefs);
        String acrValues = null;
        if (authnCtxClassRefs != null && authnCtxClassRefs.length > 0) {
            acrValues = String.join((CharSequence)" ", authnCtxClassRefs);
        }
        String nonce = IDGenerator.rndAlphaNumeric(22);
        String ssoRedirectUri = OIDCUtil.getRuntimeRedirectUri(idpConn.getEntityId());
        OIDCSettings settings = idpConn.getOidcSettings();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(Parameters.SCOPE, settings.getScopes().getScopeStr());
        if (settings.getProfile() == OIDCProfile.BASIC) {
            params.put("response_type", "code");
            this.handlePKCE(settings, params, ctx);
        } else if (settings.getProfile() == OIDCProfile.IMPLICIT) {
            params.put("response_type", "id_token");
            params.put("response_mode", (Object)ResponseType.ResponseMode.form_post);
        } else if (settings.getProfile() == OIDCProfile.IMPLICIT_ACCESS) {
            params.put("response_type", "id_token token");
            params.put("response_mode", (Object)ResponseType.ResponseMode.form_post);
        }
        if (OIDCSettings.JARM_QUERY_JWT.equals(settings.getJwtSecuredAuthorizationResponseModeType())) {
            params.put("response_mode", (Object)ResponseType.ResponseMode.query_jwt);
        } else if (OIDCSettings.JARM_FORM_POST_JWT.equals(settings.getJwtSecuredAuthorizationResponseModeType())) {
            params.put("response_mode", (Object)ResponseType.ResponseMode.form_post_jwt);
        }
        params.put(Parameters.CLIENT_ID, settings.getClientId());
        params.put("redirect_uri", ssoRedirectUri);
        params.put("nonce", nonce);
        if (authnPolicy.reauthenticate()) {
            params.put("prompt", "login");
        }
        if (!authnPolicy.allowUserInteraction()) {
            Object prompt = (String)params.get("prompt");
            prompt = StringUtils.isNotBlank((String)prompt) ? (String)prompt + " none" : "none";
            params.put("prompt", prompt);
        }
        if (authnPolicy.registrationRequested()) {
            params.put("prompt", "create");
        }
        if (acrValues != null) {
            params.put("acr_values", acrValues);
        }
        if (ctx.getRequestedUserId() != null) {
            params.put("login_hint", ctx.getRequestedUserId());
        }
        if (StringUtils.isNotBlank((String)settings.getRequestSigningAlgorithm()) && this.includeJtiInSignedRequestObject) {
            String jti = IDGenerator.rndAlphaNumeric(22);
            params.put("jti", jti);
        }
        this.handleCustomRequestParams(req, resp, settings, params, ctx);
        ctx.setParams(params);
        TrackedHttpParamManager paramMgr = MgmtFactory.getTrackedHttpParamManager();
        if (paramMgr.isMaskTrackedParams()) {
            for (String trackedParam : paramMgr.getTrackedParamSettings().getTrackedParamNames()) {
                ctx.setMaskedParamName(trackedParam);
            }
        }
        return ctx;
    }

    private void handlePKCE(OIDCSettings settings, Map<String, Object> params, OutMessageContext outMessageContext) {
        if (settings.isEnableProofKeyForCodeExchange()) {
            String codeVerifier = Base64Url.encode((byte[])IDGenerator.generateBytes(32));
            byte[] hashedChallenge = HashUtil.hashToBytes((String)codeVerifier, (HashAlgorithm)HashAlgorithm.SHA256);
            params.put("code_challenge", Base64Url.encode((byte[])hashedChallenge));
            params.put("code_challenge_method", "S256");
            outMessageContext.setSupplementalContext("code_verifier", codeVerifier);
        }
    }

    private void handleCustomRequestParams(HttpServletRequest req, HttpServletResponse resp, OIDCSettings settings, Map<String, Object> params, OutMessageContext ctx) {
        String loginHint;
        Map<String, String[]> queryParams;
        Map trackedParams = null;
        if (req.getRequestURI().endsWith("/sp/init_login.ping")) {
            queryParams = this.handleThirdPartyLogin(req);
        } else {
            queryParams = new HashMap<String, String[]>(req.getParameterMap());
            Object trackedParamsObject = ctx.getSupplementalContext("pf.TrackedHttpParams");
            if (trackedParamsObject != null) {
                trackedParams = (Map)trackedParamsObject;
                trackedParams.forEach((key, value) -> queryParams.put((String)key, value.toArray(new String[0])));
            }
        }
        List<OIDCRequestParamSetting> reqParamsWhiteList = settings.getRequestParams();
        if (reqParamsWhiteList != null && !reqParamsWhiteList.isEmpty()) {
            for (OIDCRequestParamSetting param : reqParamsWhiteList) {
                if ((!params.containsKey(param.getName()) || param.getValue() == null || !StringUtils.isNotEmpty((String)param.getValue().getValue())) && !this.isOverride(queryParams, param, req)) continue;
                params.remove(param.getName());
            }
            OIDCRequestParamHandler requestParamHandler = new OIDCRequestParamHandler(reqParamsWhiteList);
            HashMap<String, AttributeMap> sourceAttrs = requestParamHandler.getAttributeMappingSubstitutions(req, resp, trackedParams);
            for (OIDCRequestParamSetting param : reqParamsWhiteList) {
                AttributeMap result;
                if (queryParams != null && this.isOverride(queryParams, param, req)) {
                    String[] values = queryParams.get(param.getName());
                    ArrayList<String> paramValues = new ArrayList<String>();
                    for (String value2 : values) {
                        if (!StringUtils.isNotEmpty((String)value2)) continue;
                        paramValues.add(value2);
                    }
                    if (paramValues.size() == 1) {
                        params.put(param.getName(), paramValues.get(0));
                        continue;
                    }
                    params.put(param.getName(), paramValues.toArray(new String[0]));
                    continue;
                }
                if (!StringUtils.isNotEmpty((String)param.getValue().getValue())) continue;
                AttributeMapping tmp = new AttributeMapping();
                String paramName = param.getName();
                AttrMappingValue mappingValue = param.getValue();
                tmp.putAttributeMapping(paramName, Arrays.asList(mappingValue));
                try {
                    result = tmp.executeMapping(sourceAttrs, null);
                }
                catch (AttrLookupException | AuthorizationException e) {
                    throw new ProcessRuntimeException(e);
                }
                AttributeValue resultantValue = (AttributeValue)result.get((Object)paramName);
                if (resultantValue == null || resultantValue.getValue() == null) continue;
                if (resultantValue.isMultiValue()) {
                    this.addReqParamValues(param.getName(), resultantValue.getValuesAsCollection(), params);
                    continue;
                }
                this.addReqParamValue(param.getName(), resultantValue.getValue(), params);
            }
        }
        if (StringUtils.isNotEmpty((String)(loginHint = this.getFirstParamValue(params, "login_hint")))) {
            ctx.setRequestedUserId(loginHint);
            params.put("login_hint", loginHint);
        }
    }

    private Map<String, String[]> handleThirdPartyLogin(HttpServletRequest req) {
        HashMap<String, String[]> queryParams = new HashMap<String, String[]>();
        queryParams.put("iss", new String[]{req.getParameter("iss")});
        if (StringUtils.isNotEmpty((String)req.getParameter("login_hint"))) {
            queryParams.put("login_hint", new String[]{req.getParameter("login_hint")});
        }
        return queryParams;
    }

    private boolean isOverride(Map<String, String[]> queryParams, OIDCRequestParamSetting param, HttpServletRequest req) {
        return param.isOverride() != false && queryParams.containsKey(param.getName());
    }

    private String getFirstParamValue(Map<String, Object> params, String item) {
        String[] values;
        if (params.get(item) instanceof String[] && (values = (String[])params.get(item)) != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    private String getStartSSOURL() {
        return MetadataLocalHelper.getSpInitiateSsoPath(this.localMetaData);
    }

    private void addReqParamValues(String name, Collection<String> values, Map<String, Object> params) {
        if (values == null || values.isEmpty()) {
            return;
        }
        if (params.containsKey(name) && params.get(name) != null) {
            Object[] existingReqParamValues = this.getExistingReqParamValues(name, params);
            if (existingReqParamValues != null) {
                String[] paramArray = (String[])ArrayUtils.addAll((Object[])existingReqParamValues, (Object[])values.toArray(new String[values.size()]));
                params.put(name, paramArray);
            }
        } else {
            params.put(name, values.toArray(new String[values.size()]));
        }
    }

    private String[] getExistingReqParamValues(String name, Map<String, Object> params) {
        String[] existingValues = null;
        if (params.get(name) instanceof String) {
            existingValues = new String[]{(String)params.get(name)};
        } else {
            try {
                existingValues = (String[])params.get(name);
            }
            catch (ClassCastException e) {
                this.log.error((Object)("Unable to cast the OIDC custom parameters." + e.getMessage()));
            }
        }
        return existingValues;
    }

    private void addReqParamValue(String name, String value, Map<String, Object> params) {
        if (params.containsKey(name)) {
            String[] existingReqParamValues = this.getExistingReqParamValues(name, params);
            if (existingReqParamValues != null) {
                String[] paramArray = new String[existingReqParamValues.length + 1];
                System.arraycopy(existingReqParamValues, 0, paramArray, 0, existingReqParamValues.length);
                paramArray[paramArray.length - 1] = value;
                params.put(name, paramArray);
            }
        } else {
            params.put(name, value);
        }
    }
}

