/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.openid.connect.profiles.sp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.Predicate;
import javax.servlet.http.HttpServletRequest;
import org.sourceid.oauth20.protocol.Parameters;
import org.sourceid.openid.connect.util.OIDCUtil;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.profiles.idp.SLOSupport;
import org.sourceid.saml20.service.IdpConnHashableAuthnBean;
import org.sourceid.saml20.service.IdpHashableAuthnBean;
import org.sourceid.util.BaseUrlUtil;
import org.sourceid.websso.Protocol;
import org.sourceid.websso.profiles.LogoutProcessor;
import org.sourceid.websso.wrapper.OutMessageContext;

public class OidcLogoutProcessor
implements LogoutProcessor {
    private SLOSupport sloSupport = new SLOSupport(MetaDataFactory.getLocalMetaData());

    @Override
    public Collection<IdpConnHashableAuthnBean> gatherBeansForLogoutRequest(Collection<IdpConnHashableAuthnBean> beans, String initiatorEntityId, Predicate<IdpConnection> filter) {
        IssuerAndSubject initialIssuerAndSubject = null;
        ArrayList<IdpConnHashableAuthnBean> result = new ArrayList<IdpConnHashableAuthnBean>();
        for (IdpConnHashableAuthnBean idpConnBean : this.gatherProtocolBeans(beans)) {
            IdpConnection idpConn;
            if (!idpConnBean.isDoLogout() || (idpConn = this.getIdpConnection(idpConnBean)).getOidcSettings().getLogoutEndpoint() == null || !filter.test(idpConn) || initiatorEntityId != null && idpConn.getEntityId().equals(initiatorEntityId)) continue;
            IssuerAndSubject issuerAndSubject = new IssuerAndSubject(idpConnBean.getIssuer(), idpConnBean.getSubject());
            if (initialIssuerAndSubject == null) {
                result.add(idpConnBean);
                initialIssuerAndSubject = issuerAndSubject;
                continue;
            }
            if (!issuerAndSubject.equals(initialIssuerAndSubject)) continue;
            result.add(idpConnBean);
        }
        return result;
    }

    @Override
    public OutMessageContext createLogoutRequest(Collection<IdpConnHashableAuthnBean> beans, String binding, HttpServletRequest req) {
        if (beans.isEmpty()) {
            throw new IllegalArgumentException("No beans provided");
        }
        IdpConnHashableAuthnBean beanToUse = beans.stream().max(Comparator.comparing(IdpHashableAuthnBean::getCreationTimeMillis)).orElse(null);
        OutMessageContext outMsgCtx = new OutMessageContext(Role.SP);
        IdpConnection idpConnection = this.getIdpConnection(beanToUse);
        outMsgCtx.setEntityId(idpConnection.getEntityId());
        outMsgCtx.setBinding("oidc:rp:initiated:logout");
        outMsgCtx.setEndpoint(idpConnection.getOidcSettings().getLogoutEndpoint().getFullLocation());
        outMsgCtx.setParam(Parameters.CLIENT_ID, idpConnection.getOidcSettings().getClientId());
        if (beanToUse.getIdToken() != null) {
            outMsgCtx.setParam("id_token_hint", beanToUse.getIdToken());
        }
        String postLogoutRedirectUri = BaseUrlUtil.getCurrentBaseUrl(OIDCUtil.getPostLogoutRedirectUri());
        outMsgCtx.setParam("post_logout_redirect_uri", postLogoutRedirectUri);
        this.sloSupport.securityAuditLogForOidc(beanToUse);
        return outMsgCtx;
    }

    @Override
    public void invalidateBeans(Collection<IdpConnHashableAuthnBean> beans) {
    }

    protected Collection<IdpConnHashableAuthnBean> gatherProtocolBeans(Collection<IdpConnHashableAuthnBean> beans) {
        ArrayList<IdpConnHashableAuthnBean> result = new ArrayList<IdpConnHashableAuthnBean>();
        for (IdpConnHashableAuthnBean idpConnBean : beans) {
            IdpConnection idpConn = MetaDataFactory.getMetadataDirectory().getIdpConnectionBySystemId(idpConnBean.getAuthnSourceKey().getId(), false);
            if (idpConn == null || idpConn.getProtocol() != Protocol.OIDC) continue;
            result.add(idpConnBean);
        }
        return result;
    }

    private IdpConnection getIdpConnection(IdpConnHashableAuthnBean idpConnBean) {
        return MetaDataFactory.getMetadataDirectory().getIdpConnectionBySystemId(idpConnBean.getAuthnSourceKey().getId(), true);
    }

    private static class IssuerAndSubject {
        private final String issuer;
        private final String subject;

        public IssuerAndSubject(String issuer, String subject) {
            this.issuer = issuer;
            this.subject = subject;
        }

        public String getIssuer() {
            return this.issuer;
        }

        public String getSubject() {
            return this.subject;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IssuerAndSubject that = (IssuerAndSubject)o;
            if (!Objects.equals(this.issuer, that.issuer)) {
                return false;
            }
            return Objects.equals(this.subject, that.subject);
        }

        public int hashCode() {
            int result = this.issuer != null ? this.issuer.hashCode() : 0;
            result = 31 * result + (this.subject != null ? this.subject.hashCode() : 0);
            return result;
        }
    }
}

