/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.openid.connect.profiles.sp;

import com.pingidentity.common.util.Base64URL;
import java.util.Arrays;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.consumer.JwtContext;
import org.jose4j.jwt.consumer.Validator;
import org.jose4j.jwx.JsonWebStructure;
import org.sourceid.openid.connect.LeftHalfHash;

public class SHashValidator
implements Validator {
    String state;

    public SHashValidator(String state) {
        this.state = state;
    }

    public String validate(JwtContext jwtContext) throws MalformedClaimException {
        boolean statePresent;
        JwtClaims claims = jwtContext.getJwtClaims();
        boolean hasClaim = claims.hasClaim("s_hash");
        boolean bl = statePresent = this.state != null;
        if (hasClaim) {
            JsonWebStructure jws;
            String alg;
            byte[] calculated;
            if (!statePresent) {
                return "s_hash in the ID token but no state present.";
            }
            String sHashString = claims.getStringClaimValue("s_hash");
            byte[] sHash = Base64URL.decode((String)sHashString);
            if (!Arrays.equals(sHash, calculated = LeftHalfHash.leftHalfHashToBytes(this.state, alg = (jws = (JsonWebStructure)jwtContext.getJoseObjects().get(0)).getAlgorithmHeaderValue()))) {
                return "s_hash does not match the value calculated from the state hash: " + Base64URL.encodeToString((byte[])calculated);
            }
        }
        return null;
    }
}

