/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.openid.connect.rp;

import com.pingidentity.crypto.jws.JwsSignatureUtil;
import java.security.Key;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jose4j.jwa.AlgorithmConstraints;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.lang.JoseException;
import org.sourceid.oauth20.protocol.Parameters;
import org.sourceid.openid.connect.domain.OIDCProviderConnection;
import org.sourceid.openid.connect.rp.OIDCProtocolAuthProcessor;
import org.sourceid.websso.profiles.ProcessRuntimeException;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public class PingOneOIDCProtocolProcessor
extends OIDCProtocolAuthProcessor {
    private OIDCProviderConnection providerConnection;

    public PingOneOIDCProtocolProcessor(OIDCProviderConnection providerConnection) {
        super(providerConnection);
        this.providerConnection = providerConnection;
    }

    @Override
    public OutMessageContext makeAuthnRequest(String ssoRedirectUri, String state, String nonce) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(Parameters.SCOPE, StringUtils.join(Arrays.asList("openid", "profile"), (String)" "));
        params.put("response_type", "id_token");
        this.populateCommonRequestParam(ssoRedirectUri, state, nonce, params);
        String requestObject = this.makeRequestObject(params);
        OutMessageContext outContext = new OutMessageContext();
        outContext.setEndpoint(this.providerConnection.getAuthorizationEndpoint());
        this.populateCodeChallenge(params, this.providerConnection.isEnableProofKeyForCodeExchange(), outContext);
        for (Map.Entry entry : params.entrySet()) {
            outContext.setParam((String)entry.getKey(), entry.getValue());
        }
        outContext.setRelayState(state);
        outContext.setParam("request", requestObject);
        return outContext;
    }

    private String makeRequestObject(Map<String, Object> params) {
        try {
            JwtClaims claims = new JwtClaims();
            claims.setIssuer(this.providerConnection.getClientId());
            claims.setAudience(this.providerConnection.getProviderId());
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                claims.setStringClaim(entry.getKey(), String.valueOf(entry.getValue()));
            }
            JsonWebSignature jws = new JsonWebSignature();
            jws.setPayload(claims.toJson());
            jws.setKey((Key)this.providerConnection.getSigningKeyPair().getPrivateKey());
            jws.setKeyIdHeaderValue(this.providerConnection.getSigningKeyPair().getAlias());
            jws.setAlgorithmHeaderValue("RS256");
            JwsSignatureUtil.applyProviderOverrideContextIfNeeded(jws, this.providerConnection.getSigningKeyPair());
            return jws.getCompactSerialization();
        }
        catch (JoseException e) {
            throw new ProcessRuntimeException("Failed to construct OIDC authentication request object: " + e, e);
        }
    }

    @Override
    protected JwtClaims getJwtClaims(String idToken) throws InvalidJwtException {
        JwtConsumer jwtConsumer = new JwtConsumerBuilder().setRequireExpirationTime().setAllowedClockSkewInSeconds(this.providerConnection.getAllowedClockSkewSecs()).setRequireSubject().setExpectedIssuer(this.providerConnection.getProviderId()).setExpectedAudience(new String[]{this.providerConnection.getClientId()}).setVerificationKeyResolver(this.providerConnection.getVerificationKeyResolver()).setJwsAlgorithmConstraints(new AlgorithmConstraints(AlgorithmConstraints.ConstraintType.WHITELIST, new String[]{"RS256"})).build();
        JwtClaims jwtClaims = jwtConsumer.processToClaims(idToken);
        return jwtClaims;
    }

    @Override
    protected String getState(InMessageContext inContext) {
        return inContext.getParam("state");
    }
}

