/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.openid.connect.service.impl;

import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.jose4j.base64url.Base64Url;
import org.jose4j.jwe.kdf.KdfUtil;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.keys.AesKey;
import org.jose4j.lang.ByteUtil;
import org.jose4j.lang.JoseException;
import org.jose4j.lang.StringUtil;
import org.jose4j.mac.MacUtil;
import org.sourceid.openid.connect.service.PairwisePseudonymService;
import org.sourceid.openid.connect.service.impl.PairwisePseudonymServiceException;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class PairwisePseudonymServiceAESImpl
implements PairwisePseudonymService {
    private static final int ENC_KEY_LENGTH = 128;
    private static final int MAC_KEY_LENGTH = 256;
    private static final int TAG_LENGTH = 9;
    private static final int IV_LENGTH = 16;
    private static final String CIPHER_ALG = "AES/CBC/PKCS5Padding";
    private static final String MAC_ALG = "HmacSHA256";
    private static final String PPID_QUALIFIER = "PPID";
    private static final String ENC_QUALIFIER = "enc";
    private static final String MAC_QUALIFIER = "mac";

    @Override
    public String toPPID(String subject, String sectorIdentifier) throws PairwisePseudonymServiceException {
        try {
            byte[] sectorBytes = StringUtil.getBytesUtf8((String)sectorIdentifier);
            byte[] subjectBytes = StringUtil.getBytesUtf8((String)subject);
            JsonWebKey pfJwk = (JsonWebKey)MgmtFactory.getMasterKeySet().getJsonWebKeySet().getJsonWebKeys().get(0);
            byte[] mainKey = pfJwk.getKey().getEncoded();
            KdfUtil kdf = new KdfUtil();
            byte[] derivedEncryptionKey = kdf.kdf(mainKey, 128, CIPHER_ALG, ENC_QUALIFIER, PPID_QUALIFIER);
            byte[] derivedMacKey = kdf.kdf(mainKey, 256, MAC_ALG, MAC_QUALIFIER, PPID_QUALIFIER);
            Mac mac = MacUtil.getInitializedMac((String)MAC_ALG, (Key)new SecretKeySpec(derivedMacKey, "HMAC"));
            byte[] macOverSectorAndSub = mac.doFinal(ByteUtil.concat((byte[][])new byte[][]{sectorBytes, subjectBytes}));
            IvParameterSpec ivSpec = new IvParameterSpec(macOverSectorAndSub, 0, 16);
            Cipher cipher = Cipher.getInstance(CIPHER_ALG);
            cipher.init(1, (Key)new AesKey(derivedEncryptionKey), ivSpec);
            byte[] cipherTextBytes = cipher.doFinal(subjectBytes);
            byte[] iv = ivSpec.getIV();
            byte[] macOverCipherTextAndIv = mac.doFinal(ByteUtil.concat((byte[][])new byte[][]{cipherTextBytes, iv}));
            byte[] tag = ByteUtil.subArray((byte[])macOverCipherTextAndIv, (int)0, (int)9);
            byte[] ppidBytes = ByteUtil.concat((byte[][])new byte[][]{iv, cipherTextBytes, tag});
            return Base64Url.encode((byte[])ppidBytes);
        }
        catch (GeneralSecurityException | JoseException e) {
            throw new PairwisePseudonymServiceException(e);
        }
    }

    @Override
    public String fromPPID(String ppid) throws PairwisePseudonymServiceException {
        String subject = null;
        try {
            byte[] ppidBytes = Base64Url.decode((String)ppid);
            byte[] iv = ByteUtil.subArray((byte[])ppidBytes, (int)0, (int)16);
            KdfUtil kdf = new KdfUtil();
            JsonWebKey pfJwk = (JsonWebKey)MgmtFactory.getMasterKeySet().getJsonWebKeySet().getJsonWebKeys().get(0);
            byte[] mainKey = pfJwk.getKey().getEncoded();
            byte[] derivedEncryptionKey = kdf.kdf(mainKey, 128, CIPHER_ALG, ENC_QUALIFIER, PPID_QUALIFIER);
            byte[] derivedMacKey = kdf.kdf(mainKey, 256, MAC_ALG, MAC_QUALIFIER, PPID_QUALIFIER);
            Cipher cipher = Cipher.getInstance(CIPHER_ALG);
            cipher.init(2, (Key)new AesKey(derivedEncryptionKey), new IvParameterSpec(iv));
            int cipherTextLength = ppidBytes.length - 25;
            byte[] cipherTextBytes = ByteUtil.subArray((byte[])ppidBytes, (int)16, (int)cipherTextLength);
            byte[] tag = ByteUtil.subArray((byte[])ppidBytes, (int)(cipherTextLength + 16), (int)9);
            Mac mac = MacUtil.getInitializedMac((String)MAC_ALG, (Key)new SecretKeySpec(derivedMacKey, "HMAC"));
            byte[] macOverCipherTextAndIv = mac.doFinal(ByteUtil.concat((byte[][])new byte[][]{cipherTextBytes, iv}));
            if (ByteUtil.secureEquals((byte[])tag, (byte[])ByteUtil.subArray((byte[])macOverCipherTextAndIv, (int)0, (int)9))) {
                try {
                    byte[] clearTextBytes = cipher.doFinal(cipherTextBytes);
                    subject = StringUtil.newStringUtf8((byte[])clearTextBytes);
                }
                catch (BadPaddingException | IllegalBlockSizeException generalSecurityException) {
                    // empty catch block
                }
            }
            return subject;
        }
        catch (ArrayIndexOutOfBoundsException | GeneralSecurityException | JoseException e) {
            throw new PairwisePseudonymServiceException(e);
        }
    }
}

