/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.openid.connect.util;

import java.util.Set;
import java.util.stream.Stream;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.consumer.ErrorCodeValidator;
import org.jose4j.jwt.consumer.IssValidator;
import org.jose4j.jwt.consumer.JwtContext;

public final class OidcJwtRpIssuerValidator
extends IssValidator {
    private static final String GOOGLE_ISSUER = "accounts.google.com";
    private static final String HTTPS = "https://";
    private final String expectedIssuer;

    public OidcJwtRpIssuerValidator(String expectedIssuer, Set<String> expectedAdditionalIssuers, boolean isAcceptAllIssuers) {
        super(!isAcceptAllIssuers, isAcceptAllIssuers ? null : OidcJwtRpIssuerValidator.getIssuersArray(expectedIssuer, expectedAdditionalIssuers));
        this.expectedIssuer = expectedIssuer;
    }

    private static String[] getIssuersArray(String expectedIssuer, Set<String> expectedAdditionalIssuers) {
        return (String[])Stream.concat(Stream.of(expectedIssuer), expectedAdditionalIssuers.stream()).toArray(String[]::new);
    }

    public ErrorCodeValidator.Error validate(JwtContext jwtContext) throws MalformedClaimException {
        if (this.expectedIssuer.contains(GOOGLE_ISSUER)) {
            Object issuer = jwtContext.getJwtClaims().getIssuer();
            if (issuer != null && !((String)issuer).startsWith(HTTPS)) {
                issuer = HTTPS + (String)issuer;
            }
            if (issuer == null) {
                return new ErrorCodeValidator.Error(11, "No Issuer (iss) claim present but was expecting " + this.expectedIssuer);
            }
            if (!((String)issuer).equals(this.expectedIssuer)) {
                return new ErrorCodeValidator.Error(12, "Issuer (iss) claim value (" + (String)issuer + ") doesn't match expected value of " + this.expectedIssuer);
            }
            return null;
        }
        return super.validate(jwtContext);
    }
}

