/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml1x.bindings;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.bindings.Binding;
import org.sourceid.saml20.bindings.BindingException;
import org.sourceid.saml20.bindings.RelayStateSupport;
import org.sourceid.saml20.dsig.SignatureEngine;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.metadata.partner.MetadataDirectory;
import org.sourceid.servlet.ServletExceptionSupport;
import org.sourceid.websso.servlet.RedirectException;
import org.sourceid.websso.servlet.RenderPageException;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

abstract class BaseBrowserBinding
implements Binding {
    final MetadataDirectory metadataDirectory = MetaDataFactory.getMetadataDirectory();
    final SignatureEngine signatureSvc = GlobalRegistry.getService(SignatureEngine.class);
    final Log log = LogFactory.getLog(this.getClass());
    private RelayStateSupport relayStateSupport = new RelayStateSupport();

    BaseBrowserBinding() {
    }

    abstract void completeReceive(InMessageContext var1, HttpServletRequest var2, HttpServletResponse var3) throws IOException, BindingException, RedirectException, RenderPageException;

    @Override
    public InMessageContext transportRequest(HttpServletRequest req, HttpServletResponse resp, OutMessageContext msgCtx) throws IOException, BindingException {
        throw new UnsupportedOperationException("Nope");
    }

    @Override
    public InMessageContext receive(HttpServletRequest request, HttpServletResponse response, Role partnerRole) throws IOException, BindingException, RedirectException, RenderPageException {
        InMessageContext inMsgCtx = new InMessageContext(partnerRole);
        inMsgCtx.setIsRequest(false);
        try {
            this.completeReceive(inMsgCtx, request, response);
            String targetParam = request.getParameter("TARGET");
            if (StringUtils.isBlank((String)targetParam)) {
                throw new BindingException("TARGET parameter must be specified.");
            }
            inMsgCtx.setTargetResource(targetParam);
        }
        catch (BindingException e) {
            inMsgCtx.setDeferredException(e);
        }
        this.relayStateSupport.lookupAssociationViaSessionId(inMsgCtx, request, response);
        return inMsgCtx;
    }

    @Override
    public void handleException(HttpServletRequest req, HttpServletResponse resp, Exception e) throws ServletException, IOException {
        ServletExceptionSupport.throwServletException(e);
    }

    @Override
    public boolean isBackChannel() {
        return false;
    }

    @Override
    public boolean isEntityIdRequired() {
        return true;
    }
}

