/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml1x.bindings;

import com.pingidentity.common.util.B64;
import com.pingidentity.common.util.xml.XmlBeansUtil;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.protocol.saml11.xml.AssertionType;
import org.sourceid.protocol.samlp11.xml.ResponseDocument;
import org.sourceid.protocol.samlp11.xml.ResponseType;
import org.sourceid.saml1x.bindings.BaseBrowserBinding;
import org.sourceid.saml20.bindings.BindingException;
import org.sourceid.saml20.domain.DomainMode;
import org.sourceid.saml20.util.VirtualIdentityUtil;
import org.sourceid.util.ResourceEvaluator;
import org.sourceid.websso.bindings.FormPost;
import org.sourceid.websso.wrapper.BaseMessageContext;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public class BrowserPost
extends BaseBrowserBinding {
    private final ResourceEvaluator resourceEvaluator = new ResourceEvaluator();

    @Override
    public void transportResponse(HttpServletRequest request, HttpServletResponse response, OutMessageContext msgCtx) throws IOException, BindingException {
        XmlObject xmlObject = msgCtx.getXmlObject();
        ResponseDocument respDoc = (ResponseDocument)xmlObject;
        ResponseType responseType = respDoc.getResponse();
        responseType.setRecipient(msgCtx.getEndpoint());
        this.signatureSvc.signXml(msgCtx);
        String endpoint = msgCtx.getEndpoint();
        LinkedHashMap<String, String> controls = new LinkedHashMap<String, String>();
        byte[] bytes = XmlBeansUtil.xmlText(xmlObject).getBytes("UTF-8");
        String b64Xml = B64.encode((byte[])bytes);
        controls.put("SAMLResponse", b64Xml);
        String target = msgCtx.getTargetResource();
        if (!StringUtils.isBlank((String)target)) {
            controls.put("TARGET", target);
        }
        FormPost.post(endpoint, controls, request, response);
    }

    @Override
    void completeReceive(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp) throws BindingException, IOException {
        String b64xml = req.getParameter("SAMLResponse");
        byte[] bytes = B64.decodeToBytes((String)b64xml);
        String xmlString = new String(bytes, "UTF-8");
        if (xmlString == null) {
            String msg = "Unable to base64 decode SAMLResponse";
            this.log.debug((Object)(msg + "=" + b64xml));
            throw new BindingException(msg);
        }
        try {
            ResponseDocument respDoc = XmlBeansUtil.parse(xmlString, ResponseDocument.class);
            inMsgCtx.setXmlObject((XmlObject)respDoc);
            String issuer = this.identifyPartner(respDoc, inMsgCtx);
            inMsgCtx.setEntityId(issuer);
            String virtualServerId = VirtualIdentityUtil.resolve((BaseMessageContext)inMsgCtx, req).getVirtualEntityId(DomainMode.RUNTIME);
            inMsgCtx.setVirtualServerId(virtualServerId);
            this.signatureSvc.verifyXmlSignature(inMsgCtx, true);
            ResponseType response = respDoc.getResponse();
            if (response.isSetRecipient()) {
                String requestUrlStr = req.getRequestURL().toString();
                String recipient = response.getRecipient();
                ResourceEvaluator.Result matchResult = this.resourceEvaluator.isResourceMatch(recipient, requestUrlStr);
                if (!matchResult.isMatch()) {
                    throw new BindingException("Recipient mismatch in response document: " + matchResult.getMessage());
                }
            } else {
                String msg = "Post profile requires that Recipient be included in the response document: " + inMsgCtx;
                throw new BindingException(msg);
            }
            if (response.isSetInResponseTo()) {
                String inResponseTo = response.getInResponseTo();
                throw new BindingException("InResponseTo element present in post profile " + inResponseTo);
            }
        }
        catch (XmlException e) {
            String msg = "Unable to parse response (encoded): " + b64xml;
            throw new BindingException(msg, e);
        }
    }

    private String identifyPartner(ResponseDocument respDoc, InMessageContext inMsgCtx) throws BindingException {
        ResponseType response = respDoc.getResponse();
        int numAssertions = response.sizeOfAssertionArray();
        if (numAssertions == 0) {
            throw new BindingException("No assertions in response document");
        }
        HashSet<String> issuers = new HashSet<String>(numAssertions);
        for (AssertionType assertion : response.getAssertionArray()) {
            String issuer = assertion.getIssuer();
            issuers.add(issuer);
        }
        if (issuers.size() > 1) {
            throw new BindingException("Unable to accept assertions from multiple issuers: " + issuers + " in " + inMsgCtx);
        }
        return (String)issuers.iterator().next();
    }

    @Override
    public String getUri() {
        return "urn:oasis:names:tc:SAML:1.0:profiles:browser-post";
    }
}

