/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml1x.bindings;

import com.pingidentity.common.util.xml.InvalidXmlException;
import com.pingidentity.common.util.xml.XmlBeansUtil;
import java.io.IOException;
import java.net.URL;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.auth.Authenticator;
import org.sourceid.common.soap.InvalidRequestException;
import org.sourceid.common.soap.soap11.SoapClient;
import org.sourceid.common.soap.soap11.SoapClientException;
import org.sourceid.common.soap.soap11.SoapEndpointUtility;
import org.sourceid.protocol.samlp11.xml.ResponseType;
import org.sourceid.saml20.bindings.BindingException;
import org.sourceid.saml20.bindings.SoapBindingWrappedException;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.websso.bindings.SoapBase;
import org.sourceid.websso.servlet.RedirectException;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public class Saml1xSoapBinding
extends SoapBase {
    @Override
    protected XmlObject sendRequest(String encodedIdForSoapStore, URL endpoint, OutMessageContext outMsgCtx, ConnectionBase conn) throws BindingException, IOException, SoapClientException, RedirectException {
        XmlObject protoResponse = SoapClient.sendRequest(encodedIdForSoapStore, endpoint, outMsgCtx.getXmlObject());
        if (!(protoResponse instanceof ResponseType)) {
            String localPart = protoResponse == null ? null : protoResponse.schemaType().getName().getLocalPart();
            String message = "Unknown or Invalid response to SAML 1.x request: " + localPart;
            this.log.warn((Object)message);
            throw new BindingException(message);
        }
        return protoResponse;
    }

    @Override
    protected String identifyPartner(HttpServletRequest req, HttpServletResponse resp, XmlObject xmlObjectType) throws LoginException, InvalidRequestException, XmlException {
        Authenticator.AuthnInfo authnInfo = Authenticator.authn(req, resp);
        String encodedId = authnInfo.getId();
        if (StringUtils.isBlank((String)encodedId)) {
            throw new LoginException("SOAP client is not properly authenticated " + authnInfo);
        }
        return Role.decodeToEntityId(encodedId);
    }

    @Override
    public InMessageContext receive(HttpServletRequest request, HttpServletResponse response, Role partnerRole) throws IOException, BindingException {
        InMessageContext inMsgCtx = super.receive(request, response, partnerRole);
        inMsgCtx.setIsRequest(true);
        XmlObject xmlObject = inMsgCtx.getXmlObject();
        try {
            XmlBeansUtil.validate(xmlObject);
        }
        catch (InvalidXmlException e) {
            throw new SoapBindingWrappedException(e, SoapEndpointUtility.CLIENT_FAULT_CODE);
        }
        return inMsgCtx;
    }

    @Override
    public String getUri() {
        return "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding";
    }
}

