/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml1x.profiles.ap;

import java.io.IOException;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.ThreadContext;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.common.Util;
import org.sourceid.common.dsig.SigningException;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.protocol.saml11.xml.AssertionType;
import org.sourceid.protocol.samlp11.xml.ResponseDocument;
import org.sourceid.protocol.samlp11.xml.ResponseType;
import org.sourceid.saml1x.profiles.ap.ProfileSupport;
import org.sourceid.saml1x.protocol.AssertionAssembler;
import org.sourceid.saml1x.protocol.ConfirmationMethodIdentifiers;
import org.sourceid.saml1x.protocol.StatusCodeException;
import org.sourceid.saml1x.protocol.TopLevelStatusCode;
import org.sourceid.saml1x.protocol.VersionSupport;
import org.sourceid.saml20.adapter.GeneralAdapterException;
import org.sourceid.saml20.adapter.attribute.AttrValueSupport;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.adapter.idp.authn.AuthnPolicy;
import org.sourceid.saml20.domain.AuthorizationException;
import org.sourceid.saml20.domain.DomainMode;
import org.sourceid.saml20.domain.Endpoints;
import org.sourceid.saml20.domain.IndexedEndpoints;
import org.sourceid.saml20.domain.MessageCustomization;
import org.sourceid.saml20.domain.SourceContextType;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.profiles.BindingEndptChooser;
import org.sourceid.saml20.profiles.idp.AuthnSourceSupport;
import org.sourceid.saml20.protocol.AssertionMapKeys;
import org.sourceid.saml20.service.GeneralServiceException;
import org.sourceid.saml20.service.PseudonymServiceException;
import org.sourceid.saml20.state.State;
import org.sourceid.saml20.util.VirtualIdentityUtil;
import org.sourceid.util.license.LicenseManager;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.AuditLogger;
import org.sourceid.websso.authn.AuthnProcessorException;
import org.sourceid.websso.profiles.RequestProcessingException;
import org.sourceid.websso.profiles.ResumableRequestHandlerBase;
import org.sourceid.websso.profiles.ResumeRequestFromAuthnResponseHandler;
import org.sourceid.websso.profiles.idp.FailedAuthnSsoException;
import org.sourceid.websso.profiles.idp.IdpAuditLogger;
import org.sourceid.websso.profiles.idp.IdpAuthenticationResult;
import org.sourceid.websso.profiles.idp.SSORespStarter;
import org.sourceid.websso.profiles.idp.SsoRespSupport;
import org.sourceid.websso.servlet.SessionIdUtil;
import org.sourceid.websso.wrapper.BaseMessageContext;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;
import org.sourceid.websso.wrapper.OutMessageContextUtil;
import org.sourceid.websso.wrapper.XmlMessageLogWrapper;

public class CreateResponse
extends ResumableRequestHandlerBase
implements SSORespStarter,
ResumeRequestFromAuthnResponseHandler {
    private final ProfileSupport profileSupport = new ProfileSupport();
    private final AssertionAssembler assertionAssembler = new AssertionAssembler();
    private final SsoRespSupport respSupport = new SsoRespSupport();
    private final AuthnSourceSupport adapterSupport = new AuthnSourceSupport();
    private final ConfigStore config = ConfigStoreFarm.getConfig(this.getClass());
    private static final AuthnPolicy AUTHN_POLICY = new AuthnPolicy(true, false);

    @Override
    public OutMessageContext process(InMessageContext msgCtx, HttpServletRequest req, HttpServletResponse resp, SpConnection sp, String target) throws IOException {
        msgCtx.setTargetResource(target);
        return this.process(msgCtx, req, resp);
    }

    @Override
    protected void handle(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, OutMessageContext outMsgCtx) throws IOException, RequestProcessingException {
        HashMap<String, Object> otherState = new HashMap<String, Object>();
        String entityId = inMsgCtx.getEntityId();
        SpConnection sp = this.metadataDirectory.getSpConnectionMetadata(entityId);
        String msg = VersionSupport.doVersionCheck(sp);
        if (msg != null) {
            throw new StatusCodeException(msg, TopLevelStatusCode.RESPONDER);
        }
        otherState.put("PartnerEntityId", entityId);
        this.resume(inMsgCtx, req, resp, outMsgCtx, otherState);
    }

    @Override
    protected void exeResume(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, OutMessageContext outMsgCtx, Map<String, Object> otherState) throws RequestProcessingException, IOException, GeneralAdapterException, GeneralServiceException {
        IdpAuthenticationResult authnResult;
        String resumePath = this.saveState(req, resp, inMsgCtx, outMsgCtx, otherState);
        try {
            authnResult = this.adapterSupport.lookupAuthNs(req, resp, AUTHN_POLICY, resumePath, otherState, inMsgCtx, outMsgCtx, this, false);
        }
        catch (AuthorizationException | AuthnProcessorException e) {
            throw new StatusCodeException("Unable to process the authentication", e, TopLevelStatusCode.RESPONDER);
        }
        AttributeValue authnMethodValue = null;
        if (authnResult != null) {
            authnMethodValue = this.respSupport.getAuthnCtxFromAuthnAttrs(authnResult.getAuthnAttrs(), authnResult.getAuthnBeans(), "urn:oasis:names:tc:SAML:1.0:am:unspecified");
            this.resumeSsoFromIdp(authnResult, req, resp, inMsgCtx, outMsgCtx, otherState, authnMethodValue);
        } else {
            this.resumeSsoFromIdp(authnResult, req, resp, inMsgCtx, outMsgCtx, otherState, null);
        }
    }

    @Override
    protected OutMessageContext getInitialOutMsgCtx(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp) {
        SpConnection sp = this.metadataDirectory.getSpConnectionMetadata(inMsgCtx.getEntityId());
        LicenseManager.checkLicenseForConnection(sp);
        OutMessageContext outMsgCtx = OutMessageContextUtil.buildDefaultSaml1xRespCtx(inMsgCtx, sp);
        IndexedEndpoints acsEndpoints = sp.getAssertionConsumerServiceEndpoints();
        BindingEndptChooser.doCheckBindingOverride(req, (Endpoints)acsEndpoints, outMsgCtx, "assertion consumer");
        return outMsgCtx;
    }

    @Override
    protected void handleEx(Exception e, InMessageContext inMsgCtx, OutMessageContext outMsgCtx, Map<String, Object> stateParams, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.log.info((Object)("Writing error response: " + e));
        this.profileSupport.handleEx(e, inMsgCtx, outMsgCtx, req, resp);
        this.respSupport.handleException(e, inMsgCtx, outMsgCtx, stateParams, req, resp, Role.IDP);
    }

    @Override
    protected boolean isStateAppropriate(State state) {
        OutMessageContext outMsgCtx = state.getOutMsgCtx();
        return outMsgCtx.getXmlObject() instanceof ResponseDocument;
    }

    @Override
    protected String getResumePathQualifier(OutMessageContext outMsgCtx) {
        SpConnection sp = this.metadataDirectory.getSpConnectionMetadata(outMsgCtx.getEntityId());
        return sp.getProtocol().toString();
    }

    @Override
    public void resumeSsoFromIdp(IdpAuthenticationResult authnResult, HttpServletRequest req, HttpServletResponse resp, InMessageContext inMsgCtx, OutMessageContext outMsgCtx, Map<String, Object> otherState, AttributeValue authnCtxValue) throws PseudonymServiceException, RequestProcessingException {
        if (!resp.isCommitted()) {
            if (authnResult == null || Util.isEmpty(authnResult.getAuthnAttrs())) {
                throw new StatusCodeException("Unable to authenticate the principal", new FailedAuthnSsoException(), TopLevelStatusCode.RESPONDER);
            }
            AttributeMap incomingAttrs = authnResult.getAuthnAttrs();
            if (incomingAttrs.get((Object)"TargetResource") == null && outMsgCtx.getTargetResource() != null && (outMsgCtx.getTargetResource().startsWith("http://") || outMsgCtx.getTargetResource().startsWith("https://"))) {
                incomingAttrs.put("TargetResource", new AttributeValue(outMsgCtx.getTargetResource()));
            }
            SpConnection sp = this.metadataDirectory.getSpConnectionMetadata(outMsgCtx.getEntityId());
            if (incomingAttrs != null && incomingAttrs.get((Object)"TargetResource") != null) {
                IdpAuditLogger.setAppUrl(((AttributeValue)incomingAttrs.get((Object)"TargetResource")).getValue());
            }
            IdpAuditLogger.setPartnerId(inMsgCtx.getEntityId());
            IdpAuditLogger.setProtocol(sp.getProtocol().toString());
            IdpAuditLogger.setAuthnSourceId(AuthnSourceSupport.getAuthnSourceKeys(authnResult.getAuthnBeans()));
            LinkedList authenticatingAuthorities = (LinkedList)otherState.get("authnAuthorityEntityIds");
            AttributeMap contextAttributes = new AttributeMap();
            contextAttributes.put(SourceContextType.AUTHN_CTX.getId(), authnCtxValue);
            contextAttributes.put(SourceContextType.CLIENT_IP.getId(), req.getRemoteAddr());
            contextAttributes.put(SourceContextType.REQUEST.getId(), AttrValueSupport.make((Object)req));
            contextAttributes.put(SourceContextType.VIRTUAL_SERVER_ID.getId(), inMsgCtx.getVirtualServerId());
            contextAttributes.put(SourceContextType.SRI.getId(), SessionIdUtil.getInstance().getExtendedSriV2(req, resp, otherState));
            if (authenticatingAuthorities != null && !authenticatingAuthorities.isEmpty()) {
                AttributeValue authnAuthoritiesAttributeValue = new AttributeValue((Collection)authenticatingAuthorities);
                contextAttributes.put(SourceContextType.AUTHENTICATING_AUTHORITY.getId(), authnAuthoritiesAttributeValue);
            }
            AttributeMap attributes = this.respSupport.executeAuthnSourceToAssertionMapping(authnResult, sp, contextAttributes, otherState);
            outMsgCtx.setMaskedAttributeNames(attributes.getMaskedAttributeNames());
            attributes.putIfNotPresent(AssertionMapKeys.getAuthnCtxKey(), authnCtxValue);
            String issuer = VirtualIdentityUtil.resolve((BaseMessageContext)inMsgCtx, sp).getVirtualEntityId(DomainMode.RUNTIME);
            IdpAuditLogger.setUserName((Map<String, AttributeValue>)attributes);
            IdpAuditLogger.setAttributes(attributes.toString());
            IdpAuditLogger.setVirtualServerId(issuer);
            this.respSupport.nameId(sp.getEntityId(), issuer, sp, authnResult, true, attributes, null);
            String binding = outMsgCtx.getBinding();
            String confirmationMethod = ConfirmationMethodIdentifiers.getConfirmationMethod(binding, sp.getProtocol());
            String ns = this.config.getStringValue("ns", "ns:unspecified");
            Calendar authnInst = this.respSupport.getAuthnInstantValue(authnResult.getAuthnAttrs(), authnResult.getAuthnBeans());
            AttributeMap copyOfAttributes = null;
            if (sp.hasMessageCustomizationHook("assertion") || sp.hasMessageCustomizationHook("authn-response")) {
                copyOfAttributes = new AttributeMap((Map)attributes);
            }
            AssertionType[] assertions = new AssertionType[]{this.assertionAssembler.assemble((Map<String, AttributeValue>)attributes, sp, ns, issuer, confirmationMethod, authnInst)};
            Map<String, Object> assertionCustomizeContext = MessageCustomization.getAssertionCustomisationContext((XmlObject)assertions[0], copyOfAttributes, authnResult.getAuthnBeans());
            assertions = sp.customizeAssertions(req, resp, assertions[0], assertionCustomizeContext, otherState);
            if (sp.isWantAssertionsSigned()) {
                try {
                    for (int i = 0; i < assertions.length; ++i) {
                        assertions[i] = this.signatureEngine.signAssertion(outMsgCtx, assertions[i]);
                    }
                }
                catch (SigningException e) {
                    throw new StatusCodeException("Unable to sign assertion.", e, TopLevelStatusCode.RESPONDER);
                }
            }
            XmlObject xmlObject = outMsgCtx.getXmlObject();
            ResponseDocument respDoc = (ResponseDocument)xmlObject;
            ResponseType response = respDoc.getResponse();
            for (AssertionType assertionType : assertions) {
                response.addNewAssertion().set((XmlObject)assertionType);
            }
            response.setIssueInstant(Util.getUtcCalendar());
            Map<String, Object> respCustomizeContext = MessageCustomization.getResponseCustomizeContext(sp, copyOfAttributes, authnResult.getAuthnBeans());
            respDoc = sp.customizeResponse(ResponseDocument.class, req, resp, respDoc, "ResponseDocument", respCustomizeContext, otherState);
            inMsgCtx.setXmlObject((XmlObject)respDoc);
            outMsgCtx.populateOutUrlAuditLogParameter();
            ThreadContext.put((String)AuditLogger.MDC_KEY.RESPONSE_ID.toString(), (String)respDoc.getResponse().getResponseID());
            ThreadContext.put((String)AuditLogger.MDC_KEY.OUT_XML_MESSAGE.toString(), (String)new XmlMessageLogWrapper(outMsgCtx).toString());
            IdpAuditLogger.setEvent("SSO");
            IdpAuditLogger.setStatus("success");
            IdpAuditLogger.log("issuing assertion... ");
        }
    }

    @Override
    public void resumeAuthn(InMessageContext inMsgCtx, HttpServletRequest req, HttpServletResponse resp, OutMessageContext outMsgCtx, Map<String, Object> otherState) throws IOException {
        try {
            this.resume(inMsgCtx, req, resp, outMsgCtx, otherState);
        }
        catch (Exception e) {
            this.handleException(req, resp, inMsgCtx, outMsgCtx, otherState, e);
        }
    }

    @Override
    public boolean isAuthnApiHandlesException(HttpServletRequest req, Map<String, Object> stateParams, InMessageContext inMsgCtx, OutMessageContext outMsgCtx) {
        return inMsgCtx == null || this.respSupport.isHandleExceptionLocally(inMsgCtx, outMsgCtx);
    }
}

