/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml1x.profiles.ap;

import com.pingidentity.common.util.xml.XmlBeansUtil;
import com.pingidentity.common.util.xml.XmlIDUtil;
import java.math.BigInteger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.common.Util;
import org.sourceid.protocol.samlp11.xml.ResponseDocument;
import org.sourceid.protocol.samlp11.xml.ResponseType;
import org.sourceid.protocol.samlp11.xml.StatusCodeType;
import org.sourceid.protocol.samlp11.xml.StatusType;
import org.sourceid.saml1x.profiles.ap.Saml1xRespOutMessageContext;
import org.sourceid.saml1x.protocol.StatusCodeException;
import org.sourceid.saml1x.protocol.TopLevelStatusCode;
import org.sourceid.saml1x.protocol.VersionSupport;
import org.sourceid.saml20.domain.DomainMode;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.metadata.partner.MetadataDirectory;
import org.sourceid.saml20.util.VirtualIdentityUtil;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public class ProfileSupport {
    private final MetadataDirectory metadataDirectory = MetaDataFactory.getMetadataDirectory();

    public Saml1xRespOutMessageContext getInitialOutMsgCtx(InMessageContext inMsgCtx) {
        Saml1xRespOutMessageContext outMsgCtx = new Saml1xRespOutMessageContext(Role.SP);
        String spId = inMsgCtx.getEntityId();
        SpConnection sp = this.metadataDirectory.getSpConnectionMetadata(spId);
        outMsgCtx.setEntityId(spId);
        outMsgCtx.setVirtualServerId(VirtualIdentityUtil.getDefaultVirtualIdForRuntime(sp).getVirtualEntityId(DomainMode.RUNTIME));
        ResponseDocument respDoc = ResponseDocument.Factory.newInstance();
        ResponseType response = respDoc.addNewResponse();
        XmlBeansUtil.forceNamespacePrefix((XmlObject)respDoc);
        response.setResponseID(XmlIDUtil.createID());
        response.setMajorVersion(BigInteger.ONE);
        BigInteger minorVersion = VersionSupport.getMinorVersion(sp);
        response.setMinorVersion(minorVersion);
        response.setIssueInstant(Util.getUtcCalendar());
        StatusType statusType = response.addNewStatus();
        StatusCodeType statusCodeType = statusType.addNewStatusCode();
        statusCodeType.setValue(TopLevelStatusCode.SUCCESS.getQName());
        outMsgCtx.setResponseDocument(respDoc);
        return outMsgCtx;
    }

    protected void handleEx(Exception e, InMessageContext inMsgCtx, OutMessageContext outMsgCtx, HttpServletRequest req, HttpServletResponse resp) {
        StatusCodeException sce = e instanceof StatusCodeException ? (StatusCodeException)e : new StatusCodeException(e.getMessage(), e, TopLevelStatusCode.RESPONDER);
        XmlObject xmlObject = outMsgCtx.getXmlObject();
        ResponseDocument respDoc = (ResponseDocument)xmlObject;
        ResponseType response = respDoc.getResponse();
        StatusType status = response.getStatus();
        status.getStatusCode().setValue(sce.getTopLevelStatusCode().getQName());
        String message = e.getMessage();
        if (!StringUtils.isBlank((String)message)) {
            status.setStatusMessage(message);
        } else {
            status.setStatusMessage(e.toString());
        }
    }
}

