/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml1x.protocol;

import java.util.HashMap;
import java.util.Map;
import org.sourceid.websso.Protocol;

public class ConfirmationMethodIdentifiers {
    public static final String ARTIFACT = "urn:oasis:names:tc:SAML:1.0:cm:artifact";
    public static final String DEPRECATED_ARTIFACT = "urn:oasis:names:tc:SAML:1.0:cm:artifact-01";
    public static final String BEARER = "urn:oasis:names:tc:SAML:1.0:cm:bearer";
    public static final String SENDER_VOUCHES = "urn:oasis:names:tc:SAML:1.0:cm:sender-vouches";
    public static final String HOLDER_OF_KEY = "urn:oasis:names:tc:SAML:1.0:cm:holder-of-key";
    private static Map<String, Map<Protocol, String>> toConf = new HashMap<String, Map<Protocol, String>>();
    private static Map<String, String> toBinding;

    public static String getBindingFromConfMethod(String confirmationMethod) {
        return toBinding.get(confirmationMethod);
    }

    public static String getConfirmationMethod(String bindingUri, Protocol protocol) {
        Map<Protocol, String> map = toConf.get(bindingUri);
        return map != null ? map.get(protocol) : null;
    }

    static {
        HashMap<Protocol, String> artMap = new HashMap<Protocol, String>();
        artMap.put(Protocol.SAML10, DEPRECATED_ARTIFACT);
        artMap.put(Protocol.SAML11, ARTIFACT);
        toConf.put("urn:oasis:names:tc:SAML:1.0:profiles:artifact-01", artMap);
        HashMap<Protocol, String> postMap = new HashMap<Protocol, String>();
        postMap.put(Protocol.SAML10, BEARER);
        postMap.put(Protocol.SAML11, BEARER);
        toConf.put("urn:oasis:names:tc:SAML:1.0:profiles:browser-post", postMap);
        toBinding = new HashMap<String, String>();
        toBinding.put(ARTIFACT, "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01");
        toBinding.put(DEPRECATED_ARTIFACT, "urn:oasis:names:tc:SAML:1.0:profiles:artifact-01");
        toBinding.put(BEARER, "urn:oasis:names:tc:SAML:1.0:profiles:browser-post");
    }
}

