/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml1x.protocol;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.xml.namespace.QName;
import org.sourceid.common.Util;
import org.sourceid.protocol.saml11.xml.AssertionType;
import org.sourceid.protocol.saml11.xml.AudienceRestrictionConditionType;
import org.sourceid.protocol.saml11.xml.ConditionAbstractType;
import org.sourceid.protocol.saml11.xml.ConditionsType;
import org.sourceid.saml1x.wrapper.AssertionStatus;
import org.sourceid.websso.protocol.AssertionConditionsValidator;
import org.sourceid.websso.protocol.TimeConditionUtil;
import org.sourceid.websso.wrapper.AssertionStatus;

public class ValidateAssertionConditions
extends AssertionConditionsValidator {
    public void validate(AssertionStatus assertion, List<String> myAudienceIds) {
        AssertionType assertionType = assertion.getAssertionType();
        if (assertionType.isSetConditions()) {
            ConditionsType conditions = assertionType.getConditions();
            this.validateTimeConditions(conditions, assertion);
            this.validateAudienceConditions(conditions, myAudienceIds, assertion);
            this.checkForUnknownConditions(conditions, assertion);
        } else {
            assertion.addInvalidRemark("No conditions set on assertion");
        }
    }

    private void checkForUnknownConditions(ConditionsType conditions, AssertionStatus assertion) {
        int sizeOfUnknownConditions = conditions.sizeOfConditionArray();
        if (sizeOfUnknownConditions > 0) {
            if (assertion.isValid()) {
                assertion.setStatus(AssertionStatus.Status.INDETERMINATE);
            }
            ArrayList<QName> qnames = new ArrayList<QName>(sizeOfUnknownConditions);
            for (ConditionAbstractType condition : conditions.getConditionArray()) {
                qnames.add(condition.schemaType().getName());
            }
            assertion.addRemark("Unknown assertion condition(s): " + ((Object)qnames).toString());
        }
    }

    private void validateAudienceConditions(ConditionsType conditions, List<String> myAudienceIds, AssertionStatus assertion) {
        AudienceRestrictionConditionType[] audienceRestrictionConditions = conditions.getAudienceRestrictionConditionArray();
        if (audienceRestrictionConditions.length > 0) {
            boolean[] isConditionValidList = new boolean[audienceRestrictionConditions.length];
            for (int i = 0; i < audienceRestrictionConditions.length; ++i) {
                String[] audiences;
                AudienceRestrictionConditionType cond = audienceRestrictionConditions[i];
                block1: for (String audience : audiences = cond.getAudienceArray()) {
                    for (String myAudienceId : myAudienceIds) {
                        if (!this.audienceEvaluator.evalAudience(myAudienceId, audience)) continue;
                        isConditionValidList[i] = true;
                        continue block1;
                    }
                }
            }
            boolean allValid = true;
            for (int i = 0; i < isConditionValidList.length && allValid; ++i) {
                allValid = isConditionValidList[i];
            }
            if (!allValid) {
                assertion.addInvalidRemark(this.audienceEvaluator.getRemark(myAudienceIds.toArray(new String[myAudienceIds.size()])));
            }
        }
    }

    private void validateTimeConditions(ConditionsType conditions, AssertionStatus assertion) {
        Calendar now = Util.getUtcCalendar();
        if (conditions.isSetNotBefore()) {
            Calendar notBefore = conditions.getNotBefore();
            try {
                this.timeConditionUtil.validateNotBefore(notBefore, now);
            }
            catch (TimeConditionUtil.InvalidTimeConditionException e) {
                assertion.addInvalidRemark(e.getMessage());
            }
        }
        if (conditions.isSetNotOnOrAfter()) {
            Calendar notOnOrAfter = conditions.getNotOnOrAfter();
            try {
                this.timeConditionUtil.validateNotOnOrAfter(notOnOrAfter, now);
            }
            catch (TimeConditionUtil.InvalidTimeConditionException e) {
                assertion.addInvalidRemark(e.getMessage());
            }
        } else if (this.requireNotOnOrAfter) {
            assertion.addInvalidRemark("Conditions do not contain a NotOnOrAfter restriction");
        }
    }
}

