/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml1x.protocol;

import java.net.URI;
import java.net.URISyntaxException;
import org.sourceid.protocol.saml11.xml.AssertionType;
import org.sourceid.protocol.saml11.xml.AuthenticationStatementType;
import org.sourceid.protocol.saml11.xml.SubjectConfirmationType;
import org.sourceid.protocol.saml11.xml.SubjectStatementAbstractType;
import org.sourceid.protocol.saml11.xml.SubjectType;
import org.sourceid.saml1x.protocol.ConfirmationMethodIdentifiers;
import org.sourceid.saml1x.wrapper.AssertionStatus;

public class ValidateAssertionConfirmationMethods {
    public void validate(AssertionStatus assertionStatus, String bindingUri) {
        AssertionType assertionType = assertionStatus.getAssertionType();
        assertionType.getAuthenticationStatementArray();
        AuthenticationStatementType[] authenticationStatementArray = assertionType.getAuthenticationStatementArray();
        this.validateConfMethods(assertionStatus, (SubjectStatementAbstractType[])authenticationStatementArray, bindingUri);
        this.authnStmtWithAuthnMethod(assertionStatus, authenticationStatementArray);
        this.validateConfMethods(assertionStatus, (SubjectStatementAbstractType[])assertionType.getAttributeStatementArray(), bindingUri);
        this.validateConfMethods(assertionStatus, (SubjectStatementAbstractType[])assertionType.getAuthorizationDecisionStatementArray(), bindingUri);
        this.validateConfMethods(assertionStatus, assertionType.getSubjectStatementArray(), bindingUri);
    }

    public void authnStmtWithAuthnMethod(AssertionStatus status, AuthenticationStatementType[] stmts) {
        for (AuthenticationStatementType stmt : stmts) {
            String authMethod = stmt.getAuthenticationMethod();
            if (authMethod == null) {
                status.addInvalidRemark("Missing AuthenticationMethod on AuthenticationStatement.");
                continue;
            }
            try {
                new URI(authMethod);
            }
            catch (URISyntaxException e) {
                status.addInvalidRemark("Unable to parse (as URI) one of the authentication methods (" + authMethod + ") in the assertion.");
            }
        }
    }

    public void validateConfMethods(AssertionStatus status, SubjectStatementAbstractType[] stmts, String bindingUri) {
        for (SubjectStatementAbstractType statement : stmts) {
            SubjectType subjectType = statement.getSubject();
            if (!subjectType.isSetSubjectConfirmation()) {
                status.addInvalidRemark("No SubjectConfirmation element on " + this.getName(statement));
                return;
            }
            SubjectConfirmationType subjectConfirmationType = subjectType.getSubjectConfirmation();
            String[] confirmationMethods = subjectConfirmationType.getConfirmationMethodArray();
            if (confirmationMethods.length != 1) {
                status.addInvalidRemark("Wrong number (" + confirmationMethods.length + ") of SubjectConfirmation element on " + this.getName(statement));
                return;
            }
            String confirmationMethod = confirmationMethods[0];
            String expectedBindingForConfMethod = ConfirmationMethodIdentifiers.getBindingFromConfMethod(confirmationMethod);
            if (bindingUri.equals(expectedBindingForConfMethod)) continue;
            StringBuilder sb = new StringBuilder().append("Wrong confirmation method on ");
            sb.append(this.getName(statement)).append(" for binding/profile URI (").append(bindingUri);
            sb.append(").  The confirmation method (").append(confirmationMethod).append(") is for the ");
            sb.append(expectedBindingForConfMethod).append(" binding/profile.");
            status.addInvalidRemark(sb.toString());
        }
    }

    public String getName(SubjectStatementAbstractType stmt) {
        return stmt.schemaType().getName().getLocalPart();
    }
}

