/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml1x.protocol;

import org.sourceid.common.dsig.SignatureResult;
import org.sourceid.common.dsig.SignatureStatus;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.protocol.saml11.xml.AssertionType;
import org.sourceid.saml1x.wrapper.AssertionStatus;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.dsig.SignatureEngine;

public class ValidateAssertionSignature {
    private SignatureEngine signatureEngine = GlobalRegistry.getService(SignatureEngine.class);

    public void validate(AssertionStatus assertionStatus, IdpConnection idp) {
        AssertionType assertion = assertionStatus.getAssertionType();
        SignatureResult signatureResult = this.signatureEngine.verifyAssertionSignature(assertion, idp.getEntityId());
        SignatureStatus sigStatus = signatureResult.getStatus();
        if (sigStatus == SignatureStatus.INVALID) {
            assertionStatus.addInvalidRemark("Signature is " + signatureResult);
        }
        if (sigStatus == SignatureStatus.NOT_PRESENT && idp.isAssertionSigned()) {
            String msg = "Signature is not present but system is configured to require signed assertions from ";
            assertionStatus.addInvalidRemark(msg + idp.getEncodedEntityId());
        }
        if (sigStatus == SignatureStatus.UNVERIFIED && idp.isAssertionSigned()) {
            assertionStatus.addInvalidRemark("Unable to verify the signature. Please make sure that verification certificates are properly configured and not expired.");
        }
    }
}

