/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml1x.protocol;

import java.math.BigInteger;
import org.sourceid.saml1x.protocol.StatusCodeException;
import org.sourceid.saml1x.protocol.TopLevelStatusCode;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.metadata.local.MetadataLocal;
import org.sourceid.websso.Protocol;
import org.sourceid.websso.profiles.InvalidSsoResponseException;
import org.sourceid.websso.profiles.ProcessRuntimeException;

public class VersionSupport {
    public static BigInteger getMinorVersion(ConnectionBase sp) {
        BigInteger minorVersion;
        Protocol protocol = sp.getProtocol();
        switch (protocol) {
            case SAML10: {
                minorVersion = BigInteger.ZERO;
                break;
            }
            case SAML11: {
                minorVersion = BigInteger.ONE;
                break;
            }
            case WSFED: {
                minorVersion = BigInteger.ONE;
                break;
            }
            case SAML20: {
                minorVersion = BigInteger.ZERO;
                break;
            }
            default: {
                throw new ProcessRuntimeException("Connection has wrong protocol type: " + protocol);
            }
        }
        return minorVersion;
    }

    public static void validateVersion(SpConnection sp, BigInteger majorVersion, BigInteger minorVersion, String ctxName) throws StatusCodeException {
        String msg = VersionSupport.doVersionCheck(sp, majorVersion, minorVersion, ctxName);
        if (msg != null) {
            throw new StatusCodeException(msg, TopLevelStatusCode.VERSION_MISMATCH);
        }
    }

    public static void validateVersion(IdpConnection idp, BigInteger majorVersion, BigInteger minorVersion, String ctxName) throws InvalidSsoResponseException {
        String msg = VersionSupport.doVersionCheck(idp, majorVersion, minorVersion, ctxName);
        if (msg != null) {
            throw new InvalidSsoResponseException(msg);
        }
    }

    public static String doVersionCheck(ConnectionBase conn, BigInteger majorVersion, BigInteger minorVersion, String ctxName) {
        boolean isConnSaml11;
        boolean isMinorVersionOne = BigInteger.ONE.equals(minorVersion);
        boolean isMinorVersionZero = BigInteger.ZERO.equals(minorVersion);
        if (!BigInteger.ONE.equals(majorVersion) || !isMinorVersionOne && !isMinorVersionZero) {
            String msg = null;
            StringBuilder sb = new StringBuilder();
            sb.append("Wrong version on ").append(ctxName).append(" (").append(majorVersion).append(".");
            sb.append(minorVersion).append(") expected");
            sb.append("1.0 or 1.1 for ").append(conn.getEncodedEntityId());
            msg = sb.toString();
            return msg;
        }
        String msg = VersionSupport.doVersionCheck(conn);
        if (msg != null) {
            return msg;
        }
        Protocol protocol = conn.getProtocol();
        boolean isConnSaml10 = protocol == Protocol.SAML10;
        boolean bl = isConnSaml11 = protocol == Protocol.SAML11;
        if (isConnSaml10 && isMinorVersionOne) {
            return "Incorrect SAML version. SAML 1.0 is expected.";
        }
        if (isConnSaml11 && isMinorVersionZero) {
            return "Incorrect SAML version. SAML 1.1 is expected.";
        }
        return null;
    }

    public static String doVersionCheck(ConnectionBase conn) {
        Protocol protocol = conn.getProtocol();
        boolean isConnSaml10 = protocol == Protocol.SAML10;
        boolean isConnSaml11 = protocol == Protocol.SAML11;
        boolean isSP = conn.getRoleType() == Role.IDP;
        boolean isSaml10Enabled = false;
        boolean isSaml11Enabled = false;
        MetadataLocal localMetaData = MetaDataFactory.getLocalMetaData();
        if (isSP) {
            isSaml10Enabled = localMetaData.getEnableSaml10Rp();
            isSaml11Enabled = localMetaData.getEnableSaml11Rp();
        } else {
            isSaml10Enabled = localMetaData.getEnableSaml10Ap();
            isSaml11Enabled = localMetaData.getEnableSaml11Ap();
        }
        if (isConnSaml10 && !isSaml10Enabled) {
            return "SAML 1.0 is disabled.";
        }
        if (isConnSaml11 && !isSaml11Enabled) {
            return "SAML 1.1 is disabled.";
        }
        return null;
    }
}

