/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.adapter.sp.authn;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.sourceid.common.ResponseTemplateRenderer;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.metadata.partner.MetadataSupport;

public abstract class LocalIdPasswordLookup {
    private static final String NAME = "pf-sp.username";
    private static final String PASS = "pf-sp.pass";
    private static final String OK = "pf-sp.ok";
    private static final String CANCEL = "pf-sp.cancel";
    private static final String ATTEMPTS = "pf-sp.token";
    private int maxUserChallengeRetries = 3;

    public abstract String getLocalIdentifier(String var1, String var2);

    public String lookupViaPassword(HttpServletRequest req, HttpServletResponse resp, String entityId, String resumePath) throws IOException {
        boolean formPosted;
        String localId = null;
        String username = req.getParameter(NAME);
        String password = req.getParameter(PASS);
        boolean bl = formPosted = username != null && password != null;
        if (formPosted) {
            if (req.getParameter(CANCEL) == null) {
                String attemptsParameter = req.getParameter(ATTEMPTS);
                int attempts = 0;
                try {
                    attempts = Integer.parseInt(attemptsParameter);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                localId = this.getLocalIdentifier(username, password);
                if (StringUtils.isBlank((String)localId)) {
                    this.challenge(req, resp, resumePath, username, true, ++attempts, entityId);
                }
            }
        } else {
            this.challenge(req, resp, resumePath, username, false, 0, entityId);
        }
        return localId;
    }

    public int getMaxUserChallengeRetries() {
        return this.maxUserChallengeRetries;
    }

    public void setMaxUserChallengeRetries(int maxUserChallengeRetries) {
        this.maxUserChallengeRetries = maxUserChallengeRetries;
    }

    private void challenge(HttpServletRequest req, HttpServletResponse resp, String url, String name, boolean loginFailed, int attempts, String entityId) throws IOException {
        if (attempts < this.getMaxUserChallengeRetries()) {
            FormTemplate formTemplate = new FormTemplate(url, name, loginFailed, attempts, entityId);
            ResponseTemplateRenderer respRenderer = ResponseTemplateRenderer.getInstance();
            respRenderer.renderResponse(req, resp, formTemplate);
        }
    }

    private class FormTemplate
    extends ResponseTemplateRenderer.ContentTemplate {
        public static final String TEMPLATE_NAME = "LocalIdPasswordLookup.form.template.html";
        private String[] args;

        public FormTemplate(String actionUrl, String uname, boolean loginFailed, int attempts, String entityId) {
            super(TEMPLATE_NAME);
            String unname = uname == null ? "" : uname;
            String openComment = "<!--";
            String closeComment = "-->";
            if (loginFailed) {
                openComment = "";
                closeComment = "";
            }
            String num = String.valueOf(attempts);
            IdpConnection idpConnectionMetadata = MetadataSupport.getIdpConnection(entityId);
            String companyName = idpConnectionMetadata.getContactInfo().getCompany();
            this.args = new String[]{actionUrl, LocalIdPasswordLookup.NAME, unname, LocalIdPasswordLookup.PASS, LocalIdPasswordLookup.OK, LocalIdPasswordLookup.CANCEL, openComment, closeComment, LocalIdPasswordLookup.ATTEMPTS, num, companyName, entityId};
        }

        @Override
        public Object[] getArguments() {
            return this.args;
        }
    }
}

