/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.bindings;

import com.pingidentity.common.util.xml.XmlBeansUtil;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.common.Util;
import org.sourceid.common.dsig.SignatureStatus;
import org.sourceid.saml20.bindings.AbstractAsyncBinding;
import org.sourceid.saml20.bindings.BindingException;
import org.sourceid.saml20.bindings.DestinationBindingException;
import org.sourceid.saml20.domain.DomainMode;
import org.sourceid.saml20.protocol.GeneralXmlUtil;
import org.sourceid.saml20.util.DeficientPartnerWorkaround;
import org.sourceid.saml20.util.VirtualIdentityUtil;
import org.sourceid.saml20.wrapper.SignaturePolicy;
import org.sourceid.util.ResourceEvaluator;
import org.sourceid.websso.servlet.HttpStatusCodeException;
import org.sourceid.websso.wrapper.BaseMessageContext;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

abstract class AbstractAsyncPassByValueBinding
extends AbstractAsyncBinding {
    private final ResourceEvaluator resourceEvaluator = new ResourceEvaluator();

    AbstractAsyncPassByValueBinding() {
    }

    public abstract void transport(HttpServletRequest var1, HttpServletResponse var2, OutMessageContext var3, boolean var4, boolean var5) throws IOException, BindingException;

    public abstract InMessageContext receive(HttpServletRequest var1, HttpServletResponse var2, String var3, InMessageContext var4) throws IOException, BindingException, HttpStatusCodeException;

    @Override
    public void transport(HttpServletRequest request, HttpServletResponse resp, OutMessageContext msgCtx, boolean isMsgRequest) throws IOException, BindingException {
        boolean signMessage;
        SignaturePolicy sigPolicy = msgCtx.getSignaturePolicy();
        boolean bl = signMessage = sigPolicy == SignaturePolicy.BINDING_DEFAULT || sigPolicy == SignaturePolicy.SIGN;
        if (signMessage) {
            GeneralXmlUtil.setDestination(msgCtx.getXmlObject(), msgCtx.getEndpoint());
        }
        this.transport(request, resp, msgCtx, isMsgRequest, signMessage);
    }

    @Override
    public InMessageContext doReceive(HttpServletRequest request, HttpServletResponse response, InMessageContext inMsgCtx) throws IOException, BindingException, HttpStatusCodeException {
        String req = request.getParameter("SAMLRequest");
        boolean isRequest = !StringUtils.isBlank((String)req);
        String base64encodedMsg = isRequest ? req : request.getParameter("SAMLResponse");
        InMessageContext inMessageContext = this.receive(request, response, base64encodedMsg, inMsgCtx);
        inMessageContext.setIsRequest(isRequest);
        this.checkDestination(inMessageContext, request);
        return inMessageContext;
    }

    protected void checkDestination(InMessageContext inMessageContext, HttpServletRequest request) throws DestinationBindingException {
        if (SignatureStatus.VALID == inMessageContext.getSignatureStatus()) {
            String requestUrlStr = request.getRequestURL().toString();
            XmlObject xmlObj = inMessageContext.getXmlObject();
            String destination = GeneralXmlUtil.getDestination(xmlObj);
            String entityId = inMessageContext.getEntityId();
            if (StringUtils.isBlank((String)destination)) {
                String msg = "Security considerations sections 3.4.5.2 and 3.5.5.2 of saml-bindings-2.0-os say, " + Util.LINE_BREAK + "'If the message is signed, the Destination XML attribute in the root SAML element " + Util.LINE_BREAK + "of the protocol message MUST contain the URL to which the sender has instructed " + Util.LINE_BREAK + "the user agent to deliver the message.' " + Util.LINE_BREAK + "However, no Destination attribute is set on the message." + Util.LINE_BREAK + inMessageContext;
                DestinationBindingException e = new DestinationBindingException(msg);
                String docName = xmlObj.schemaType().getShortJavaName();
                String id = docName + ":AsyncPassByValueBindingDestinationAttributeRequiredWhenSigned";
                DeficientPartnerWorkaround.checkThrow(e, entityId, id);
            } else {
                ResourceEvaluator.Result matchResult = this.resourceEvaluator.isResourceMatch(destination, requestUrlStr);
                if (!matchResult.isMatch()) {
                    String msg = "Destination mismatch: " + matchResult.getMessage();
                    DestinationBindingException e = new DestinationBindingException(msg);
                    String id = inMessageContext.getBinding() + ":DestinationAttributeEval";
                    DeficientPartnerWorkaround.checkThrow(e, entityId, id);
                }
            }
        }
    }

    void parseXmlSetUpCtx(HttpServletRequest request, InMessageContext inMsgCtx, String xmlString, String b64encodedMsg) throws BindingException {
        XmlObject xmlObject;
        try {
            xmlObject = XmlBeansUtil.parse(xmlString, XmlObject.class);
        }
        catch (XmlException e) {
            StringBuilder msg = new StringBuilder();
            msg.append("Unable to parse incoming SAML2 message, raw: ").append(b64encodedMsg);
            msg.append(" | decoded: ").append(xmlString);
            throw new BindingException(msg.toString(), e);
        }
        inMsgCtx.setXmlObject(xmlObject);
        String issuer = GeneralXmlUtil.getIssuer(xmlObject);
        inMsgCtx.setEntityId(issuer);
        if (StringUtils.isNotBlank((String)issuer)) {
            String virtualServerId = VirtualIdentityUtil.resolve((BaseMessageContext)inMsgCtx, request).getVirtualEntityId(DomainMode.RUNTIME);
            inMsgCtx.setVirtualServerId(virtualServerId);
        }
    }

    @Override
    public boolean isEntityIdRequired() {
        return true;
    }
}

