/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.bindings;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.bindings.Binding;
import org.sourceid.saml20.bindings.BindingException;
import org.sourceid.saml20.bindings.BindingFactory;
import org.sourceid.saml20.bindings.BindingService;
import org.sourceid.saml20.core.TopLevelStatusCode;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.IncomingBindings;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.saml20.metadata.partner.MetadataSupport;
import org.sourceid.saml20.xmlbinding.protocol.ArtifactResolveDocument;
import org.sourceid.servlet.QuietException;
import org.sourceid.servlet.ServletExceptionSupport;
import org.sourceid.websso.servlet.HttpStatusCodeException;
import org.sourceid.websso.servlet.RedirectException;
import org.sourceid.websso.servlet.RenderPageException;
import org.sourceid.websso.wrapper.BaseMessageContext;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public class BindingServiceImpl
implements BindingService {
    private final Log log = LogFactory.getLog(this.getClass());

    @Override
    public InMessageContext receive(HttpServletRequest request, HttpServletResponse response, String bindingName, Role partnerRole) throws BindingException, IOException, RedirectException, RenderPageException, HttpStatusCodeException {
        Binding binding = BindingFactory.getBinding(bindingName);
        InMessageContext inMessageContext = binding.receive(request, response, partnerRole);
        inMessageContext.setBinding(bindingName);
        inMessageContext.setBackChannelBinding(binding.isBackChannel());
        if (!this.isResponseFailureMessage(inMessageContext)) {
            this.validateIncomingConnection(inMessageContext);
        }
        return inMessageContext;
    }

    @Override
    public InMessageContext receive(HttpServletRequest request, HttpServletResponse response, boolean isPost, Role partnerRole) throws BindingException, IOException, RedirectException, RenderPageException, HttpStatusCodeException {
        String bindingName = BindingFactory.ascertainBindingName(request, isPost, true);
        return this.receive(request, response, bindingName, partnerRole);
    }

    @Override
    public void transportResponse(HttpServletRequest req, HttpServletResponse resp, InMessageContext inMsgCtx, OutMessageContext outMsgCtx) throws IOException, BindingException, RedirectException, RenderPageException {
        if (!resp.isCommitted()) {
            if (inMsgCtx != null) {
                String inBindingURI = inMsgCtx.getBinding();
                String outBindingURI = outMsgCtx.getBinding();
                if (this.isBackChannel(inBindingURI) && (outBindingURI == null || !this.isBackChannel(outBindingURI))) {
                    outMsgCtx.setBinding(inBindingURI);
                } else if (StringUtils.isBlank((String)outMsgCtx.getRelayState())) {
                    outMsgCtx.setRelayState(inMsgCtx.getRelayState());
                }
            }
            Binding binding = BindingFactory.getBinding(outMsgCtx.getBinding());
            this.checkActive(outMsgCtx, binding);
            binding.transportResponse(req, resp, outMsgCtx);
        } else {
            this.logNotTransportMsg("response");
        }
    }

    private void logNotTransportMsg(String context) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Not transporting protocol " + context + " message because the HTTP response has been committed (this is a normal condition usually due to an adapter or other component redirecting the user or writing its own content to the response). "));
        }
    }

    @Override
    public InMessageContext transportRequest(HttpServletRequest req, HttpServletResponse resp, OutMessageContext msgCtxOut) throws IOException, BindingException, RedirectException, RenderPageException {
        if (!resp.isCommitted()) {
            if (msgCtxOut != null) {
                Binding binding = BindingFactory.getBinding(msgCtxOut.getBinding());
                this.checkActive(msgCtxOut, binding);
                return binding.transportRequest(req, resp, msgCtxOut);
            }
            return null;
        }
        this.logNotTransportMsg("request");
        return null;
    }

    @Override
    public void handleException(HttpServletRequest req, HttpServletResponse resp, boolean isPost, Exception e) throws ServletException, IOException, RenderPageException, HttpStatusCodeException {
        Binding binding;
        block8: {
            String bindingName = BindingFactory.ascertainBindingName(req, isPost, false);
            binding = null;
            String uri = "";
            if (bindingName != null) {
                try {
                    binding = BindingFactory.getBinding(bindingName);
                    if (binding != null) {
                        uri = binding.getUri();
                    }
                }
                catch (BindingException bindingException) {
                    this.log.error((Object)("Exception " + e + " in handleException for " + bindingName), (Throwable)bindingException);
                }
                catch (Exception exception) {
                    if (!this.log.isDebugEnabled() || e.getCause() instanceof QuietException) break block8;
                    this.log.debug((Object)("Handle Exception (" + uri + ")."), (Throwable)e);
                }
            }
        }
        if (binding != null) {
            binding.handleException(req, resp, e);
        } else {
            if (e instanceof BindingException) {
                throw new HttpStatusCodeException(e.getMessage(), 400);
            }
            ServletExceptionSupport.throwServletException(e);
        }
    }

    @Override
    public boolean isBackChannelBinding(String bindingURI) {
        try {
            return this.isBackChannel(bindingURI);
        }
        catch (BindingException e) {
            this.log.error((Object)"Unexpected Problem checking if binding is a back channel binding.", (Throwable)e);
            return false;
        }
    }

    boolean isBackChannel(String bindingURI) throws BindingException {
        Binding binding = BindingFactory.getBinding(bindingURI);
        return binding.isBackChannel();
    }

    void checkActive(BaseMessageContext msgCtx, Binding binding) throws BindingException {
        ConnectionBase baseConnectionMetadata;
        if (binding.isEntityIdRequired() && !(baseConnectionMetadata = MetadataSupport.getBaseConnectionMetadata(msgCtx)).isActive()) {
            throw new BindingException(baseConnectionMetadata.getEncodedEntityId() + " is not active.");
        }
    }

    private void validateIncomingConnection(BaseMessageContext msgCtx) throws BindingException {
        String inBinding = msgCtx.getBinding();
        Binding binding = BindingFactory.getBinding(inBinding);
        if (binding.isEntityIdRequired()) {
            if (msgCtx.getEntityId() == null) {
                String msg = "Inbound message contains insufficient information to determine the identity of the partner. " + msgCtx;
                throw new BindingException(msg);
            }
            ConnectionBase baseConnectionMetadata = MetadataSupport.getBaseConnectionMetadata(msgCtx);
            if (!baseConnectionMetadata.isActive()) {
                throw new BindingException(baseConnectionMetadata.getEncodedEntityId() + " is not active.");
            }
            IncomingBindings okBindings = baseConnectionMetadata.getIncomingBindings();
            if (!(okBindings.checkBinding(inBinding) || this.isBackChannel(inBinding) && msgCtx.getXmlObject() instanceof ArtifactResolveDocument)) {
                String eid = baseConnectionMetadata.getEncodedEntityId();
                throw new BindingException("Incoming binding " + inBinding + " is not enabled for " + eid);
            }
        }
    }

    private boolean isResponseFailureMessage(InMessageContext inMessageContext) {
        if (inMessageContext.isRequest()) {
            return false;
        }
        String statusCodeUri = inMessageContext.getStatusCodeUri();
        return !TopLevelStatusCode.SUCCESS.equals(TopLevelStatusCode.parse(statusCodeUri));
    }
}

