/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.bindings;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.ExceptionUtil;
import org.sourceid.saml20.bindings.Binding;
import org.sourceid.saml20.bindings.BindingException;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.servlet.QuietException;
import org.sourceid.websso.servlet.HttpStatusCodeException;
import org.sourceid.websso.servlet.RedirectException;
import org.sourceid.websso.servlet.RenderPageException;
import org.sourceid.websso.wrapper.BaseMessageContext;
import org.sourceid.websso.wrapper.InMessageContext;
import org.sourceid.websso.wrapper.OutMessageContext;

public class LoggingInterceptor
implements Binding {
    private static final String LINE_BREAK = System.getProperty("line.separator");
    private final Log log = LogFactory.getLog(this.getClass());
    private final Binding proxiedBinding;

    public LoggingInterceptor(Binding proxiedBinding) {
        this.proxiedBinding = proxiedBinding;
    }

    @Override
    public InMessageContext transportRequest(HttpServletRequest req, HttpServletResponse resp, OutMessageContext msgCtx) throws IOException, BindingException, RedirectException, RenderPageException {
        InMessageContext inMessageContext = this.proxiedBinding.transportRequest(req, resp, msgCtx);
        this.logMsg("Transported Request. OutMessageContext:", msgCtx);
        if (inMessageContext != null) {
            this.logMsg("Transport/Receive Synchronous Response: InMessageContext:", inMessageContext);
        }
        return inMessageContext;
    }

    @Override
    public void transportResponse(HttpServletRequest request, HttpServletResponse response, OutMessageContext outMsgCtx) throws IOException, BindingException, RedirectException, RenderPageException {
        this.proxiedBinding.transportResponse(request, response, outMsgCtx);
        this.logMsg("Transported Response. OutMessageContext:", outMsgCtx);
    }

    @Override
    public InMessageContext receive(HttpServletRequest request, HttpServletResponse response, Role partnerRole) throws BindingException, IOException, RedirectException, RenderPageException, HttpStatusCodeException {
        InMessageContext inMessageContext = this.proxiedBinding.receive(request, response, partnerRole);
        inMessageContext.setBinding(this.proxiedBinding.getUri());
        this.logMsg("Received InMessageContext:", inMessageContext);
        return inMessageContext;
    }

    @Override
    public void handleException(HttpServletRequest req, HttpServletResponse resp, Exception e) throws ServletException, IOException, RenderPageException {
        String msg = "Handle Exception (" + this.getUri() + ")";
        if (e.getCause() instanceof QuietException) {
            this.log.debug((Object)(msg + ": " + ExceptionUtil.toStringWithCauses(e)));
        } else {
            this.log.error((Object)(msg + ": " + ExceptionUtil.toStringWithCauses(e)));
            this.log.debug((Object)msg, (Throwable)e);
        }
        this.proxiedBinding.handleException(req, resp, e);
    }

    @Override
    public boolean isBackChannel() {
        return this.proxiedBinding.isBackChannel();
    }

    void logMsg(String messageQualifier, BaseMessageContext msgCtx) {
        if (this.log.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder(messageQualifier);
            msg.append(LINE_BREAK).append(msgCtx);
            this.log.debug((Object)msg);
        }
    }

    @Override
    public String getUri() {
        return this.proxiedBinding.getUri();
    }

    @Override
    public boolean isEntityIdRequired() {
        return this.proxiedBinding.isEntityIdRequired();
    }
}

