/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain;

import com.pingidentity.common.util.HierarchicalUriComparison;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import org.sourceid.wstrust.handlers.WSTrustException;

public class AppliesTo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private URI appliesToURI;

    public AppliesTo(String appliesToURI) {
        try {
            this.appliesToURI = new URI(appliesToURI).normalize();
        }
        catch (URISyntaxException e) {
            throw new WSTrustException("Can't parse Address URI in AppliesTo: " + appliesToURI);
        }
    }

    public int compareTo(AppliesTo that) {
        return HierarchicalUriComparison.compare(that.appliesToURI, this.appliesToURI, false);
    }

    public int compareQuery(AppliesTo givenAppliesTo) {
        int compare = -1;
        if (this.getAppliesToURI() == null && givenAppliesTo.getAppliesToURI() == null) {
            compare = 0;
        } else {
            String currentQuery = this.getAppliesToURI().getQuery();
            String otherQuery = givenAppliesTo.getAppliesToURI().getQuery();
            compare = currentQuery == null ? (otherQuery == null ? 0 : -1) : (otherQuery == null ? -1 : (currentQuery.equals(otherQuery) ? 0 : -1));
        }
        return compare;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return this.appliesToURI.equals(((AppliesTo)obj).getAppliesToURI());
    }

    public int hashCode() {
        return this.appliesToURI.hashCode();
    }

    public URI getAppliesToURI() {
        return this.appliesToURI;
    }

    public String toString() {
        return this.appliesToURI.toString();
    }
}

