/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.adapter.attribute.AttributeValue;

public class AttributeNameMapping
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private Map<String, String> appAttributeToIdpAttributeNameMapping = new HashMap<String, String>();
    private Map<String, String> idpAttributeToAppAttributeNameMapping = new HashMap<String, String>();

    public void setNameMappings(Collection<NameMapping> mappings) {
        this.appAttributeToIdpAttributeNameMapping.clear();
        this.idpAttributeToAppAttributeNameMapping.clear();
        for (NameMapping nm : mappings) {
            this.appAttributeToIdpAttributeNameMapping.put(nm.getLocalName(), nm.getRemoteName());
            this.idpAttributeToAppAttributeNameMapping.put(nm.getRemoteName(), nm.getLocalName());
        }
    }

    public Collection<NameMapping> getNameMappings() {
        ArrayList<NameMapping> mappings = new ArrayList<NameMapping>(this.appAttributeToIdpAttributeNameMapping.size());
        for (Map.Entry<String, String> e : this.appAttributeToIdpAttributeNameMapping.entrySet()) {
            mappings.add(new NameMapping(e.getKey(), e.getValue()));
        }
        return mappings;
    }

    public void addAttributeNameMapping(String appAttributeName, String idpAttributeName) {
        this.appAttributeToIdpAttributeNameMapping.put(appAttributeName, idpAttributeName);
        this.idpAttributeToAppAttributeNameMapping.put(idpAttributeName, appAttributeName);
    }

    private String getIdpAttributeName(String appAttributeName) {
        String translatedName = this.appAttributeToIdpAttributeNameMapping.get(appAttributeName);
        if (translatedName == null) {
            translatedName = appAttributeName;
        }
        return translatedName;
    }

    private String getAppAttributeName(String idpAttributeName) {
        String translatedName = this.idpAttributeToAppAttributeNameMapping.get(idpAttributeName);
        if (translatedName == null) {
            translatedName = idpAttributeName;
        }
        return translatedName;
    }

    public List<String> mapToIdpAttributeNames(String[] appAttributeNames) {
        ArrayList<String> idpAttributes = new ArrayList<String>();
        for (String name : appAttributeNames) {
            idpAttributes.add(this.getIdpAttributeName(name));
        }
        return idpAttributes;
    }

    public Map<String, AttributeValue> mapToAppAttributeNames(Map<String, AttributeValue> mapWithIdpNames) {
        HashMap<String, AttributeValue> mapWithAppNames = new HashMap<String, AttributeValue>(mapWithIdpNames.size());
        for (Map.Entry<String, AttributeValue> entry : mapWithIdpNames.entrySet()) {
            String appAttributeName = this.getAppAttributeName(entry.getKey());
            mapWithAppNames.put(appAttributeName, entry.getValue());
        }
        return mapWithAppNames;
    }

    public Map<String, String> getAppAttributeToIdpAttributeNameMapping() {
        return this.appAttributeToIdpAttributeNameMapping;
    }

    public AttributeNameMapping clone() {
        AttributeNameMapping clone = new AttributeNameMapping();
        clone.appAttributeToIdpAttributeNameMapping = new HashMap<String, String>(this.appAttributeToIdpAttributeNameMapping);
        clone.idpAttributeToAppAttributeNameMapping = new HashMap<String, String>(this.idpAttributeToAppAttributeNameMapping);
        return clone;
    }

    public static class NameMapping {
        private String localName;
        private String remoteName;

        public NameMapping() {
            this("", "");
        }

        public NameMapping(String localName, String remoteName) {
            this.localName = localName;
            this.remoteName = remoteName;
        }

        public NameMapping(NameMapping other) {
            this(other.getLocalName(), other.getRemoteName());
        }

        public String getRemoteName() {
            return this.remoteName;
        }

        public void setRemoteName(String remoteName) {
            this.remoteName = StringUtils.stripToEmpty((String)remoteName);
        }

        public String getLocalName() {
            return this.localName;
        }

        public void setLocalName(String localName) {
            this.localName = StringUtils.stripToEmpty((String)localName);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NameMapping that = (NameMapping)o;
            if (this.localName != null ? !this.localName.equals(that.localName) : that.localName != null) {
                return false;
            }
            return !(this.remoteName == null ? that.remoteName != null : !this.remoteName.equals(that.remoteName));
        }

        public int hashCode() {
            int result = this.localName != null ? this.localName.hashCode() : 0;
            result = 29 * result + (this.remoteName != null ? this.remoteName.hashCode() : 0);
            return result;
        }
    }
}

