/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import org.apache.commons.lang.StringUtils;

public class AuthnApiApplication
implements Serializable {
    private String id;
    private String url;
    private String description;
    private List<String> corsList = new ArrayList<String>();
    private String name;
    private String clientIdForRedirectlessMode;

    public AuthnApiApplication() {
    }

    public AuthnApiApplication(AuthnApiApplication copyFrom) {
        this.id = copyFrom.id;
        this.url = copyFrom.url;
        this.description = copyFrom.description;
        if (copyFrom.corsList != null) {
            this.corsList = new ArrayList<String>(copyFrom.corsList);
        }
        this.name = copyFrom.name;
        this.clientIdForRedirectlessMode = copyFrom.clientIdForRedirectlessMode;
    }

    @XmlAttribute
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @XmlAttribute
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @XmlAttribute
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @XmlElement(name="corsUrl")
    public List<String> getCorsList() {
        return this.corsList;
    }

    public void setCorsList(List<String> corsList) {
        this.corsList = corsList;
    }

    @XmlAttribute
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlAttribute
    public String getClientIdForRedirectlessMode() {
        return this.clientIdForRedirectlessMode;
    }

    public void setClientIdForRedirectlessMode(String clientIdForRedirectlessMode) {
        this.clientIdForRedirectlessMode = clientIdForRedirectlessMode;
    }

    public String toString() {
        return this.name + "(" + this.id + ")";
    }

    public List<String> getAllAllowedOrigins() {
        ArrayList<String> allowedOrigins = new ArrayList<String>();
        try {
            String baseUrl = AuthnApiApplication.getOriginFromUrl(this.url);
            if (StringUtils.isNotBlank((String)baseUrl)) {
                allowedOrigins.add(baseUrl);
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Unexpected error extracting origin from URL", e);
        }
        if (this.corsList != null) {
            allowedOrigins.addAll(this.corsList);
        }
        return allowedOrigins;
    }

    public static String getOriginFromUrl(String appUrl) throws MalformedURLException {
        URL url = new URL(appUrl);
        return url.getProtocol() + "://" + url.getAuthority();
    }
}

