/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain;

import com.pingidentity.sdk.AuthenticationSelectorDescriptor;
import com.pingidentity.sdk.PluginDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.sourceid.common.Util;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.domain.BasePluginInstance;

public class AuthnSelectorInstance
extends BasePluginInstance {
    private static final long serialVersionUID = 1L;

    public boolean hasAdditionalResults() {
        PluginDescriptor descriptor = this.getDescriptor();
        if (descriptor instanceof AuthenticationSelectorDescriptor) {
            List additionalResults = ((AuthenticationSelectorDescriptor)descriptor).getAdditionalResults(this.getConfiguration());
            return !Util.isEmpty(additionalResults);
        }
        return false;
    }

    public boolean isAnyEnabled() {
        PluginDescriptor descriptor = this.getDescriptor();
        if (descriptor instanceof AuthenticationSelectorDescriptor) {
            return ((AuthenticationSelectorDescriptor)descriptor).isAnyMatchEnabled(this.getConfiguration());
        }
        return false;
    }

    public boolean isSortConfigurationAttributes() {
        PluginDescriptor descriptor = this.getDescriptor();
        if (descriptor instanceof AuthenticationSelectorDescriptor) {
            return ((AuthenticationSelectorDescriptor)descriptor).isSortConfigurationAttributes(this.getConfiguration());
        }
        return false;
    }

    public List<String> getOrderedResults() {
        if (this.hasAdditionalResults()) {
            ArrayList<String> results = new ArrayList<String>();
            if (!this.isAnyEnabled()) {
                results.addAll(this.getAttributeContract().getSortedMutableAttributeNames());
            }
            if (this.isSortConfigurationAttributes()) {
                results.addAll(this.getAttributeContract().getSortedImmutableAttributeNames());
            } else {
                results.addAll(this.getAttributeContract().getImmutableAttributeNames());
            }
            return results;
        }
        return this.getAttributeContract().getAllAttrNamesSorted();
    }

    public int compareResultValues(String result1, String result2) {
        if (result1 == null && result2 == null) {
            return 0;
        }
        if (result1 == null) {
            return -1;
        }
        if (result2 == null) {
            return 1;
        }
        List<String> orderedResultValues = this.getOrderedResults();
        int result1Index = orderedResultValues.indexOf(result1);
        int result2Index = orderedResultValues.indexOf(result2);
        if (result1Index == -1 || result2Index == -1) {
            return result1.compareToIgnoreCase(result2);
        }
        return Integer.compare(result1Index, result2Index);
    }

    @Override
    protected List<String> getAdditionalCoreAttributeNames(Configuration configuration) {
        List additionalResults;
        List additionalAttrNames = Collections.emptyList();
        PluginDescriptor descriptor = this.getDescriptor();
        if (descriptor == null) {
            return additionalAttrNames;
        }
        if (descriptor instanceof AuthenticationSelectorDescriptor && (additionalResults = ((AuthenticationSelectorDescriptor)descriptor).getAdditionalResults(configuration)) != null) {
            additionalAttrNames = additionalResults;
        }
        return additionalAttrNames;
    }
}

