/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain;

import com.pingidentity.common.util.xml.XmlIDUtil;
import com.pingidentity.crypto.Cert;
import com.pingidentity.crypto.PkCert;
import com.pingidentity.module.connection.ConnectionModuleConfiguration;
import com.pingidentity.util.DateUtil;
import java.io.Serializable;
import java.net.URL;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.xmlbeans.XmlCalendar;
import org.apache.xmlbeans.impl.util.HexBin;
import org.sourceid.common.HashAlgorithm;
import org.sourceid.common.HashUtil;
import org.sourceid.config.ConfigurationException;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.config.SoapAuthInfo;
import org.sourceid.oauth20.domain.ParamValues;
import org.sourceid.oauth20.handlers.HandlerUtil;
import org.sourceid.saml20.bindings.BindingService;
import org.sourceid.saml20.domain.AttributeContract;
import org.sourceid.saml20.domain.ConfigAbstract;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.ConnectionCerts;
import org.sourceid.saml20.domain.ContactInfo;
import org.sourceid.saml20.domain.EnabledProfiles;
import org.sourceid.saml20.domain.EncryptionSettings;
import org.sourceid.saml20.domain.Endpoint;
import org.sourceid.saml20.domain.EndpointGroup;
import org.sourceid.saml20.domain.Endpoints;
import org.sourceid.saml20.domain.Entity;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.InCertAuthInfo;
import org.sourceid.saml20.domain.IncomingBindings;
import org.sourceid.saml20.domain.IndexedEndpoints;
import org.sourceid.saml20.domain.ItemReplicationStatus;
import org.sourceid.saml20.domain.KeyRotationSettings;
import org.sourceid.saml20.domain.LoggingMode;
import org.sourceid.saml20.domain.MessageCustomization;
import org.sourceid.saml20.domain.Organization;
import org.sourceid.saml20.domain.UrlWhitelistEntry;
import org.sourceid.saml20.domain.VirtualIdentity;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.PluginManagementSupport;
import org.sourceid.saml20.metadata.Role;
import org.sourceid.util.license.LicenseObject;
import org.sourceid.util.log.AttributeMap;
import org.sourceid.websso.Protocol;
import org.sourceid.websso.domain.trans.DomainTranslator;

public abstract class ConnectionBase
extends ConfigAbstract
implements Serializable,
LicenseObject {
    private static final long serialVersionUID = 4303544867158580366L;
    private static final int DEFAULT_ARTIFACT_TIMEOUT = 60;
    private Protocol protocol = Protocol.SAML20;
    private String name;
    private String entityId;
    private String entityIdOnDisk;
    private byte[] sourceId;
    private byte[] sourceIdOnDisk;
    private boolean active;
    private Calendar lastModified = null;
    private Calendar creationTime = null;
    private Calendar selectiveReplicationTime = null;
    private IndexedEndpoints artifactResolutionServices = new IndexedEndpoints();
    private EndpointGroup singleLogoutServices = new EndpointGroup();
    private EndpointGroup manageNameIdService = new EndpointGroup();
    private String signingKeyAlias;
    private PkCert signingKey;
    private Map<String, PkCert> altSigningKeyAliasToCertMap;
    private String signingAlgorithm = null;
    private int artifactTimeoutSeconds = 60;
    private AttributeContract attributeContract;
    private String incomingSLOBinding;
    private SoapAuthInfo soapAuthIn = new SoapAuthInfo(null);
    private SoapAuthInfo soapAuthOut = new SoapAuthInfo(null);
    private ConnectionCerts dsigVerificationCerts = new ConnectionCerts();
    private Organization organization = null;
    private ContactInfo contactInfo;
    private String incomingSSOBinding;
    private boolean includeAdditionalAttributes = false;
    private IncomingBindings incomingBindings = new IncomingBindings();
    private EnabledProfiles enabledProfiles = new EnabledProfiles();
    private EncryptionSettings encryptionSettings = new EncryptionSettings();
    private KeyRotationSettings signingKeyRotationSettings;
    private boolean copiedConnection;
    private URL baseUrl;
    private boolean includeCertInXmlSigs;
    private boolean includeRawKeyInXmlSigs;
    private X500Principal dsigVerificationExpectedSubjectDN;
    private X500Principal dsigVerificationExpectedIssuerDN;
    protected ConnectionType connectiontype = ConnectionType.STATIC;
    protected LoggingMode loggingMode = LoggingMode.STANDARD;
    private VirtualIdentity defaultVirtualIdentity = new VirtualIdentity();
    private List<VirtualIdentity> virtualIdentities = new ArrayList<VirtualIdentity>();
    private List<ConnectionModuleConfiguration> connectionModuleConfigurations = null;
    private String licenseConnectionGroupAssignment = null;
    private Map<String, String> connectionTemplateProperties = new HashMap<String, String>();
    private Set<Protocol> protocolsSupportedByPartner = null;
    private List<UrlWhitelistEntry> redirectValidationWhitelist = new ArrayList<UrlWhitelistEntry>();
    private Map<String, MessageCustomization> messageCustomizationHooks = new HashMap<String, MessageCustomization>();
    private Map<String, MessageCustomization> wsTrustMessageCustomizationHooks = new HashMap<String, MessageCustomization>();
    private String metadataUrlId = null;
    private boolean enableAutoMetadataUpdate;
    private String fileSystemPath;
    private boolean partnerCertsMigrated = false;
    private boolean allowAdditionalEntities = false;
    private boolean allowAllEntities = false;
    private boolean alwaysSignArtifactResponse = false;
    private List<Entity> additionalAllowedEntities = new ArrayList<Entity>();
    private Map<String, ParamValues> extendedProperties = new LinkedHashMap<String, ParamValues>();
    public static Comparator<ConnectionBase> COMPARE_BY_LAST_MODIFIED = new Comparator<ConnectionBase>(){

        @Override
        public int compare(ConnectionBase conn1, ConnectionBase conn2) {
            int retV = conn1.getLastModified() == null ? -1 : (conn2.getLastModified() == null ? 1 : conn1.getLastModified().compareTo(conn2.getLastModified()) * -1);
            return retV;
        }
    };
    public static Comparator<ConnectionBase> COMPARE_BY_ENTITY_ID = new Comparator<ConnectionBase>(){

        @Override
        public int compare(ConnectionBase conn1, ConnectionBase conn2) {
            return conn1.getEntityId().compareTo(conn2.getEntityId());
        }
    };

    public ConnectionBase() {
        this((String)null);
    }

    public ConnectionBase(String entityId) {
        this.entityId = entityId;
    }

    public ConnectionBase(ConnectionBase connBase) {
        this.protocol = connBase.getProtocol();
        this.name = connBase.name;
        this.entityId = connBase.entityId;
        this.entityIdOnDisk = connBase.entityIdOnDisk;
        this.sourceId = connBase.sourceId;
        this.sourceIdOnDisk = connBase.sourceIdOnDisk;
        this.active = connBase.active;
        this.lastModified = connBase.lastModified;
        this.creationTime = connBase.creationTime;
        this.selectiveReplicationTime = connBase.selectiveReplicationTime;
        this.artifactResolutionServices = connBase.artifactResolutionServices;
        this.singleLogoutServices = connBase.singleLogoutServices != null ? connBase.singleLogoutServices.clone() : null;
        this.manageNameIdService = connBase.manageNameIdService != null ? connBase.manageNameIdService.clone() : null;
        this.signingKeyAlias = connBase.signingKeyAlias;
        this.signingKey = connBase.signingKey != null ? new PkCert(connBase.signingKey) : null;
        this.altSigningKeyAliasToCertMap = connBase.altSigningKeyAliasToCertMap != null ? new HashMap<String, PkCert>(connBase.altSigningKeyAliasToCertMap) : null;
        this.signingAlgorithm = connBase.signingAlgorithm;
        this.artifactTimeoutSeconds = connBase.artifactTimeoutSeconds;
        this.attributeContract = connBase.attributeContract != null ? new AttributeContract(connBase.attributeContract) : null;
        this.incomingSLOBinding = connBase.incomingSLOBinding;
        this.soapAuthIn = connBase.soapAuthIn != null ? connBase.soapAuthIn.clone() : null;
        this.soapAuthOut = connBase.soapAuthOut != null ? connBase.soapAuthOut.clone() : null;
        this.dsigVerificationCerts = connBase.dsigVerificationCerts != null ? connBase.dsigVerificationCerts.clone() : null;
        this.organization = connBase.organization != null ? connBase.organization.clone() : null;
        this.contactInfo = connBase.contactInfo != null ? connBase.contactInfo.clone() : null;
        this.incomingSSOBinding = connBase.incomingSSOBinding;
        this.includeAdditionalAttributes = connBase.includeAdditionalAttributes;
        this.incomingBindings = connBase.incomingBindings;
        this.enabledProfiles = connBase.enabledProfiles != null ? connBase.enabledProfiles.clone() : null;
        this.encryptionSettings = connBase.encryptionSettings != null ? connBase.encryptionSettings.clone() : null;
        this.signingKeyRotationSettings = connBase.signingKeyRotationSettings != null ? connBase.signingKeyRotationSettings.clone() : null;
        this.baseUrl = connBase.baseUrl;
        this.includeCertInXmlSigs = connBase.includeCertInXmlSigs;
        this.includeRawKeyInXmlSigs = connBase.includeRawKeyInXmlSigs;
        this.dsigVerificationExpectedSubjectDN = connBase.dsigVerificationExpectedSubjectDN;
        this.dsigVerificationExpectedIssuerDN = connBase.dsigVerificationExpectedIssuerDN;
        this.loggingMode = connBase.loggingMode;
        this.defaultVirtualIdentity = connBase.defaultVirtualIdentity != null ? new VirtualIdentity(connBase.defaultVirtualIdentity) : null;
        this.virtualIdentities = new ArrayList<VirtualIdentity>(connBase.virtualIdentities);
        this.setId(connBase.getId());
        this.connectionTemplateProperties = connBase.connectionTemplateProperties != null ? new HashMap<String, String>(connBase.connectionTemplateProperties) : null;
        this.copiedConnection = connBase.copiedConnection;
        this.connectiontype = connBase.connectiontype;
        this.connectionModuleConfigurations = connBase.connectionModuleConfigurations != null ? new ArrayList<ConnectionModuleConfiguration>(connBase.connectionModuleConfigurations) : null;
        this.licenseConnectionGroupAssignment = connBase.licenseConnectionGroupAssignment;
        HashSet<Protocol> hashSet = this.protocolsSupportedByPartner = connBase.protocolsSupportedByPartner != null ? new HashSet<Protocol>(connBase.protocolsSupportedByPartner) : null;
        if (connBase.redirectValidationWhitelist != null) {
            this.redirectValidationWhitelist = new ArrayList<UrlWhitelistEntry>(connBase.redirectValidationWhitelist);
        }
        this.messageCustomizationHooks = new HashMap<String, MessageCustomization>(connBase.messageCustomizationHooks);
        this.metadataUrlId = connBase.metadataUrlId;
        this.enableAutoMetadataUpdate = connBase.enableAutoMetadataUpdate;
        this.fileSystemPath = connBase.fileSystemPath;
        this.partnerCertsMigrated = connBase.partnerCertsMigrated;
        this.allowAdditionalEntities = connBase.allowAdditionalEntities;
        this.allowAllEntities = connBase.allowAllEntities;
        this.additionalAllowedEntities = connBase.additionalAllowedEntities;
        this.extendedProperties = connBase.extendedProperties;
        this.wsTrustMessageCustomizationHooks = connBase.wsTrustMessageCustomizationHooks;
        this.alwaysSignArtifactResponse = connBase.alwaysSignArtifactResponse;
    }

    public void assignId() {
        this.setId(XmlIDUtil.createID());
    }

    public void setSourceId(byte[] sourceId) {
        this.sourceId = sourceId;
    }

    public void setSourceIdString(String s) {
        byte[] bytes = HexBin.stringToBytes((String)s);
        if (bytes != null && bytes.length == 20) {
            this.sourceId = bytes;
        }
    }

    public String getSourceIdString() {
        return this.hasNonStandardSourceId() ? HexBin.bytesToString((byte[])this.sourceId) : "";
    }

    public boolean hasNonStandardSourceId() {
        return this.sourceId != null;
    }

    public byte[] getSourceId() {
        return this.hasNonStandardSourceId() ? this.sourceId : HashUtil.hashToBytes((String)this.entityId, (HashAlgorithm)HashAlgorithm.SHA1);
    }

    public void setSourceIdOnDisk(byte[] sourceIdOnDisk) {
        this.sourceIdOnDisk = sourceIdOnDisk;
    }

    public byte[] getSourceIdOnDisk() {
        return this.sourceIdOnDisk;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public URL getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(URL baseUrl) {
        this.baseUrl = baseUrl;
    }

    public boolean isIncludeCertInXmlSigs() {
        return this.includeCertInXmlSigs || this.protocol == Protocol.WSFED;
    }

    public void setIncludeCertInXmlSigs(boolean includeCertInXmlSigs) {
        this.includeCertInXmlSigs = includeCertInXmlSigs;
    }

    public boolean isIncludeRawKeyInXmlSigs() {
        return this.includeRawKeyInXmlSigs && this.isIncludeCertInXmlSigs();
    }

    public void setIncludeRawKeyInXmlSigs(boolean includeRawKeyInXmlSigs) {
        this.includeRawKeyInXmlSigs = includeRawKeyInXmlSigs;
    }

    public boolean isUsingDynamicDsigTrust() {
        return this.dsigVerificationExpectedSubjectDN != null;
    }

    public X500Principal getDsigVerificationExpectedSubjectDN() {
        return this.dsigVerificationExpectedSubjectDN;
    }

    public String getStringDsigVerificationExpectedSubjectDNas() {
        return this.dsigVerificationExpectedSubjectDN == null ? null : this.dsigVerificationExpectedSubjectDN.toString();
    }

    public void setDsigVerificationExpectedSubjectDN(X500Principal dsigVerificationExpectedSubjectDN) {
        this.dsigVerificationExpectedSubjectDN = dsigVerificationExpectedSubjectDN;
    }

    public void setDsigVerificationExpectedSubjectDN(String subjectDN) {
        this.dsigVerificationExpectedSubjectDN = !StringUtils.isBlank((String)subjectDN) ? new X500Principal(subjectDN) : null;
    }

    public X500Principal getDsigVerificationExpectedIssuerDN() {
        return this.dsigVerificationExpectedIssuerDN;
    }

    public String getStringDsigVerificationExpectedIssuerDNas() {
        return this.dsigVerificationExpectedIssuerDN == null ? null : this.dsigVerificationExpectedIssuerDN.toString();
    }

    public void setDsigVerificationExpectedIssuerDN(X500Principal dsigVerificationExpectedIssuerDN) {
        this.dsigVerificationExpectedIssuerDN = dsigVerificationExpectedIssuerDN;
    }

    public void setDsigVerificationExpectedIssuerDN(String issuerDN) {
        this.dsigVerificationExpectedIssuerDN = !StringUtils.isBlank((String)issuerDN) ? new X500Principal(issuerDN) : null;
    }

    public Endpoint getArtifactResolutionService(int index) {
        return this.artifactResolutionServices.getEndpoint(index);
    }

    public IndexedEndpoints getArtifactResolutionServices() {
        return this.artifactResolutionServices;
    }

    public void setArtifactResolutionServices(IndexedEndpoints artifactResolutionServices) {
        this.artifactResolutionServices = artifactResolutionServices;
    }

    public Endpoint getPreferredSingleLogoutService() {
        return this.singleLogoutServices.getPrimaryEndpoint();
    }

    public Endpoint getPreferredSingleLogoutService(boolean backChannelBinding) {
        BindingService bindingService = GlobalRegistry.getService(BindingService.class);
        for (Endpoint endpoint : this.singleLogoutServices.getEndpoints()) {
            if (backChannelBinding != bindingService.isBackChannelBinding(endpoint.getBinding())) continue;
            return endpoint;
        }
        String fb = backChannelBinding ? "back" : "front";
        throw new ConfigurationException(this.entityId + " has no SingleLogoutService endpoint for the " + fb + " channel");
    }

    public boolean supportsBackChannelSingleLogout() {
        BindingService bindingService = GlobalRegistry.getService(BindingService.class);
        for (Endpoint endpoint : this.singleLogoutServices.getEndpoints()) {
            if (!bindingService.isBackChannelBinding(endpoint.getBinding())) continue;
            return true;
        }
        return false;
    }

    public EndpointGroup getSingleLogoutServices() {
        return this.singleLogoutServices;
    }

    public void setSingleLogoutServices(EndpointGroup singleLogoutServices) {
        this.singleLogoutServices = singleLogoutServices;
    }

    public Endpoint getManageNameIdService() {
        return this.manageNameIdService.getPrimaryEndpoint();
    }

    public void setManageNameIdService(Endpoint svc) {
        this.manageNameIdService = new EndpointGroup(svc);
    }

    public PkCert getSigningPkCert() {
        return this.signingKey;
    }

    public PrivateKey getSigningKey() {
        return this.signingKey != null ? this.signingKey.getPrivateKey() : null;
    }

    public void setSigningKey(PkCert signingPkCert) {
        this.signingKey = signingPkCert;
    }

    public String getSigningAlgorithm() {
        return this.signingAlgorithm;
    }

    public void setSigningAlgorithm(String signingAlgorithm) {
        this.signingAlgorithm = signingAlgorithm;
    }

    public int getArtifactTimeoutSeconds() {
        return this.artifactTimeoutSeconds;
    }

    public void setArtifactTimeoutSeconds(int artifactTimeoutSeconds) {
        this.artifactTimeoutSeconds = artifactTimeoutSeconds;
    }

    public String getSigningKeyAlias() {
        return this.signingKeyAlias;
    }

    public void setSigningKeyAlias(String signingKeyAlias) {
        this.signingKeyAlias = signingKeyAlias;
    }

    public String getSecondarySigningKeyAlias() {
        if (this.altSigningKeyAliasToCertMap != null) {
            return this.altSigningKeyAliasToCertMap.keySet().stream().findFirst().orElse(null);
        }
        return null;
    }

    public void setAltSigningKeyAliasToCertMap(Map<String, PkCert> altSigningKeyAliasToCertMap) {
        this.altSigningKeyAliasToCertMap = altSigningKeyAliasToCertMap != null ? new HashMap<String, PkCert>(altSigningKeyAliasToCertMap) : null;
    }

    public void addAltSigningKeyAlias(String altSigningKeyAlias, PkCert altSigningCert) {
        if (this.altSigningKeyAliasToCertMap == null) {
            this.altSigningKeyAliasToCertMap = new HashMap<String, PkCert>();
        }
        this.altSigningKeyAliasToCertMap.put(altSigningKeyAlias, altSigningCert);
    }

    public Map<String, PkCert> getAltSigningKeyAliasToCertMap() {
        return this.altSigningKeyAliasToCertMap != null ? new HashMap<String, PkCert>(this.altSigningKeyAliasToCertMap) : null;
    }

    public Cert getSigningKeyCertificate() {
        return this.signingKey;
    }

    public AttributeContract getAttributeContract() {
        return this.attributeContract;
    }

    public void setAttributeContract(AttributeContract attributeContract) {
        this.attributeContract = attributeContract;
    }

    public String getIncomingSLOBinding() {
        return this.incomingSLOBinding;
    }

    public void setIncomingSLOBinding(String incomingSLOBinding) {
        this.incomingSLOBinding = incomingSLOBinding;
    }

    public ConnectionCerts getDsigVerificationCerts() {
        return this.dsigVerificationCerts;
    }

    public void setDsigVerificationCerts(ConnectionCerts dsigVerificationCerts) {
        this.dsigVerificationCerts = dsigVerificationCerts;
    }

    public Organization getOrganization() {
        return this.organization;
    }

    public void setOrganization(Organization organization) {
        this.organization = organization;
    }

    public ContactInfo getContactInfo() {
        return this.contactInfo;
    }

    public void setContactInfo(ContactInfo contactInfo) {
        this.contactInfo = contactInfo;
    }

    public String getIncomingSSOBinding() {
        return this.incomingSSOBinding;
    }

    public void setIncomingSSOBinding(String incomingSSOBinding) {
        this.incomingSSOBinding = incomingSSOBinding;
    }

    public boolean isIncludeAdditionalAttributes() {
        return this.includeAdditionalAttributes;
    }

    public void setIncludeAdditionalAttributes(boolean includeAdditionalAttributes) {
        this.includeAdditionalAttributes = includeAdditionalAttributes;
    }

    public EnabledProfiles getEnabledProfiles() {
        return this.enabledProfiles;
    }

    public void setEnabledProfiles(EnabledProfiles enabledProfiles) {
        this.enabledProfiles = enabledProfiles;
    }

    public IncomingBindings getIncomingBindings() {
        return this.incomingBindings;
    }

    public void setIncomingBindings(IncomingBindings incomingBindings) {
        this.incomingBindings = incomingBindings;
    }

    public ConnectionType getConnectiontype() {
        return this.connectiontype;
    }

    public void setConnectiontype(ConnectionType connectiontype) {
        this.connectiontype = connectiontype;
    }

    public abstract Role getRoleType();

    protected abstract Endpoints getEndpoints();

    public boolean usesBindingsOutbound(String ... bindings) {
        ArrayList<Endpoint> allOfEm = new ArrayList<Endpoint>();
        allOfEm.addAll(this.getArtifactResolutionServices().getEndpoints());
        allOfEm.addAll(this.getSingleLogoutServices().getEndpoints());
        allOfEm.addAll(this.getEndpoints().getEndpoints());
        HashSet<String> allBindings = new HashSet<String>();
        for (Endpoint endPt : allOfEm) {
            allBindings.add(endPt.getBinding());
        }
        for (String binding : bindings) {
            if (!allBindings.contains(binding)) continue;
            return true;
        }
        return false;
    }

    public String getEncodedEntityId() {
        Role roleType = this.getRoleType();
        return roleType.encode(this.entityId);
    }

    public boolean supportsSLO() {
        EnabledProfiles enabledProfiles = this.getEnabledProfiles();
        return enabledProfiles.isIdpInitiatedSLOEnabled() || enabledProfiles.isSpInitiatedSLOEnabled();
    }

    public Calendar getLastModified() {
        return DateUtil.convertCalendar(this.lastModified);
    }

    public void setLastModified(Calendar lastModified) {
        this.lastModified = lastModified;
    }

    public Calendar getCreationTime() {
        return DateUtil.convertCalendar(this.creationTime);
    }

    public void setCreationTime(Calendar creationTime) {
        this.creationTime = creationTime;
    }

    public Calendar getSelectiveReplicationTime() {
        return DateUtil.copyCalendar(this.selectiveReplicationTime);
    }

    public void setSelectiveReplicationTime(Calendar selectiveReplicationTime) {
        this.selectiveReplicationTime = DateUtil.copyCalendar(selectiveReplicationTime);
    }

    public ItemReplicationStatus getReplicationStatus() {
        XmlCalendar fullReplicationTime;
        boolean replicated = MgmtFactory.getMediator().getConfigPublishDate() != null ? (fullReplicationTime = new XmlCalendar(MgmtFactory.getMediator().getConfigPublishDate())).after(this.getLastModified()) || this.selectiveReplicationTime != null && this.selectiveReplicationTime.after(this.getLastModified()) : false;
        return replicated ? ItemReplicationStatus.REPLICATED : ItemReplicationStatus.NOT_REPLICATED;
    }

    public EncryptionSettings getEncryptionSettings() {
        return this.encryptionSettings;
    }

    public void setEncryptionSettings(EncryptionSettings encryptionSettings) {
        this.encryptionSettings = encryptionSettings;
    }

    public KeyRotationSettings getSigningKeyRotationSettings() {
        return this.signingKeyRotationSettings;
    }

    public void setSigningKeyRotationSettings(KeyRotationSettings signingKeyRotationSettings) {
        this.signingKeyRotationSettings = signingKeyRotationSettings;
    }

    public SoapAuthInfo getSoapAuthIn() {
        this.soapAuthIn.setEntityId(this.getEncodedEntityId());
        return this.soapAuthIn;
    }

    public void setSoapAuthIn(SoapAuthInfo soapAuthIn) {
        this.soapAuthIn = soapAuthIn;
    }

    public ConnectionCerts getClientAuthCerts() {
        SoapAuthInfo soapAuthIn = this.getSoapAuthIn();
        SoapAuthInfo.CertAuthInfo certAuthInfo = soapAuthIn.getCertAuthInfo();
        if (certAuthInfo instanceof InCertAuthInfo) {
            return ((InCertAuthInfo)certAuthInfo).getVerificationCerts();
        }
        return new ConnectionCerts();
    }

    public SoapAuthInfo getSoapAuthOut() {
        this.soapAuthOut.setEntityId(this.getEncodedEntityId());
        return this.soapAuthOut;
    }

    public void setSoapAuthOut(SoapAuthInfo soapAuthOut) {
        this.soapAuthOut = soapAuthOut;
    }

    public abstract LoggingMode getLoggingMode();

    public LoggingMode getConfiguredLogMode() {
        return this.loggingMode;
    }

    public void setLoggingMode(LoggingMode loggingMode) {
        this.loggingMode = loggingMode;
    }

    public VirtualIdentity getDefaultVirtualIdentity() {
        return this.defaultVirtualIdentity;
    }

    public void setDefaultVirtualIdentity(VirtualIdentity defaultVirtualIdentity) {
        this.defaultVirtualIdentity = defaultVirtualIdentity;
    }

    public List<VirtualIdentity> getVirtualIdentities() {
        return this.virtualIdentities;
    }

    public void setVirtualIdentities(List<VirtualIdentity> virtualIdentities) {
        this.virtualIdentities = virtualIdentities == null ? Collections.emptyList() : virtualIdentities;
    }

    public boolean hasExpressions() {
        return this.specificHasExpressions() || !this.getMessageCustomizationHooks().isEmpty() || !this.getWsTrustMessageCustomizationHooks().isEmpty();
    }

    abstract boolean specificHasExpressions();

    public List<ConnectionModuleConfiguration> getConnectionModuleConfigurations() {
        return this.connectionModuleConfigurations;
    }

    public void setConnectionModuleConfigurations(List<ConnectionModuleConfiguration> connectionModuleConfigurations) {
        this.connectionModuleConfigurations = connectionModuleConfigurations;
    }

    public <T extends ConnectionModuleConfiguration> T getModuleConfiguration(Class<T> moduleConfigType) {
        ConnectionModuleConfiguration moduleConfiguration = null;
        if (this.connectionModuleConfigurations != null) {
            for (ConnectionModuleConfiguration config : this.connectionModuleConfigurations) {
                if (!moduleConfigType.isInstance(config)) continue;
                moduleConfiguration = config;
                break;
            }
        }
        return (T)moduleConfiguration;
    }

    public boolean hasModuleConfiguration(String moduleId) {
        if (this.connectionModuleConfigurations != null) {
            for (ConnectionModuleConfiguration config : this.connectionModuleConfigurations) {
                if (!config.getModuleId().equals(moduleId)) continue;
                return true;
            }
        }
        return false;
    }

    public void addConnectionModuleConfiguration(ConnectionModuleConfiguration moduleConfigToAdd) {
        if (this.connectionModuleConfigurations == null) {
            this.connectionModuleConfigurations = new ArrayList<ConnectionModuleConfiguration>();
        }
        this.connectionModuleConfigurations.add(moduleConfigToAdd);
    }

    public boolean isCopiedConnection() {
        return this.copiedConnection;
    }

    public void setCopiedConnection(boolean copiedConnection) {
        this.copiedConnection = copiedConnection;
    }

    @Override
    public String getLicenseConnectionGroupAssignment() {
        return this.licenseConnectionGroupAssignment;
    }

    public void setLicenseConnectionGroupAssignment(String licenseConnectionGroupAssignment) {
        this.licenseConnectionGroupAssignment = licenseConnectionGroupAssignment;
    }

    public Map<String, String> getConnectionTemplateProperties() {
        return this.connectionTemplateProperties;
    }

    public void setConnectionTemplateProperties(Map<String, String> connectionTemplateProperties) {
        this.connectionTemplateProperties = connectionTemplateProperties;
    }

    public String getEntityIdOnDisk() {
        return this.entityIdOnDisk;
    }

    public void setEntityIdOnDisk(String entityIdOnDisk) {
        this.entityIdOnDisk = entityIdOnDisk;
    }

    public Set<Protocol> getProtocolsSupportedByPartner() {
        return this.protocolsSupportedByPartner;
    }

    public void setProtocolsSupportedByPartner(Set<Protocol> protocolsSupportedByPartner) {
        this.protocolsSupportedByPartner = protocolsSupportedByPartner;
    }

    public Map<String, MessageCustomization> getMessageCustomizationHooks() {
        return this.messageCustomizationHooks;
    }

    public Map<String, MessageCustomization> getWsTrustMessageCustomizationHooks() {
        return this.wsTrustMessageCustomizationHooks;
    }

    public abstract boolean doesWsTrustSettingsExist();

    public abstract boolean isBrowserSsoProfileConfigured();

    public abstract boolean doesInboundProvisioningExist();

    public abstract boolean doesInboundGroupProvisioningExist();

    public List<UrlWhitelistEntry> getRedirectValidationWhitelist() {
        return this.redirectValidationWhitelist;
    }

    public void setRedirectValidationWhitelist(List<UrlWhitelistEntry> redirectValidationWhitelist) {
        this.redirectValidationWhitelist = redirectValidationWhitelist;
    }

    public boolean hasMessageCustomizationHook(String contextName) {
        return this.getMessageCustomizationHooks().get(contextName) != null;
    }

    public boolean hasWsTrustMessageCustomizationHook(String contextName) {
        return this.getWsTrustMessageCustomizationHooks().get(contextName) != null;
    }

    public <T> T messageCustomize(String contextName, Class<T> type, HttpServletRequest req, HttpServletResponse resp, T message, String messageVariableName, Map<String, Object> moreContext) {
        MessageCustomization hook = this.getMessageCustomizationHooks().get(contextName);
        return MessageCustomization.customize(hook, type, req, resp, message, messageVariableName, moreContext, new HashMap<String, Object>());
    }

    public <T> T messageCustomize(String contextName, Class<T> type, HttpServletRequest req, HttpServletResponse resp, T message, String messageVariableName, Map<String, Object> moreContext, Map<String, Object> stateParams) {
        MessageCustomization hook = this.getMessageCustomizationHooks().get(contextName);
        return MessageCustomization.customize(hook, type, req, resp, message, messageVariableName, moreContext, stateParams);
    }

    public <T> T wsTrustmessageCustomize(String contextName, Class<T> type, HttpServletRequest req, HttpServletResponse resp, T message, String messageVariableName, Map<String, Object> moreContext) {
        MessageCustomization hook = this.getWsTrustMessageCustomizationHooks().get(contextName);
        return MessageCustomization.customize(hook, type, req, resp, message, messageVariableName, moreContext, new HashMap<String, Object>());
    }

    public boolean isArtifactSsoSloUsed() {
        DomainTranslator domainTranslator = DomainTranslator.getTranslator(this.getProtocol());
        String artifactUri = domainTranslator.toBindingUri("Artifact");
        return this.isSsoBindingUsed(artifactUri) || this.isSloBindingUsed(artifactUri);
    }

    public boolean isSsoBindingUsed(String binding) {
        DomainTranslator domainTranslator = DomainTranslator.getTranslator(this.getProtocol());
        String bindingUri = domainTranslator.toBindingUri(binding);
        for (Endpoint endpoint : this.getEndpoints().getEndpoints()) {
            if (!bindingUri.equals(endpoint.getBinding())) continue;
            return true;
        }
        return false;
    }

    public boolean isSloBindingUsed(String binding) {
        DomainTranslator domainTranslator = DomainTranslator.getTranslator(this.getProtocol());
        String bindingUri = domainTranslator.toBindingUri(binding);
        for (Endpoint endpoint : this.getSingleLogoutServices().getEndpoints()) {
            if (!bindingUri.equals(endpoint.getBinding())) continue;
            return true;
        }
        return false;
    }

    public boolean isInboundArtifact() {
        return this.getIncomingBindings().getArtifactBinding();
    }

    public boolean isAnySloSelected() {
        return this.getEnabledProfiles().isIdpInitiatedSLOEnabled() || this.getEnabledProfiles().isSpInitiatedSLOEnabled();
    }

    public boolean isSpSsoSelected() {
        return this.getEnabledProfiles().isSpInitiatedSSOEnabled();
    }

    public boolean isAnySsoSelected() {
        return this.getEnabledProfiles().isIdpInitiatedSSOEnabled() || this.getEnabledProfiles().isSpInitiatedSSOEnabled() || Protocol.SAML10 == this.getProtocol() || Protocol.SAML11 == this.getProtocol();
    }

    public String getMetadataUrlId() {
        return this.metadataUrlId;
    }

    public void setMetadataUrlId(String metadataUrlID) {
        this.metadataUrlId = metadataUrlID;
    }

    public boolean isEnableAutoMetadataUpdate() {
        return this.enableAutoMetadataUpdate;
    }

    public void setEnableAutoMetadataUpdate(boolean enableAutoReload) {
        this.enableAutoMetadataUpdate = enableAutoReload;
    }

    public Date getConnMetadataValidityDate() {
        Date validUntil = null;
        PkCert decryptCert = this.encryptionSettings.getDecryptionPkCert();
        if (this.signingKey != null) {
            validUntil = this.signingKey.getX509Certificate().getNotAfter();
            if (decryptCert != null && validUntil.after(decryptCert.getX509Certificate().getNotAfter())) {
                validUntil = decryptCert.getX509Certificate().getNotAfter();
            }
        } else if (decryptCert != null) {
            validUntil = decryptCert.getX509Certificate().getNotAfter();
        }
        return validUntil;
    }

    public boolean isOIDCConnection() {
        return this instanceof IdpConnection && ((IdpConnection)this).doesOIDCRPSettingsExist();
    }

    public String getFileSystemPath() {
        return this.fileSystemPath;
    }

    public void setFileSystemPath(String fileSystemPath) {
        this.fileSystemPath = fileSystemPath;
    }

    public boolean partnerCertsMigrated() {
        return this.partnerCertsMigrated;
    }

    public void setPartnerCertsMigrated(boolean alreadyMigrated) {
        this.partnerCertsMigrated = alreadyMigrated;
    }

    public boolean hasConnBasedPluginOverrides() {
        return !this.getConnBasedPluginOverrides().isEmpty();
    }

    public abstract Collection<ConfigurablePluginInstance> getConnBasedPluginOverrides(PluginManagementSupport.PluginManagementType var1);

    public Collection<ConfigurablePluginInstance> getConnBasedPluginOverrides() {
        return this.getConnBasedPluginOverrides(null);
    }

    public List<Entity> getAdditionalAllowedEntities() {
        return this.additionalAllowedEntities;
    }

    public void setAdditionalAllowedEntities(List<Entity> additionalEntities) {
        this.additionalAllowedEntities = additionalEntities;
    }

    public boolean isAllowAdditionalEntities() {
        return this.allowAdditionalEntities;
    }

    public void setAllowAdditionalEntities(boolean allowAdditionalEntities) {
        this.allowAdditionalEntities = allowAdditionalEntities;
    }

    public boolean isAllowAllEntities() {
        return this.allowAllEntities;
    }

    public void setAllowAllEntities(boolean allowAllEntities) {
        this.allowAllEntities = allowAllEntities;
    }

    public boolean isAlwaysSignArtifactResponse() {
        return this.alwaysSignArtifactResponse;
    }

    public void setAlwaysSignArtifactResponse(boolean signAllArtifactResponse) {
        this.alwaysSignArtifactResponse = signAllArtifactResponse;
    }

    public Map<String, ParamValues> getExtendedProperties() {
        return this.extendedProperties;
    }

    public void setExtendedProperties(Map<String, ParamValues> extendedProperties) {
        this.extendedProperties = extendedProperties;
    }

    protected void addExtendedPropertiesToContext(AttributeMap contextAttributes) {
        HandlerUtil.addExtPropertiesToAttrMap(this.getExtendedProperties(), contextAttributes);
    }

    public static enum ConnectionType {
        STATIC,
        DYNAMIC;

    }
}

