/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain;

import com.pingidentity.crypto.Cert;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class ConnectionCerts
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 20050515L;
    private Set<Cert> otherVerificationCerts = new HashSet<Cert>();
    private List<Cert> activeVerificationCerts = new ArrayList<Cert>();

    public Cert getActiveVerificationCert() {
        if (this.activeVerificationCerts == null || this.activeVerificationCerts.isEmpty()) {
            return null;
        }
        return this.activeVerificationCerts.get(0);
    }

    public Cert getSecondaryVerificationCert() {
        if (this.activeVerificationCerts == null || this.activeVerificationCerts.size() < 2) {
            return null;
        }
        return this.activeVerificationCerts.get(1);
    }

    public List<Cert> getActiveVerificationCerts() {
        return this.activeVerificationCerts;
    }

    private void removeFromActiveCertificates(Cert cert) {
        if (cert != null) {
            this.activeVerificationCerts.removeIf(cert::equals);
        }
    }

    public void setActiveVerificationCert(Cert activeVerificationCert) {
        if (activeVerificationCert != null) {
            this.removeFromActiveCertificates(activeVerificationCert);
            this.activeVerificationCerts.add(0, activeVerificationCert);
            this.doAdd(activeVerificationCert);
        } else {
            this.activeVerificationCerts = new ArrayList<Cert>();
        }
    }

    public void setSecondaryVerificationCert(Cert secondaryVerificationCert) {
        if (secondaryVerificationCert != null) {
            if (this.getActiveVerificationCert() == null) {
                throw new IllegalStateException("The primary verification cert must be set before setting the secondary verification cert");
            }
            if (secondaryVerificationCert.equals(this.getActiveVerificationCert())) {
                return;
            }
            this.removeFromActiveCertificates(secondaryVerificationCert);
            this.activeVerificationCerts.add(1, secondaryVerificationCert);
            this.doAdd(secondaryVerificationCert);
        } else {
            while (this.activeVerificationCerts.size() > 1) {
                this.activeVerificationCerts.remove(1);
            }
        }
    }

    public void addActiveVerificationCert(Cert cert) {
        if (cert != null) {
            this.removeFromActiveCertificates(cert);
            this.activeVerificationCerts.add(cert);
            this.doAdd(cert);
        }
    }

    private void doAdd(Cert c) {
        if (c != null) {
            this.otherVerificationCerts.remove(c);
            this.otherVerificationCerts.add(c);
        }
    }

    public void setOtherVerificationCerts(Set<Cert> allCerts) {
        this.otherVerificationCerts.clear();
        if (allCerts != null) {
            this.otherVerificationCerts.addAll(allCerts);
        }
    }

    public Set<Cert> getAllVerificationCerts() {
        return new HashSet<Cert>(this.otherVerificationCerts);
    }

    public void addInactiveVerificationCerts(Set<Cert> inactiveVerificationCerts) {
        this.otherVerificationCerts.addAll(inactiveVerificationCerts);
    }

    public void setActiveVerificationCerts(List<Cert> activeVerificationCerts) {
        if (activeVerificationCerts == null) {
            this.activeVerificationCerts = new ArrayList<Cert>();
        } else {
            this.activeVerificationCerts = activeVerificationCerts;
            for (Cert cert : activeVerificationCerts) {
                this.doAdd(cert);
            }
        }
    }

    public void setVerificationCerts(ArrayList<Cert> activeVerificationCertsCert, Set<Cert> otherCerts) {
        this.setOtherVerificationCerts(otherCerts);
        this.setActiveVerificationCerts(activeVerificationCertsCert);
    }

    public ConnectionCerts clone() {
        ConnectionCerts clone = new ConnectionCerts();
        clone.activeVerificationCerts = this.activeVerificationCerts == null || this.activeVerificationCerts.isEmpty() ? new ArrayList<Cert>() : (List)this.activeVerificationCerts.stream().map(Cert::new).collect(Collectors.toCollection(ArrayList::new));
        clone.otherVerificationCerts = this.otherVerificationCerts != null ? new HashSet<Cert>(this.otherVerificationCerts) : null;
        return clone;
    }
}

