/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class DNtoIdpMap {
    private String dn;
    private String idpId;
    private String idpName;

    public DNtoIdpMap() {
    }

    public DNtoIdpMap(String dn, String idpId) {
        this.setDn(dn);
        this.idpId = idpId;
        ConnectionManager connManager = MgmtFactory.getConnectionManager();
        IdpConnection connection = connManager.getIdpConnection(idpId);
        if (connection != null) {
            this.idpName = connection.getName();
        }
    }

    public DNtoIdpMap(String dn, String idpId, String idpName) {
        this.setDn(dn);
        this.idpId = idpId;
        this.idpName = idpName;
    }

    public DNtoIdpMap(DNtoIdpMap itemToCopy) {
        this.setDn(itemToCopy.getDn());
        this.idpId = itemToCopy.getIdpId();
        this.idpName = itemToCopy.getIdpName();
    }

    public String getDn() {
        return this.dn;
    }

    public void setDn(String dn) {
        this.dn = dn != null ? dn.toLowerCase() : null;
    }

    public String getIdpId() {
        return this.idpId;
    }

    public void setIdpId(String idpId) {
        this.idpId = idpId;
    }

    public String getIdpName() {
        return this.idpName;
    }

    public void setIdpName(String idpName) {
        this.idpName = idpName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DNtoIdpMap that = (DNtoIdpMap)o;
        if (!Objects.equals(this.dn, that.dn)) {
            return false;
        }
        return Objects.equals(this.idpId, that.idpId);
    }

    public int hashCode() {
        int result = this.dn != null ? this.dn.hashCode() : 0;
        result = 29 * result + (this.idpId != null ? this.idpId.hashCode() : 0);
        return result;
    }

    public String validateRegex() {
        try {
            Pattern.compile(this.dn);
            return null;
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    public boolean matches(String inputC14nDn) {
        Pattern pattern = Pattern.compile(this.dn);
        Matcher m = pattern.matcher(inputC14nDn);
        return m.matches();
    }
}

